<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Action;

use CB\Database\Table\UserTable;
use CB\Plugin\Invites\Table\InviteTable;
use CBLib\Language\CBTxt;
use CBLib\Registry\ParamsInterface;

\defined( 'CBLIB' ) or die();

class InviteAction extends Action
{

	/**
	 * @param UserTable $user
	 */
	public function execute( UserTable $user ): void
	{
		global $_CB_database;

		if ( ! $this->installed() ) {
			$this->error( CBTxt::T( 'AUTO_ACTION_INVITE_NOT_INSTALLED', ':: Action [action] :: CB Invites is not installed', [ '[action]' => $this->autoaction()->getId() ] ) );
			return;
		}

		foreach ( $this->autoaction()->getParams()->subTree( 'invite' ) as $row ) {
			/** @var ParamsInterface $row */
			$owner					=	$row->getString( 'owner', '' );

			if ( ! $owner ) {
				$owner				=	$user->getInt( 'id', 0 );
			} else {
				$owner				=	(int) $this->string( $user, $owner );
			}

			if ( ! $owner ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_INVITE_NO_OWNER', ':: Action [action] :: CB Invites skipped due to missing owner', [ '[action]' => $this->autoaction()->getId() ] ) );
				continue;
			}

			if ( $user->getInt( 'id', 0 ) !== $owner ) {
				$actionUser			=	\CBuser::getUserDataInstance( $owner );
			} else {
				$actionUser			=	$user;
			}

			switch ( $row->getInt( 'mode', 1 ) ) {
				case 1:
					$toArray		=	explode( ',', $this->string( $actionUser, $row->getString( 'to', '' ) ) );

					foreach ( $toArray as $to ) {
						$invite		=	new InviteTable();

						$invite->set( 'to', $to );
						$invite->set( 'user_id', $actionUser->getInt( 'id', 0 ) );

						if ( ! $invite->store() ) {
							$this->error( CBTxt::T( 'AUTO_ACTION_INVITE_FAILED', ':: Action [action] :: CB Invites failed to save. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $invite->getError() ] ) );
							continue;
						}

						if ( ! $invite->send() ) {
							$this->error( CBTxt::T( 'AUTO_ACTION_INVITE_SEND_FAILED', ':: Action [action] :: CB Invites failed to send. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $invite->getError() ] ) );
						}
					}
					break;
				case 2:
					$query			=	'SELECT *'
									.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_invites' )
									.	"\n WHERE " . $_CB_database->NameQuote( 'to' ) . " = " . $_CB_database->Quote( $actionUser->getString( 'email', '' ) );
					$_CB_database->setQuery( $query );
					$invites		=	$_CB_database->loadObjectList( null, '\CB\Plugin\Invites\Table\InviteTable', [ $_CB_database ] );

					/** @var InviteTable[] $invites */
					foreach ( $invites as $invite ) {
						$invite->accept( $actionUser );
					}
					break;
				case 3:
					$query			=	'SELECT *'
									.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_invites' )
									.	"\n WHERE ( " . $_CB_database->NameQuote( 'user_id' ) . " = " . $actionUser->getInt( 'id', 0 )
									.	' OR ' . $_CB_database->NameQuote( 'user' ) . ' = ' . $actionUser->getInt( 'id', 0 ) . ' )';
					$_CB_database->setQuery( $query );
					$invites		=	$_CB_database->loadObjectList( null, '\CB\Plugin\Invites\Table\InviteTable', [ $_CB_database ] );

					/** @var InviteTable[] $invites */
					foreach ( $invites as $invite ) {
						$invite->delete();
					}
					break;
			}
		}
	}

	/**
	 * @return bool
	 */
	public function installed(): bool
	{
		global $_PLUGINS;

		$plugin				=	$_PLUGINS->getLoadedPlugin( 'user', 'cbinvites' );

		if ( ! $plugin ) {
			return false;
		}

		$pluginVersion		=	str_replace( '+build.', '+', $_PLUGINS->getPluginVersion( $plugin, true ) );

		return ( version_compare( $pluginVersion, '5.0.0', '>=' ) && version_compare( $pluginVersion, '6.0.0', '<' ) );
	}
}