<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Action;

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CBLib\Registry\ParamsInterface;

\defined( 'CBLIB' ) or die();

class ContentAction extends Action
{

	/**
	 * @param UserTable $user
	 */
	public function execute( UserTable $user ): void
	{
		global $_CB_framework;

		foreach ( $this->autoaction()->getParams()->subTree( 'content' ) as $row ) {
			/** @var ParamsInterface $row */
			$owner					=	$row->getString( 'owner', '' );

			if ( ! $owner ) {
				$owner				=	$user->getInt( 'id', 0 );
			} else {
				$owner				=	(int) $this->string( $user, $owner );
			}

			if ( ! $owner ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_CONTENT_NO_OWNER', ':: Action [action] :: Content skipped due to missing owner', [ '[action]' => $this->autoaction()->getId() ] ) );
				continue;
			}

			if ( $user->getInt( 'id', 0 ) !== $owner ) {
				$actionUser			=	\CBuser::getUserDataInstance( $owner );
			} else {
				$actionUser			=	$user;
			}

			$mode					=	$row->getInt( 'mode', 1 );
			$title					=	$this->string( $actionUser, $row->getString( 'title', '' ) );
			$alias					=	$row->getString( 'alias', '' );

			if ( ! $alias ) {
				$alias				=	$title;
			} else {
				$alias				=	$this->string( $actionUser, $alias );
			}

			$alias					=	$this->cleanAlias( $alias );
			$introText				=	$this->string( $actionUser, $row->getRaw( 'introtext', '' ), false );
			$fullText				=	$this->string( $actionUser, $row->getRaw( 'fulltext', '' ), false );
			$metaDesc				=	$this->string( $actionUser, $row->getRaw( 'metadesc', '' ), false );
			$metaKey				=	$this->string( $actionUser, $row->getRaw( 'metakey', '' ), false );
			$access					=	$row->getInt( 'access', 1 );
			$published				=	$row->getInt( 'published', 1 );
			$featured				=	$row->getInt( 'featured', 0 );
			$language				=	$row->getString( 'language', '*' );

			if ( $mode === 1 ) {
				\JTable::addIncludePath( $_CB_framework->getCfg( 'absolute_path' ) . '/administrator/components/com_content/tables' );

				$category			=	$row->getInt( 'category_j' );
				$table				=	\JTable::getInstance( 'content' );

				while ( $table->load( [ 'alias' => $alias, 'catid' => $category ] ) ) {
					$matches		=	null;

					if ( preg_match( '#-(\d+)$#', $alias, $matches ) ) {
						$alias		=	preg_replace( '#-(\d+)$#', '-' . ( $matches[1] + 1 ) . '', $alias );
					} else {
						$alias		.=	'-2';
					}
				}

				/** @var \JTableContent $article */
				$article			=	\JTable::getInstance( 'content' );

				$article->set( 'created_by', $actionUser->getInt( 'id', 0 ) );
				$article->set( 'title', $title );
				$article->set( 'alias', $alias );
				$article->set( 'introtext', $introText );
				$article->set( 'fulltext', $fullText );
				$article->set( 'metadesc', $metaDesc );
				$article->set( 'metakey', $metaKey );
				$article->set( 'catid', $category );
				$article->set( 'access', $access );
				$article->set( 'state', $published );
				$article->set( 'featured', $featured );
				$article->set( 'ordering', 1 );
				$article->set( 'created', $_CB_framework->getUTCDate() );
				$article->set( 'language', $language );

				$article->set( 'images', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}' );
				$article->set( 'urls', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}' );
				$article->set( 'attribs', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}' );
				$article->set( 'metadata', '{"robots":"","author":"","rights":"","xreference":"","tags":""}' );

				if ( ! $article->store() ) {
					$this->error( CBTxt::T( 'AUTO_ACTION_CONTENT_FAILED', ':: Action [action] :: Content failed to save', [ '[action]' => $this->autoaction()->getId() ] ) );
					continue;
				}

				$article->reorder( '`catid` = ' . $category );

				if ( $article->get( 'featured' ) ) {
					$feature	=	\JTable::getInstance( 'Featured', 'ContentTable' );

					$feature->set( 'content_id', (int) $article->get( 'id' ) );
					$feature->set( 'ordering', 0 );

					if ( $feature->store() ) {
						$feature->reorder();
					}
				}
			} elseif ( ( $mode === 2 ) && $this->isK2Installed() ) {
				$category			=	$row->getInt( 'category_k' );

				/** @var \TableK2Item $article */
				$article			=	\JTable::getInstance( 'K2Item', 'Table' );

				$article->set( 'created_by', $actionUser->getInt( 'id', 0 ) );
				$article->set( 'title', $title );
				$article->set( 'alias', $alias );
				$article->set( 'introtext', $introText );
				$article->set( 'fulltext', $fullText );
				$article->set( 'metadesc', $metaDesc );
				$article->set( 'metakey', $metaKey );
				$article->set( 'catid', $category );
				$article->set( 'access', $access );
				$article->set( 'published', $published );
				$article->set( 'featured', $featured );
				$article->set( 'ordering', 1 );
				$article->set( 'created', $_CB_framework->getUTCDate() );
				$article->set( 'language', $language );

				if ( ! $article->store() ) {
					$this->error( CBTxt::T( 'AUTO_ACTION_CONTENT_FAILED', ':: Action [action] :: Content failed to save', [ '[action]' => $this->autoaction()->getId() ] ) );
					continue;
				}

				$article->reorder( '`catid` = ' . $category );
			}
		}
	}

	/**
	 * @return array
	 */
	public function k2Categories(): array
	{
		global $_CB_framework;

		$listCategories				=	[];

		if ( $this->isK2Installed() ) {
			require_once( $_CB_framework->getCfg( 'absolute_path' ) . '/administrator/components/com_k2/models/categories.php' );

			$categoryModel			=	new \K2ModelCategories();

			$categories				=	$categoryModel->categoriesTree( null, true, true );

			foreach ( $categories as $category ) {
				$listCategories[]	=	\moscomprofilerHTML::makeOption( (string) $category->value, $category->text );
			}
		}

		return $listCategories;
	}

	/**
	 * @return bool
	 */
	private function isK2Installed(): bool
	{
		global $_CB_framework;

		if ( is_dir( $_CB_framework->getCfg( 'absolute_path' ) . '/administrator/components/com_k2' ) && class_exists( 'K2Model' ) ) {
			\JTable::addIncludePath( $_CB_framework->getCfg( 'absolute_path' ) . '/administrator/components/com_k2/tables' );

			return true;
		}

		return false;
	}

	/**
	 * @param null|string $title
	 * @return string
	 */
	private function cleanAlias( ?string $title ): string
	{
		if ( ! $title ) {
			return '';
		}

		$alias	=	str_replace( '-', ' ', $title );
		$alias	=	trim( cbIsoUtf_strtolower( $alias ) );
		$alias	=	preg_replace( '/(\s|[^A-Za-z0-9\-])+/', '-', $alias );

		return trim( $alias, '-' );
	}
}