<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\TabTable;
use CB\Database\Table\UserTable;
use CB\Plugin\AutoActions\Table\AutoActionTable;
use CB\Plugin\AutoActions\Table\BatchTable;
use CBLib\Application\Application;
use CBLib\Registry\ParamsInterface;

\defined( 'CBLIB' ) or die();

class CBplug_cbautoactions extends cbPluginHandler
{

	/**
	 * @param  TabTable   $tab       Current tab
	 * @param  UserTable  $user      Current user
	 * @param  int        $ui        1 front, 2 admin UI
	 * @param  array      $postdata  Raw unfiltred POST data
	 */
	public function getCBpluginComponent( $tab, $user, $ui, $postdata )
	{
		global $_CB_framework, $_CB_database;

		$action										=	$this->getInput()->getString( 'action', '' );
		$token										=	$this->getInput()->getString( 'token', '' );
		$userIds									=	$this->getInput()->getString( 'users', '' );
		$actionIds									=	$this->getInput()->getString( 'actions', '' );
		$batchIds									=	$this->getInput()->getString( 'batches', '' );
		$output										=	( $this->getInput()->getString( 'format', '' ) !== 'raw' );

		if ( $user === null ) {
			$user									=	CBuser::getMyUserDataInstance();
		}

		$return										=	null;

		if ( ! is_array( $userIds ) ) {
			if ( $userIds ) {
				$userIds							=	explode( ',', $userIds );
			} else {
				$userIds							=	[];
			}
		}

		if ( ! is_array( $actionIds ) ) {
			if ( $actionIds ) {
				$actionIds							=	explode( ',', $actionIds );
			} else {
				$actionIds							=	[];
			}
		}

		if ( ! is_array( $batchIds ) ) {
			if ( $batchIds ) {
				$batchIds							=	explode( ',', $batchIds );
			} else {
				$batchIds							=	[];
			}
		}

		if ( ( $token === md5( $_CB_framework->getCfg( 'secret' ) ) ) || ( ( $action === 'action' ) && $actionIds ) ) {
			if ( ( ( $action === 'batch' ) && $batchIds ) || ( $action === 'general' ) || ( $action === 'users' ) ) {
				$cbUser								=	CBuser::getMyInstance();

				$query								=	"SELECT *"
													.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_autoactions_batches' );
				if ( $action === 'general' ) {
					$query							.=	"\n WHERE ( " . $_CB_database->NameQuote( 'title' ) . " = " . $_CB_database->Quote( 'internalGeneral' )
													.	" OR " . $_CB_database->NameQuote( 'users' ) . " = 0 )";
				} elseif ( $action === 'users' ) {
					$query							.=	"\n WHERE ( " . $_CB_database->NameQuote( 'title' ) . " = " . $_CB_database->Quote( 'internalUsers' )
													.	" OR " . $_CB_database->NameQuote( 'users' ) . " = 1 )";
				} elseif ( count( $batchIds ) > 1 ) {
					$query							.=	"\n WHERE " . $_CB_database->NameQuote( 'id' ) . " IN " . $_CB_database->safeArrayOfIntegers( $batchIds );
				} else {
					$query							.=	"\n WHERE " . $_CB_database->NameQuote( 'id' ) . " = " . (int) $batchIds[0];
				}
				$query								.=	"\n AND " . $_CB_database->NameQuote( 'published' ) . " = 1";
				if ( in_array( $action, [ 'general', 'users' ], true ) ) {
					$_CB_database->setQuery( $query, 0, 1 );
				} else {
					$_CB_database->setQuery( $query );
				}
				$rows								=	$_CB_database->loadObjectList( 'id', '\CB\Plugin\AutoActions\Table\BatchTable', [ $_CB_database ] );

				/** @var $rows BatchTable[] */
				foreach ( $rows as $row ) {
					$useLimit						=	$row->getUseLimit();

					if ( $useLimit && ( $useLimit === $row->getUseProgress() ) ) {
						continue;
					}

					$autoActions					=	$row->getAutoActions();

					if ( ! $autoActions ) {
						continue;
					}

					$users							=	$row->getUsers();

					if ( ! $users ) {
						foreach ( $autoActions as $autoAction ) {
							if ( $action === 'general' ) {
								$trigger			=	'internalGeneral';
							} else {
								$trigger			=	'batch' . $row->getId();
							}

							$variables				=	[ 'trigger' => $trigger, 'var1' => $user, 'var2' => $row ];

							$return					.=	$autoAction->runAction( $variables );
						}

						continue;
					}

					$batchProgress					=	$row->getBatchProgress();
					$batchLimit						=	$row->getBatchLimit();

					$filterJOIN						=	$cbUser->replaceUserVars( $row->getFilterJoin(), [ $_CB_database, 'getEscaped' ], false );
					$filterWHERE					=	$cbUser->replaceUserVars( $row->getFilterWhere(), [ $_CB_database, 'getEscaped' ], false );

					$joinACL						=	false;
					$where							=	[];

					if ( $users >= 2 ) {
						$moderators					=	Application::CmsPermissions()->getGroupsOfViewAccessLevel( Application::Config()->getInt( 'moderator_viewaccesslevel', 3 ), true );

						if ( $moderators ) {
							$joinACL				=	true;

							switch ( $users ) {
								case 2: // All Moderators
									if ( count( $moderators ) > 1 ) {
										$where[]	=	"g." . $_CB_database->NameQuote( 'group_id' ) . " IN " . $_CB_database->safeArrayOfIntegers( $moderators );
									} else {
										$where[]	=	"g." . $_CB_database->NameQuote( 'group_id' ) . " = " . (int) $moderators[0];
									}
									break;
								case 3: // All Non-Moderators
									if ( count( $moderators ) > 1 ) {
										$where[]	=	"g." . $_CB_database->NameQuote( 'group_id' ) . " NOT IN " . $_CB_database->safeArrayOfIntegers( $moderators );
									} else {
										$where[]	=	"g." . $_CB_database->NameQuote( 'group_id' ) . " != " . (int) $moderators[0];
									}
									break;
							}
						}
					}

					$access							=	$row->getAccess();

					if ( ( $access !== '' ) && ( $access !== null ) && ( $access !== '-1' ) ) {
						$joinACL					=	true;
						$access						=	explode( '|*|', $access );

						if ( count( $access ) > 1 ) {
							$where[]				=	"g." . $_CB_database->NameQuote( 'group_id' ) . " IN " . $_CB_database->safeArrayOfIntegers( $access );
						} else {
							$where[]				=	"g." . $_CB_database->NameQuote( 'group_id' ) . " = " . (int) $access[0];
						}
					}

					if ( $row->getFilterBasic()->count() ) {
						$orFilters					=	[];

						foreach ( $row->getFilterBasic() as $orFilter ) {
							/** @var ParamsInterface $orFilter */
							$andFilters				=	[];

							foreach ( $orFilter->subTree( 'filter' ) as $andFilter ) {
								/** @var ParamsInterface $andFilter */
								$column				=	$andFilter->getString( 'field', '' );

								if ( ! $column ) {
									continue;
								}

								if ( in_array( $column, [ 'name', 'username', 'email', 'password', 'block', 'registerDate', 'lastvisitDate', 'params' ], true ) ) {
									$table			=	"u.";
								} else {
									$table			=	"c.";
								}

								$operator			=	$andFilter->getInt( 'operator', 0 );

								if ( $operator === 6 ) { // Empty
									$andFilters[]	=	"( " . $table . $_CB_database->NameQuote( $column ) . " IS NULL OR " . $_CB_database->NameQuote( $column ) . " = '' )";

									continue;
								}

								if ( $operator === 7 ) { // Not Empty
									$andFilters[]	=	"( " . $table . $_CB_database->NameQuote( $column ) . " IS NOT NULL AND " . $_CB_database->NameQuote( $column ) . " != '' )";

									continue;
								}

								if ( in_array( $operator, [ 12, 13 ], true ) ) {
									$delimiter		=	$andFilter->getString( 'delimiter', '' );
								} else {
									$delimiter		=	null;
								}

								$value				=	$cbUser->replaceUserVars( $andFilter->getRaw( 'value', '' ), [ $_CB_database, 'getEscaped' ], false );

								switch ( $operator ) {
									case 1: // Not Equal To
										$operator	=	"!=";
										break;
									case 2: // Greater Than
										$operator	=	">";
										break;
									case 3: // Less Than
										$operator	=	"<";
										break;
									case 4: // Greater Than or Equal To
										$operator	=	">=";
										break;
									case 5: // Less Than or Equal To
										$operator	=	"<=";
										break;
									case 8: // Does Contain
										$operator	=	"LIKE";
										$value		=	'%' . addcslashes( $value, '%_' ) . '%';
										break;
									case 9: // Does Not Contain
										$operator	=	"NOT LIKE";
										$value		=	'%' . addcslashes( $value, '%_' ) . '%';
										break;
									case 10: // Is REGEX
										$operator	=	"REGEXP";
										break;
									case 11: // Is Not REGEX
										$operator	=	"NOT REGEXP";
										break;
									case 12: // Is In
										$operator	=	"IN";
										$value		=	explode( ( $delimiter ?: '|*|' ), $value );
										break;
									case 13: // Is Not In
										$operator	=	"NOT IN";
										$value		=	explode( ( $delimiter ?: '|*|' ), $value );
										break;
									case 0: // Equal To
									default:
										$operator	=	"=";
										break;
								}

								if ( is_array( $value ) ) {
									$value			=	$_CB_database->safeArrayOfStrings( $value );
								} else {
									$value			=	$_CB_database->Quote( $value );
								}

								$filter				=	$table . $_CB_database->NameQuote( $column ) . " " . $operator . " " . $value;

								if ( ( $operator === '!=' ) && ( $value === '' ) ) {
									$filter			=	"( " . $table . $_CB_database->NameQuote( $column ) . " IS NOT NULL AND " . $filter . " )";
								} elseif ( in_array( $operator, [ '!=', 'NOT LIKE', 'NOT REGEXP', 'NOT IN' ], true ) || ( ( $operator === '=' ) && ( $value === '' ) ) ) {
									$filter			=	"( " . $table . $_CB_database->NameQuote( $column ) . " IS NULL OR " . $filter . " )";
								}

								$andFilters[]		=	$filter;
							}

							if ( $andFilters ) {
								$orFilters[]		=	( count( $andFilters ) > 1 ? "( " . implode( " AND ", $andFilters ) . " )" : $andFilters[0] );
							}
						}

						if ( $orFilters ) {
							$where[]				=	( count( $orFilters ) > 1 ? "( " . implode( " OR ", $orFilters ) . " )" : $orFilters[0] );
						}
					}

					if ( $filterWHERE ) {
						if ( strpos( 'g.', $filterWHERE ) !== false ) {
							$joinACL				=	true;
						}

						$where[]					=	"( " . $filterWHERE . " )";
					}

					$query							=	"SELECT c.*, u.*"
													.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS c"
													.	"\n INNER JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS u"
													.	' ON u.' . $_CB_database->NameQuote( 'id' ) . ' = c.' . $_CB_database->NameQuote( 'id' );
					if ( $joinACL ) {
						$query						.=	"\n INNER JOIN " . $_CB_database->NameQuote( '#__user_usergroup_map' ) . " AS g"
													.	' ON g.' . $_CB_database->NameQuote( 'user_id' ) . ' = c.' . $_CB_database->NameQuote( 'id' );
					}
					$query							.=	( $filterJOIN ? "\n " . $filterJOIN : null )
													.	( $where ? "\n WHERE " . implode( "\n AND ", $where ) : null );
					if ( $joinACL ) {
						$query						.=	"\n GROUP BY c." . $_CB_database->NameQuote( 'id' );
					}
					if ( $batchLimit ) {
						$_CB_database->setQuery( $query, $batchProgress, $batchLimit );
					} else {
						$_CB_database->setQuery( $query );
					}
					$batchUsers						=	$_CB_database->loadObjectList( null, '\CB\Database\Table\UserTable', [ $_CB_database ] );

					if ( $batchLimit && ( ! $batchUsers ) ) {
						// We're batch processing and have reached the end so lets increment uses:
						$row->incrementUseProgress( 1 );

						continue;
					}

					foreach ( $batchUsers as $batchUser ) {
						foreach ( $autoActions as $autoAction ) {
							if ( $action === 'users' ) {
								$trigger			=	'internalUsers';
							} else {
								$trigger			=	'batch' . $row->getId();
							}

							$variables				=	[ 'trigger' => $trigger, 'var1' => $batchUser, 'var2' => $row ];

							$return					.=	$autoAction->runAction( $variables );
						}

						if ( ! $row->incrementBatchProgress( 1 ) ) {
							// If incrementing fails we'll get stuck in a loop so abort processing this batch:
							continue 2;
						}
					}

					if ( ! $batchLimit ) {
						// There is no batch so whatever amount of users was found is a completed use:
						$row->incrementUseProgress( 1 );
					} elseif ( $row->getBatchRedirect() ) {
						// Batching is in use and we're configured to redirect automatically to the next batch:
						cbRedirect( $_CB_framework->pluginClassUrl( 'cbautoactions', false, [ 'action' => 'batch', 'batches' => $row->getId(), 'token' => md5( $_CB_framework->getCfg( 'secret' ) ) ], 'html', 0, true ) );
					}
				}
			} elseif ( ( $action === 'action' ) && $actionIds ) {
				$query								=	"SELECT *"
													.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_autoactions' );
				if ( count( $actionIds ) > 1 ) {
					$query							.=	"\n WHERE " . $_CB_database->NameQuote( 'id' ) . " IN " . $_CB_database->safeArrayOfIntegers( $actionIds );
				} else {
					$query							.=	"\n WHERE " . $_CB_database->NameQuote( 'id' ) . " = " . (int) $actionIds[0];
				}
				$query								.=	"\n AND " . $_CB_database->NameQuote( 'trigger' ) . " = " . $_CB_database->Quote( '' )
													.	"\n AND " . $_CB_database->NameQuote( 'published' ) . " = 1"
													.	"\n ORDER BY " . $_CB_database->NameQuote( 'ordering' ) . " ASC";
				$_CB_database->setQuery( $query );
				$rows								=	$_CB_database->loadObjectList( 'id', '\CB\Plugin\AutoActions\Table\AutoActionTable', [ $_CB_database ] );

				/** @var $rows AutoActionTable[] */
				if ( $rows ) {
					if ( $userIds ) {
						$query						=	"SELECT *"
													.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS c"
													.	"\n INNER JOIN " . $_CB_database->NameQuote( '#__users' ) . ' AS u'
													.	' ON u.' . $_CB_database->NameQuote( 'id' ) . ' = c.' . $_CB_database->NameQuote( 'id' );
						if ( count( $userIds ) > 1 ) {
							$query					.=	"\n WHERE c." . $_CB_database->NameQuote( 'id' ) . " IN " . $_CB_database->safeArrayOfIntegers( $userIds );
						} else {
							$query					.=	"\n WHERE c." . $_CB_database->NameQuote( 'id' ) . " = " . (int) $userIds[0];
						}
						$_CB_database->setQuery( $query );
						$users						=	$_CB_database->loadObjectList( null, '\CB\Database\Table\UserTable', [ $_CB_database ] );

						if ( $users ) {
							foreach ( $users as $u ) {
								foreach ( $rows as $row ) {
									if ( ! $row->getParams()->getBool( 'direct_access', true ) ) {
										continue;
									}

									$variables	=	[ 'trigger' => 'internalAction', 'var1' => $u ];

									$return		.=	$row->runAction( $variables );
								}
							}
						}
					} else {
						foreach ( $rows as $row ) {
							if ( ! $row->getParams()->getBool( 'direct_access', true ) ) {
								continue;
							}

							$variables			=	[ 'trigger' => 'internalAction', 'var1' => $user ];

							$return				.=	$row->runAction( $variables );
						}
					}
				}
			} else {
				if ( ! $output ) {
					header( 'HTTP/1.0 405 Method Not Allowed' );
					exit();
				}

				cbNotAuth();
			}
		} else {
			if ( ! $output ) {
				header( 'HTTP/1.0 403 Forbidden' );
				exit();
			}

			cbNotAuth();
		}

		echo $return;
	}
}