<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Plugin\Gallery\CBGallery;
use CB\Plugin\Gallery\Gallery;
use CB\Database\Table\UserTable;
use CB\Plugin\PMS\Table\MessageTable;
use CB\Plugin\Gallery\Table\ItemTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_cbgalleryPMEdit
{

	/**
	 * render frontend pm gallery upload
	 *
	 * @param MessageTable    $row
	 * @param ItemTable[]     $items
	 * @param bool            $isReply
	 * @param UserTable       $viewer
	 * @param Gallery         $gallery
	 * @param cbPluginHandler $plugin
	 * @return mixed
	 */
	static function showPMEdit( $row, $items, $isReply, $viewer, $gallery, $plugin )
	{
		global $_CB_framework;

		$canUpload					=	CBGallery::canCreateItems( 'all', 'upload', $gallery );
		$canLink					=	CBGallery::canCreateItems( 'all', 'link', $gallery );

		if ( ( ! $canUpload ) && ( ! $canLink ) ) {
			return null;
		}

		static $JS_LOADED		=	0;

		if ( ( $canUpload || $canLink ) && ( ! $JS_LOADED++ ) ) {
			$uploadRow			=	'<div class="mt-2 d-flex flex-wrap no-gutters border align-items-center galleryShareUploadProgressFile galleryItemsNewUploadFile">'
								.		"<div class=\"p-1 col-12 col-md text-center text-md-left text-wrap galleryItemsNewUploadFileName\">' + ( typeof file.name != 'undefined' ? file.name : Date.now() ) + '</div>"
								.		'<div class="p-1 col-12 col-md galleryItemsNewUploadFileProgress">'
								.			'<div class="m-0 p-0 progress">'
								.				'<div class="progress-bar progress-bar-striped progress-bar-animated"></div>'
								.			'</div>'
								.		'</div>'
								.		'<div class="p-1 col-12 col-md-auto galleryItemsNewUploadFileActions">'
								.			'<button type="button" class="btn btn-sm btn-md-block btn-danger galleryShareUploadProgressCancel galleryItemsNewUploadFileCancel">' . addslashes( CBTxt::T( 'Cancel' ) ) . '</button>'
								.			'<button type="button" class="btn btn-sm btn-md-block btn-danger galleryShareUploadProgressClear galleryItemsNewUploadFileClear hidden"><span class="fa fa-times"></span></button>'
								.		'</div>'
								.	'</div>';

			$uploadError		=	'<div class="mt-1 text-danger text-wrap galleryShareUploadProgressError galleryItemsNewUploadFileAlert">'
								.		"' + response.message + '"
								.	'</div>';

			$linkError			=	'<div class="d-block invalid-feedback text-wrap cbValidationMessage galleryShareLinkError">'
								.		"' + response.message + '"
								.	'</div>';

			$js					=	"$( '.galleryPMNew' ).cbgallery({"
								.		"mode: 'share',"
								.		"callback: {"
								.			"upload: {"
								.				"add: function ( cbgallery, data, file ) {"
								.					"return $( '" . $uploadRow . "' );"
								.				"},"
								.				"error: function ( cbgallery, response ) {"
								.					"return $( '" . $uploadError . "' );"
								.				"}"
								.			"},"
								.			"link: {"
								.				"error: function ( cbgallery, response ) {"
								.					"return $( '" . $linkError . "' );"
								.				"}"
								.			"}"
								.		"},"
								.		"messages: {"
								.			"acceptTypes: '" . addslashes( CBTxt::T( 'Invalid file extension. Please upload only {0}!' ) ) . "',"
								.			"extensions: '" . addslashes( CBTxt::T( 'Invalid file extension. Please upload only {0}!' ) ) . "',"
								.			"minSize: '" . addslashes( CBTxt::T( 'The file is too small. The minimum size is {0} {2}s!' ) ) . "',"
								.			"maxSize: '" . addslashes( CBTxt::T( 'The file is too large. The maximum size is {1} {2}s!' ) ) . "'"
								.		"}"
								.	"});";

			if ( ! $items ) {
				$js				.=	"$( '.pmButtonCancel,.pmButtonBack' ).on( 'click', function( e ) {"
								.		"$( '.pmMessageAttachments' ).find( '.galleryEditDelete' ).removeAttr( 'data-cbgallery-delete-message' ).click();"
								.	"});";
			}

			$_CB_framework->outputCbJQuery( $js, 'cbgallery' );
		}

		$class					=	$plugin->params->getString( 'general_class' );

		$imageHeight			=	$gallery->getInt( 'photos_image_height', 640 );
		$imageWidth				=	$gallery->getInt( 'photos_image_width', 1280 );

		if ( ! $imageHeight ) {
			$imageHeight		=	640;
		}

		if ( ! $imageWidth ) {
			$imageWidth			=	1280;
		}

		$minFileSizes			=	array(	$gallery->getInt( 'photos_min_size', 0 ),
											$gallery->getInt( 'videos_min_size', 0 ),
											$gallery->getInt( 'files_min_size', 0 ),
											$gallery->getInt( 'music_min_size', 0 )
										);

		sort( $minFileSizes, SORT_NUMERIC );

		$maxFileSizes			=	array(	$gallery->getInt( 'photos_max_size', 0 ),
											$gallery->getInt( 'videos_max_size', 0 ),
											$gallery->getInt( 'files_max_size', 0 ),
											$gallery->getInt( 'music_max_size', 0 )
										);

		rsort( $maxFileSizes, SORT_NUMERIC );

		$minFileSize			=	( ! in_array( 0, $minFileSizes, true ) ? $minFileSizes[0] : 0 );
		$maxFileSize			=	( ! in_array( 0, $maxFileSizes, true ) ? $maxFileSizes[0] : 0 );
		$phpMaxFileSize			=	CBGallery::getPHPMaxUpload( 'KB' );

		if ( ( ! $maxFileSize ) || ( $maxFileSize > $phpMaxFileSize ) ) {
			$maxFileSize		=	$phpMaxFileSize;
		}

		$uploadExtLimit			=	CBGallery::getExtensions( 'all', $gallery, 'client' );

		$attributes				=	' data-cbgallery-url="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'save', 'gallery' => $gallery->id(), cbSpoofField() => cbSpoofString( null, 'plugin' ) ), 'raw', 0, true ) . '"'
								.	' data-cbgallery-clientResize="' . $gallery->getInt( 'photos_client_resize', 1 ) . '"'
								.	' data-cbgallery-maxWidth="' . $imageWidth . '"'
								.	' data-cbgallery-maxHeight="' . $imageHeight . '"'
								.	' data-cbgallery-aspectRatio="' . $gallery->getInt( 'photos_maintain_aspect_ratio', 1 ) . '"'
								.	' data-cbgallery-alwaysResample="' . $gallery->getInt( 'photos_resample', 1 ) . '"';

		if ( $uploadExtLimit ) {
			$attributes			.=	' data-cbgallery-extensions="' . htmlspecialchars( implode( ',', $uploadExtLimit ) ) . '"';
		}

		if ( $minFileSize ) {
			$attributes			.=	' data-cbgallery-minSize="' . htmlspecialchars( json_encode( array( $minFileSize, 'KB' ) ) ) . '"';
		}

		if ( $maxFileSize ) {
			$attributes			.=	' data-cbgallery-maxSize="' . htmlspecialchars( json_encode( array( $maxFileSize, 'KB' ) ) ) . '"';
		}

		$return					=	'<div class="cbft_delimiter cbtt_file form-group ' . ( $isReply ? 'cbtwolines' : 'row no-gutters cb_form_line' ) . ' pmMessageAttachments">'
								.		( ! $isReply ? '<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Attachments' ) . '</label>' : null )
								.		'<div class="cb_field' . ( ! $isReply ? ' col-sm-9' : null ) . '">'
								.			'<div class="cbGallery' . ( $class ? ' ' . htmlspecialchars( $class ) : null ) . '">'
								.				'<div class="galleryPMNew galleryItemsNew"' . $attributes . '>';

		if ( $canUpload ) {
			$return				.=					'<div class="galleryItemsNewUpload">'
								.						'<div class="border bg-light rounded p-3 text-center galleryShareUploadDropZone galleryItemsNewUploadArea">'
								.							'<strong><span class="fa fa-upload"></span> ' . CBTxt::T( 'Click or Drag & Drop to Upload' ) . '</strong>'
								.							'<input type="file" name="upload" class="galleryShareUpload hidden" multiple />'
								.						'</div>'
								.						'<div class="galleryShareUploadProgress galleryItemsNewUploadFiles hidden"></div>'
								.					'</div>';
		}

		if ( $canLink ) {
			if ( $canUpload ) {
				$return			.=					'<div class="mt-1 mb-1 d-flex flex-wrap no-gutters align-items-center galleryItemsNewOr">'
								.						'<div class="col"><hr class="m-0" /></div>'
								.						'<div class="pl-2 pr-2 text-center text-muted text-small">' . CBTxt::T( 'OR' ) . '</div>'
								.						'<div class="col"><hr class="m-0" /></div>'
								.					'</div>';
			}

			$return				.=					'<div class="galleryShareLinkArea galleryItemsNewLink">'
								.						'<div class="input-group">'
								.							'<input type="text" class="form-control galleryShareLink" placeholder="' . htmlspecialchars( CBTxt::T( 'Have a media link to share?' ) ) . '">'
								.							'<div class="input-group-append">'
								.								'<button type="button" class="btn btn-primary galleryShareLinkSave galleryButton galleryButtonShare">' . CBTxt::T( 'Share' ) . '</button>'
								.							'</div>'
								.						'</div>'
								.					'</div>';
		}

		if ( $items ) {
			$return				.=					'<div class="d-flex flex-wrap no-gutters mt-2 galleryShareEdit galleryItemsNewEdit">';

			foreach ( $items as $item ) {
				$return			.=						HTML_cbgalleryItemEditMicro::showItemEditMicro( $item, $viewer, $gallery, $plugin );
			}

			$return				.=					'</div>';
		} else {
			$return				.=					'<div class="d-flex flex-wrap no-gutters mt-2 galleryShareEdit galleryItemsNewEdit hidden"></div>';
		}

		$return					.=				'</div>'
								.			'</div>'
								.		'</div>'
								.	'</div>';

		return $return;
	}
}