<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CBLib\Language\CBTxt;
use CB\Plugin\AntiSpam\Captcha;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class PlgCaptchacbantispambot extends JPlugin
{

	/**
	 * Checks if CB and CB AntiSpam are installed and loaded
	 */
	private function loadAntiSpam()
	{
		global $_PLUGINS;
		
		static $plugin		=	null;

		if ( $plugin === null ) {
			if ( ( ! file_exists( JPATH_SITE . '/libraries/CBLib/CBLib/Core/CBLib.php' ) ) || ( ! file_exists( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' ) ) ) {
				$plugin		=	false;

				return true;
			}

			include_once( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' );

			cbimport( 'cb.html' );
			cbimport( 'language.front' );

			$_PLUGINS->loadPluginGroup( 'user' );

			$plugin			=	$_PLUGINS->getLoadedPlugin( 'user', 'cbantispam' );

			outputCbJs();
			outputCbTemplate();
		}

		return $plugin;
	}

	/**
	 * Initialise the captcha
	 *
	 * @param   string  $id  The id of the field.
	 *
	 * @return  Boolean	True on success, false otherwise
	 *
	 * @throws  Exception
	 *
	 * @since  2.5
	 */
	public function onInit( $id = 'dynamic_cbantispam_1' )
	{
		if ( ! $this->loadAntiSpam() ) {
			throw new Exception( CBTxt::T( 'CB AntiSpam is not installed.' ) );
		}

		return true;
	}

	/**
	 * Gets the challenge HTML
	 *
	 * @param   string  $name   The name of the field. Not Used.
	 * @param   string  $id     The id of the field.
	 * @param   string  $class  The class of the field. This should be passed as
	 *                          e.g. 'class="required"'.
	 *
	 * @return  string  The HTML to be embedded in the form.
	 *
	 * @since  2.5
	 */
	public function onDisplay( $name = null, $id = 'dynamic_cbantispam_1', $class = '' )
	{
		if ( ! $this->loadAntiSpam() ) {
			return null;
		}

		$captcha	=	new Captcha( 'JoomlaCaptcha', $this->params->get( 'cbantispam_captcha_mode', -1 ) );

		return '<div class="cbJoomlaCaptcha cb_template cb_template_' . selectTemplate( 'dir' ) . '">' . $captcha->captcha() . '</div>' . $captcha->input( null, trim( str_replace( 'required', '', preg_replace( '/class="(.*)"/', '$1', $class ) ) ) );
	}

	/**
	 * Calls an HTTP POST function to verify if the user's guess was correct
	 *
	 * @param   string  $code  Answer provided by user. Not needed for the Recaptcha implementation
	 *
	 * @return  True if the answer is correct, false otherwise
	 *
	 * @since  2.5
	 */
	public function onCheckAnswer( $code = null )
	{
		if ( ! $this->loadAntiSpam() ) {
			return true;
		}

		$captcha	=	new Captcha( 'JoomlaCaptcha', $this->params->get( 'cbantispam_captcha_mode', -1 ) );

		if ( ( ! $captcha->load() ) || ( ! $captcha->validate( $code ) ) ) {
			$this->_subject->setError( ( $captcha->error() ? $captcha->error() : CBTxt::T( 'Invalid Captcha Code' ) ) );

			return false;
		}

		return true;
	}
}