<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Database\Table\TabTable;
use CB\Plugin\AntiSpam\Table\AttemptTable;
use CBLib\Registry\GetterInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var cbantispamTab  $this
 * @var AttemptTable[] $rows
 * @var cbPageNav      $pageNav
 * @var UserTable      $viewer
 * @var UserTable      $user
 * @var TabTable       $tab
 * @var string         $returnUrl
 */
?>
<div class="attemptsTab">
	<form action="<?php echo $_CB_framework->userProfileUrl( $user->get( 'id', 0, GetterInterface::INT ), true, $tab->get( 'tabid', 0, GetterInterface::INT ) ); ?>" method="post" name="attemptsForm" class="m-0 attemptsForm">
		<div class="table-responsive attemptsItemsContainer">
			<table class="table table-hover mb-0">
				<thead>
					<tr class="attemptsItemsHeader">
						<th><?php echo CBTxt::T( 'IP Address' ); ?></th>
						<th style="width: 25%;" class="d-none d-sm-table-cell"><?php echo CBTxt::T( 'Date' ); ?></th>
						<th style="width: 20%;" class="text-center"><?php echo CBTxt::T( 'Type' ); ?></th>
						<th style="width: 10%;" class="text-center d-none d-sm-table-cell"><?php echo CBTxt::T( 'Count' ); ?></th>
						<th style="width: 1%;">&nbsp;</th>
					</tr>
				</thead>
				<tbody>
					<?php if ( $rows ) foreach ( $rows as $row ) { ?>
					<tr class="attemptsItemContainer">
						<td><?php echo $row->get( 'ip_address', null, GetterInterface::STRING ); ?></td>
						<td style="width: 25%;" class="d-none d-sm-table-cell"><?php echo cbFormatDate( $row->get( 'date', null, GetterInterface::STRING ), false ); ?></td>
						<td style="width: 20%;" class="text-center"><?php echo $row->get( 'type', null, GetterInterface::STRING ); ?></td>
						<td style="width: 10%;" class="text-center d-none d-sm-table-cell"><?php echo $row->get( 'count', 0, GetterInterface::INT ); ?></td>
						<td style="width: 1%;" class="text-right">
							<a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( '<?php echo addslashes( CBTxt::T( 'Are you sure you want to delete this attempt?' ) ); ?>' ).done( function() { window.location.href = '<?php echo addslashes( $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'attempt', 'func' => 'delete', 'id' => $row->get( 'id', 0, GetterInterface::INT ), 'return' => $returnUrl ) ) ); ?>'; })"><span class="fa fa-trash-o"></span></a>
						</td>
					</tr>
					<?php } else { ?>
					<tr class="attemptsItemsEmpty">
						<td colspan="5">
						<?php if ( $viewer->get( 'id', 0, GetterInterface::INT ) == $user->get( 'id', 0, GetterInterface::INT ) ) { ?>
							<?php echo CBTxt::T( 'You have no attempts.' ); ?>
						<?php } else { ?>
							<?php echo CBTxt::T( 'This user has no attempts.' ); ?>
						<?php } ?>
						</td>
					</tr>
					<?php } ?>
				</tbody>
				<?php if ( $tab->params->get( 'tab_paging', true, GetterInterface::BOOLEAN ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
				<tfoot>
					<tr class="attemptsItemsPaging">
						<td colspan="5" class="text-center">
							<?php echo $pageNav->getListLinks(); ?>
						</td>
					</tr>
				</tfoot>
				<?php } ?>
			</table>
		</div>
		<?php echo $pageNav->getLimitBox( false ); ?>
	</form>
</div>