<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJiveWall\Table\WallTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveWallReplies
{

	/**
	 * render frontend replies
	 *
	 * @param WallTable       $reply
	 * @param WallTable[]     $rows
	 * @param cbPageNav       $pageNav
	 * @param GroupTable      $group
	 * @param UserTable       $user
	 * @param cbPluginHandler $plugin
	 * @return string
	 */
	public static function showReplies( $reply, $rows, $pageNav, $group, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		$isModerator						=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$messageLimit						=	( ! $isModerator ? $plugin->params->getInt( 'groups_wall_character_limit', 0 ) : 0 );
		$isOwner							=	( $user->getInt( 'id', 0 ) === $group->getInt( 'user_id', 0 ) );
		$userStatus							=	CBGroupJive::getGroupStatus( $user, $group );
		$canCreate							=	CBGroupJive::canCreateGroupContent( $user, $group, 'wall' );
		$return								=	null;

		$_PLUGINS->trigger( 'gj_onBeforeDisplayWall', array( &$return, &$rows, $group, $user ) );

		$return								.=	'<div class="gjGroupWallRows">';

		if ( $rows ) {
			foreach ( $rows as $row ) {
				$rowOwner					=	( $user->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) );
				$isModOrOwner				=	( $isModerator || $isOwner || $rowOwner || ( $userStatus >= 2 ) );
				$menu						=	array();

				$integrations				=	$_PLUGINS->trigger( 'gj_onDisplayWall', array( &$row, &$menu, $group, $user ) );

				$cbUser						=	CBuser::getInstance( $row->getInt( 'user_id', 0 ), false );

				$return						.=		'<div class="position-relative mb-2 gjGroupWallRow">'
											.			'<div class="media gjGroupWallRowHeader">'
											.				'<div class="media-left gjGroupWallRowAvatar">'
											.					$cbUser->getField( 'avatar', null, 'html', 'none', 'list', 0, true )
											.				'</div>'
											.				'<div class="media-body pl-2 pr-5 gjGroupWallRowDetails">'
											.					'<div class="cbMoreLess">'
											.						'<div class="cbMoreLessContent">'
											.							'<strong>' . $cbUser->getField( 'formatname', null, 'html', 'none', 'list', 0, true ) . '</strong> '
											.							$row->post()
											.						'</div>'
											.						'<div class="fade-edge cbMoreLessOpen hidden">'
											.							'<a href="javascript: void(0);" class="cbMoreLessButton">' . CBTxt::T( 'See More' ) . '</a>'
											.						'</div>'
											.					'</div>'
											.					'<div class="text-small text-muted gjGroupWallRowDate">'
											.						cbFormatDate( $row->getString( 'date' ), true, 'timeago' );

				if ( $isModOrOwner && ( ( $row->getInt( 'published', 0 ) === -1 ) && ( $group->params()->getInt( 'wall', 1 ) === 2 ) ) ) {
					$return					.=						' <span class="fa fa-clock-o text-warning gjGroupPendingIcon" title="' . htmlspecialchars( CBTxt::T( 'Awaiting Approval' ) ) . '"></span>';
				}

				$return						.=					'</div>'
											.					( is_array( $integrations ) && $integrations ? '<div class="gjGroupWallRowFooter">' . implode( '', $integrations ) . '</div>' : null )
											.				'</div>'
											.			'</div>';

				if ( $isModOrOwner || $menu ) {
					$menuItems				=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 gjMenuItems gjWallMenuItems">';

					if ( $isModOrOwner ) {
						$menuItems			.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'wall', 'func' => 'edit', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';

						if ( ( $row->getInt( 'published', 0 ) === -1 ) && ( $group->params()->getInt( 'wall', 1 ) === 2 ) ) {
							if ( $isModerator || $isOwner || ( $userStatus >= 2 ) ) {
								$menuItems	.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'wall', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Approve' ) . '</a></li>';
							}
						} elseif ( $row->getInt( 'published', 0 ) === 1 ) {
							$menuItems		.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to unpublish this Post?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'wall', 'func' => 'unpublish', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-times-circle"></span> ' . CBTxt::T( 'Unpublish' ) . '</a></li>';
						} else {
							$menuItems		.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'wall', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Publish' ) . '</a></li>';
						}
					}

					if ( $menu ) {
						$menuItems			.=		'<li class="gjMenuItem">' . implode( '</li><li class="gjMenuItem">', $menu ) . '</li>';
					}

					if ( $isModOrOwner ) {
						$menuItems			.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this Post?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'wall', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>';
					}

					$menuItems				.=	'</ul>';

					$return					.=			'<div class="mr-n2 gjGroupWallMenu">'
											.				cbTooltip( null, $menuItems, null, 'auto', null, '<span class="pt-1 pb-1 pl-3 pr-3 text-large fa fa-ellipsis-v"></span>', 'javascript:void(0);', 'class="text-body cbDropdownMenu gjGroupWallMenuToggle" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' )
											.			'</div>';
				}

				$return						.=		'</div>';
			}
		}

		if ( $plugin->params->getInt( 'groups_wall_paging', 1 ) && ( $pageNav->total > $pageNav->limit ) ) {
			$return							.=		'<div class="mb-2 gjGroupWallPaging">'
											.			$pageNav->getListLinks()
											.		'</div>';
		}

		if ( $canCreate ) {
			$return							.=		'<div class="position-relative gjGroupWallRow gjGroupWallNew">'
											.			'<form action="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'wall', 'func' => 'save' ) ) . '" method="post" name="gjGroupWallFormNewReply' . $reply->getInt( 'id', 0 ) . '" id="gjGroupWallFormNewReply' . $reply->getInt( 'id', 0 ) . '" class="m-0 gjGroupWallForm cbValidation">'
											.				'<div class="cb_form_line gjGroupWallInputGroup gjGroupWallInputMessageContainer">'
											.					'<textarea name="post" rows="1" class="form-control shadow-none gjGroupWallInput gjGroupWallInputMessage required" placeholder="' . htmlspecialchars( CBTxt::T( 'Write a reply...' ) ) . '"' . ( $messageLimit ? ' maxlength="' . (int) $messageLimit . '"' : null ) . ' data-cbgjwall-input-size="1"></textarea>'
											.				'</div>'
											.				'<div class="text-right mt-2 gjGroupWallNewFooter hidden">';

			if ( $messageLimit ) {
				$return						.=					'<div class="badge badge-secondary font-weight-normal align-bottom gjGroupWallLimit">'
											.						'<span class="gjGroupWallLimitCurrent">0</span> / <span class="gjGroupWallLimitMax">' . (int) $messageLimit . '</span>'
											.					'</div> ';
			}

			$return							.=					'<button type="submit" class="btn btn-primary btn-sm btn-sm-block gjButton gjButtonSubmit" ' . cbValidator::getSubmitBtnHtmlAttributes() . '>' . CBTxt::T( 'Reply' ) . '</button>'
											.				'</div>'
											.				'<input type="hidden" name="group" value="' . $group->getInt( 'id', 0 ) . '" />'
											.				'<input type="hidden" name="reply" value="' . $reply->getInt( 'id', 0 ) . '" />'
											.				cbGetSpoofInputTag( 'plugin' )
											.			'</form>'
											.		'</div>';
		}

		$return								.=	'</div>';

		$_PLUGINS->trigger( 'gj_onAfterDisplayWall', array( &$return, $rows, $group, $user ) );

		return $return;
	}
}