<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2020 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Invites\Trigger;

use CBLib\Language\CBTxt;

defined('CBLIB') or die();

class AdminTrigger extends \cbPluginHandler
{

	/**
	 * Displays backend menu items
	 *
	 * @param array $menu
	 * @param bool  $disabled
	 */
	public function adminMenu( &$menu, $disabled )
	{
		global $_CB_framework;

		if ( ! $this->params->getBool( 'general_menu', true ) ) {
			return;
		}

		$prevStateBase			=	'option=com_comprofiler&view=editPlugin&pluginid=' . $this->getPluginId();

		$plgMenu				=	array();

		$plgMenu['component']	=	array(	'title' => CBTxt::T( 'Invites' ) );
		$plgMenu['menu']		=	array(	array(	'title' => CBTxt::T( 'Invites' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'action' => 'showinvites', 'cid' => $this->getPluginId() ) ), 'icon' => 'cbinvites-invites',
													'submenu' => array( array( 'title' => CBTxt::T( 'Invite New User' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'table' => 'invitesbrowser', 'action' => 'editrow', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showinvites' ) ) ), 'icon' => 'cb-new' ) )
											),
											array(	'title' => CBTxt::T( 'Configuration' ), 'link' => $_CB_framework->backendViewUrl( 'editrow', true, array( 'table' => 'pluginsbrowser', 'action' => 'editrow', 'cid' => $this->getPluginId(), 'cbprevstate' => base64_encode( 'option=com_comprofiler&view=showPlugins' ) ) ), 'icon' => 'cbinvites-config' )
										);

		$menu['cbinvites']		=	$plgMenu;
	}
}