<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Action;

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CBLib\Registry\ParamsInterface;

\defined( 'CBLIB' ) or die();

class MenuAction extends Action
{

	/**
	 * @param UserTable $user
	 */
	public function execute( UserTable $user ): void
	{
		global $_PLUGINS;

		foreach ( $this->autoaction()->getParams()->subTree( 'menu' ) as $row ) {
			/** @var ParamsInterface $row */
			$menuTitle					=	$this->string( $user, $row->getHtml( 'title' ), false );

			if ( ! $menuTitle ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_MENU_NO_TITLE', ':: Action [action] :: CB Menu skipped due to missing title', [ '[action]' => $this->autoaction()->getId() ] ) );
				continue;
			}

			$menuType					=	$this->string( $user, $row->getString( 'type', '' ), true, false );
			$menuClass					=	$this->string( $user, $row->getString( 'class', '' ), true, false );
			$menuTarget					=	$row->getString( 'target', '' );
			$menuImg					=	$this->string( $user, $row->getString( 'image', '' ), false );

			$menuItem					=	[];

			if ( ! $menuType )  {
				$menuItem['arrayPos']	=	[ $menuClass => null ];
			} else {
				$menuItem['arrayPos']	=	[ $menuType => [ $menuClass => null ] ];
			}

			$menuItem['position']		=	$row->getString( 'position', 'menuBar' );
			$menuItem['caption']		=	$menuTitle;
			$menuItem['url']			=	$this->string( $user, $row->getString( 'url', '' ), false );
			$menuItem['target']			=	( $menuTarget ? htmlspecialchars( $menuTarget ) : null );
			$menuItem['img']			=	( $menuImg ? ( $menuImg[0] === '<' ? $menuImg : '<img src="' . htmlspecialchars( $menuImg ) . '" />' ) : null );
			$menuItem['tooltip']		=	htmlspecialchars( $this->string( $user, $row->getString( 'tooltip', '' ), false ) );

			$_PLUGINS->addMenu( $menuItem );
		}
	}
}