<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJiveFile\Table\FileTable;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\NotificationsInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveFileActivity
{

	/**
	 * render frontend file activity
	 *
	 * @param ActivityTable|NotificationTable $row
	 * @param null|string                     $title
	 * @param null|string                     $date
	 * @param null|string                     $message
	 * @param null|string                     $insert
	 * @param null|string                     $footer
	 * @param array                           $menu
	 * @param Activity|Notifications          $stream
	 * @param array                           $assetMatches
	 * @param FileTable                       $file
	 * @param cbPluginHandler                 $plugin
	 * @param string                          $output
	 */
	public static function showFileActivity( &$row, &$title, &$date, &$message, &$insert, &$footer, &$menu, $stream, $assetMatches, $file, $plugin, $output )
	{
		global $_CB_framework, $_PLUGINS;

		$type						=	( isset( $assetMatches[3] ) ? $assetMatches[3] : '' );
		$user						=	CBuser::getMyUserDataInstance();
		$groupOwner					=	( $user->getInt( 'id', 0 ) === $file->group()->getInt( 'user_id', 0 ) );

		if ( CBGroupJive::canAccessGroup( $file->group(), $user ) ) {
			$groupName				=	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $file->group()->getInt( 'id', 0 ) ) ) . '">' . htmlspecialchars( CBTxt::T( $file->group()->getString( 'name' ) ) ) . '</a>';
		} else {
			$groupName				=	htmlspecialchars( CBTxt::T( $file->group()->getString( 'name' ) ) );
		}

		if ( $stream instanceof NotificationsInterface ) {
			if ( CBGroupJive::canAccessGroup( $file->group(), $user ) ) {
				$row->set( 'link', $_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $file->group()->getInt( 'id', 0 ), 'tab' => 'grouptabfile' ) ) );

				$fileName			=	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $file->group()->getInt( 'id', 0 ), 'tab' => 'grouptabfile' ) ) . '">' . ( $file->getString( 'title' ) ? htmlspecialchars( $file->getString( 'title' ) ) : $file->name() ) . '</a>';
			} else {
				$fileName			=	( $file->getString( 'title' ) ? htmlspecialchars( $file->getString( 'title' ) ) : $file->name() );
			}

			switch ( $type ) {
				case 'file_approve':
					if ( $groupOwner ) {
						$title		=	CBTxt::T( 'FILE_AWAITING_APPROVAL_IN_YOUR_GROUP', 'file [file] is awaiting approval in your group [group]', array( '[group]' => $groupName, '[file]' => $fileName ) );
					} else {
						$title		=	CBTxt::T( 'FILE_AWAITING_APPROVAL_IN_GROUP', 'file [file] is awaiting approval in group [group]', array( '[group]' => $groupName, '[file]' => $fileName ) );
					}
					break;
				case 'file_approved':
					if ( $groupOwner ) {
						$title		=	CBTxt::T( 'FILE_APPROVED_IN_YOUR_GROUP', 'file [file] approved in your group [group]', array( '[group]' => $groupName, '[file]' => $fileName ) );
					} else {
						$title		=	CBTxt::T( 'FILE_APPROVED_IN_GROUP', 'file [file] approved in group [group]', array( '[group]' => $groupName, '[file]' => $fileName ) );
					}
					break;
				case 'file_new':
				default:
					if ( $groupOwner ) {
						$title		=	CBTxt::T( 'SHARED_FILE_IN_YOUR_GROUP', 'shared file [file] in your group [group]', array( '[group]' => $groupName, '[file]' => $fileName ) );
					} else {
						$title		=	CBTxt::T( 'SHARED_FILE_IN_GROUP', 'shared file [file] in group [group]', array( '[group]' => $groupName, '[file]' => $fileName ) );
					}
					break;
			}
		} else {
			if ( $stream->getInt( 'groupjive.ingroup', 0 ) === $file->group()->getInt( 'id', 0 ) ) {
				$title				=	CBTxt::T( 'shared a file' );
			} elseif ( $groupOwner ) {
				$title				=	CBTxt::T( 'SHARED_A_FILE_IN_YOUR_GROUP', 'shared a file in your group [group]', array( '[group]' => $groupName ) );
			} else {
				$title				=	CBTxt::T( 'SHARED_A_FILE_IN_GROUP', 'shared a file in group [group]', array( '[group]' => $groupName ) );
			}

			$insert					=	'<div class="table-responsive gjFileActivity">'
									.		'<table class="table table-sm table-bordered m-0 gjGroupFileRows">'
									.			'<thead>'
									.				'<tr>'
									.					'<th colspan="2">&nbsp;</th>'
									.					'<th style="width: 15%;" class="text-center">' . CBTxt::T( 'Type' ) . '</th>'
									.					'<th style="width: 15%;" class="text-center">' . CBTxt::T( 'Size' ) . '</th>'
									.				'</tr>'
									.			'</thead>'
									.			'<tbody>';

			$fileExtension			=	null;
			$fileSize				=	0;

			$fileName				=	( $file->getString( 'title' ) ? htmlspecialchars( $file->getString( 'title' ) ) : $file->name() );
			$item					=	$fileName;

			if ( $file->exists() ) {
				$downloadPath		=	$_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'file', 'func' => 'download', 'id' => $file->getInt( 'id', 0 ) ), 'raw', 0, true );
				$fileExtension		=	$file->extension();
				$fileSize			=	$file->size();

				switch ( $fileExtension ) {
					case 'txt':
					case 'pdf':
					case 'jpg':
					case 'jpeg':
					case 'png':
					case 'gif':
					case 'js':
					case 'css':
					case 'mp4':
					case 'mp3':
					case 'wav':
						if ( CBGroupJive::canAccessGroup( $file->group(), $user ) ) {
							$item	=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'file', 'func' => 'show', 'id' => $file->getInt( 'id', 0 ) ), 'raw', 0, true ) . '" target="_blank">'
									.		$item
									.	'</a>';
						}
						break;
					default:
						if ( CBGroupJive::canAccessGroup( $file->group(), $user ) ) {
							$item	=	'<a href="' . $downloadPath . '" target="_blank">'
									.		$item
									.	'</a>';
						}
						break;
				}

				if ( CBGroupJive::canAccessGroup( $file->group(), $user ) ) {
					$download		=	'<a href="' . $downloadPath . '" target="_blank" title="' . htmlspecialchars( CBTxt::T( 'Click to Download' ) ) . '" class="btn btn-sm btn-secondary gjGroupDownloadIcon">'
									.		'<span class="fa fa-download"></span>'
									.	'</a>';
				} else {
					$download		=	'<button type="button" class="btn btn-sm btn-secondary gjButton gjButtonDownloadFile disabled">'
									.		'<span class="fa fa-download"></span>'
									.	'</button>';
				}
			} else {
				$download			=	'<button type="button" class="btn btn-sm btn-secondary gjButton gjButtonDownloadFile disabled">'
									.		'<span class="fa fa-download"></span>'
									.	'</button>';
			}

			if ( $file->getString( 'description' ) ) {
				$item				.=	' ' . cbTooltip( 1, $file->getString( 'description' ), ( $file->getString( 'title' ) ? $file->name() : null ), 400, null, '<span class="fa fa-info-circle text-muted"></span>' );
			}

			$insert					.=				'<tr>'
									.					'<td style="width: 1%;" class="text-center">' . $download . '</td>'
									.					'<td class="text-wrap">' . $item . '</td>'
									.					'<td style="width: 15%;" class="text-center"><span class="gjGroupFileTypeIcon fa fa-' . $file->icon() . '" title="' . htmlspecialchars( ( $fileExtension ? strtoupper( $fileExtension ) : CBTxt::T( 'Unknown' ) ) ) . '"></span></td>'
									.					'<td style="width: 15%;" class="text-center">' . $fileSize . '</td>'
									.				'</tr>'
									.			'</tbody>'
									.		'</table>'
									.	'</div>';
		}

		$_PLUGINS->trigger( 'gj_onAfterFileActivity', array( &$row, &$title, &$date, &$message, &$insert, &$footer, &$menu, $stream, $assetMatches, $file, $plugin, $output ) );
	}
}