<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJive\Table\NotificationTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveNotifications
{

	/**
	 * render frontend notifications
	 *
	 * @param NotificationTable  $row
	 * @param array              $input
	 * @param GroupTable         $group
	 * @param UserTable          $user
	 * @param CBplug_cbgroupjive $plugin
	 */
	public static function showNotifications( $row, $input, $group, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		$js							=	"$( '.gjToggleNotificationsYes' ).on( 'click', function() {"
									.		"$( '.gjNotificationsForm' ).find( '.gjToggleNotificationYes' ).click();"
									.	"});"
									.	"$( '.gjToggleNotificationsNo' ).on( 'click', function() {"
									.		"$( '.gjNotificationsForm' ).find( '.gjToggleNotificationNo' ).click();"
									.	"});";

		$_CB_framework->outputCbJQuery( $js );

		$pageTitle					=	CBTxt::T( 'Notifications' );

		$_CB_framework->setPageTitle( $pageTitle );

		cbValidator::loadValidation();
		initToolTip();

		$isModerator				=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$isOwner					=	( $user->getInt( 'id', 0 ) === $group->getInt( 'user_id', 0 ) );
		$status						=	CBGroupJive::getGroupStatus( $user, $group );
		$return						=	null;

		$integrations				=	$_PLUGINS->trigger( 'gj_onBeforeDisplayNotifications', array( &$return, &$row, &$input, $group, $user ) );

		$return						.=	'<div class="gjNotifications gjNotifications' . $group->getInt( 'id', 0 ) . '">'
									.		'<form action="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'notifications', 'func' => 'save', 'id' => $group->getInt( 'id', 0 ) ) ) . '" method="post" enctype="multipart/form-data" name="gjNotificationsForm" id="gjNotificationsForm" class="form-auto m-0 cb_form gjNotificationsForm cbValidation">'
									.			( $pageTitle ? '<div class="mb-3 border-bottom cb-page-header gjNotificationsTitle"><h3 class="m-0 p-0 mb-2 cb-page-header-title">' . $pageTitle . '</h3></div>' : null )
									.			'<div class="cbft_select cbtt_select form-group cb_form_line text-right">'
									.				'<div class="btn-group btn-group-sm">'
									.					'<button type="button" class="btn btn-light border gjToggleNotificationsYes"><span class="fa fa-check"></span></button>'
									.					'<button type="button" class="btn btn-light border gjToggleNotificationsNo"><span class="fa fa-times"></span></button>'
									.				'</div>'
									.			'</div>'
									.			'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<label for="params__user_join" class="col-form-label col-9 pr-2">' . CBTxt::T( 'Join of new user' ) . '</label>'
									.				'<div class="cb_field col-3 text-right">'
									.					$input['user_join']
									.				'</div>'
									.			'</div>'
									.			'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<label for="params__user_leave" class="col-form-label col-9 pr-2">' . CBTxt::T( 'Leave of existing user' ) . '</label>'
									.				'<div class="cb_field col-3 text-right">'
									.					$input['user_leave']
									.				'</div>'
									.			'</div>';

		if ( ( $isModerator || $isOwner || ( $status >= 2 ) ) && ( $group->getInt( 'type', 0 ) === 2 ) ) {
			$return					.=			'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<label for="params__user_approve" class="col-form-label col-9 pr-2">' . CBTxt::T( 'New user requires approval' ) . '</label>'
									.				'<div class="cb_field col-3 text-right">'
									.					$input['user_approve']
									.				'</div>'
									.			'</div>'
									.			'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<label for="params__user_cancel" class="col-form-label col-9 pr-2">' . CBTxt::T( 'New user join request cancelled' ) . '</label>'
									.				'<div class="cb_field col-3 text-right">'
									.					$input['user_cancel']
									.				'</div>'
									.			'</div>';
		}

		if ( ( $plugin->params->getInt( 'groups_invites_display', 1 ) || ( $group->getInt( 'type', 0 ) === 3 ) || ( $group->getInt( 'type', 0 ) === 5 ) ) && ( $group->params()->getInt( 'invites', 1 ) || ( $isModerator || $isOwner || ( $status >= 3 ) ) ) ) {
			$return					.=			'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<label for="params__invite_accept" class="col-form-label col-9 pr-2">' . CBTxt::T( 'My group invite requests accepted' ) . '</label>'
									.				'<div class="cb_field col-3 text-right">'
									.					$input['invite_accept']
									.				'</div>'
									.			'</div>'
									.			'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<label for="params__invite_reject" class="col-form-label col-9 pr-2">' . CBTxt::T( 'My group invite requests rejected' ) . '</label>'
									.				'<div class="cb_field col-3 text-right">'
									.					$input['invite_reject']
									.				'</div>'
									.			'</div>';
		}

		if ( is_array( $integrations ) && $integrations ) {
			$return					.=			implode( '', $integrations );
		}

		$return						.=			'<div class="d-flex flex-column d-sm-block text-sm-right">'
									.				'<input type="button" value="' . htmlspecialchars( CBTxt::T( 'Cancel' ) ) . '" class="order-1 mt-2 mt-sm-0 btn btn-secondary btn-sm-block gjButton gjButtonCancel" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to cancel? All unsaved data will be lost!' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) ) ) . '\'; })" />'
									.				' <input type="submit" value="' . htmlspecialchars( CBTxt::T( 'Update Notifications' ) ) . '" class="order-0 mt-0 btn btn-primary btn-sm-block gjButton gjButtonSubmit" ' . cbValidator::getSubmitBtnHtmlAttributes() . ' />'
									.			'</div>'
									.			cbGetSpoofInputTag( 'plugin' )
									.		'</form>'
									.	'</div>';

		$_CB_framework->setMenuMeta();

		$_PLUGINS->trigger( 'gj_onAfterDisplayNotifications', array( &$return, $row, $input, $group, $user ) );

		echo $return;
	}
}