<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\NotificationsInterface;
use CB\Plugin\Activity\CBActivity;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * Performs the access checks for core/custom activity
 *
 * @var ActivityTable[]|NotificationTable[] $rows
 * @var Activity|Notifications              $stream
 */

global $_PLUGINS;

$notification						=	( $stream instanceof NotificationsInterface );

foreach ( $rows as $k => $row ) {
	$asset							=	$row->getString( 'asset' );

	if ( preg_match( '/^profile\.(\d+)(?:\.field\.(\d+))?/', $asset, $matches ) ) {
		$profileId					=	( isset( $matches[1] ) ? (int) $matches[1] : 0 );
		$fieldId					=	( isset( $matches[2] ) ? (int) $matches[2] : 0 );

		if ( $fieldId ) {
			if ( ! CBActivity::getField( $fieldId, $profileId ) ) {
				unset( $rows[$k] );
				continue;
			}
		} elseif ( ! CBActivity::getTab( null, $profileId ) ) {
			unset( $rows[$k] );
			continue;
		}
	}

	if ( preg_match( '/^(blog|article|page)\.(\d+)(?:\.(comment|like)(?:\.(\d+))?)?/', $asset, $matches ) ) {
		$row->params()->set( 'overrides.group', 'asset' );

		if ( $notification || ( ! isset( $rows[$k] ) ) ) {
			continue;
		}

		$type					=	( isset( $matches[1] ) ? $matches[1] : '' );

		if ( $type === 'blog' ) {
			$cbBlogs			=	CBActivity::getCBBlogs();

			if ( ! $cbBlogs ) {
				unset( $rows[$k] );
				continue;
			}

			if ( ( $cbBlogs->type === 2 ) && ( ! CBActivity::getTab( 8, $row->getInt( 'user_id', 0 ) ) ) ) {
				unset( $rows[$k] );
				continue;
			}
		} elseif ( $type === 'article' ) {
			if ( ! CBActivity::getCBArticles() ) {
				unset( $rows[$k] );
				continue;
			}
		}

		if ( isset( $matches[3] ) ) {
			$id					=	( isset( $matches[2] ) ? (int) $matches[2] : 0 );

			$row->params()->set( 'overrides.tags_asset', $type. '.' . $id );
			$row->params()->set( 'overrides.likes_asset', $type. '.' . $id );
			$row->params()->set( 'overrides.comments_asset', $type. '.' . $id );
		} else {
			$row->params()->set( 'overrides.tags_asset', 'asset' );
			$row->params()->set( 'overrides.likes_asset', 'asset' );
			$row->params()->set( 'overrides.comments_asset', 'asset' );
		}
	} elseif ( preg_match( '/^kunena\.(\d+)\.(create|reply)/', $asset ) ) {
		$row->params()->set( 'overrides.group', 'asset' );

		if ( ! isset( $rows[$k] ) ) {
			continue;
		}

		/** @var KunenaForumMessage $post */
		$post					=	$row->source();

		if ( ( ! $post ) || ( ! $post->id ) ) {
			continue;
		}

		if ( ! in_array( $post->catid, cbforumsModel::getAllowedCategories( Application::MyUser()->getUserId() ), true ) ) {
			unset( $rows[$k] );
			continue;
		}
	} elseif ( preg_match( '/^profile\.(\d+)\.(login|logout|registration)/', $asset, $matches ) ) {
		if ( ! $row->params()->getString( 'asset' ) ) {
			$row->params()->set( 'asset', 'user.' . $matches[2] );
		}
	} elseif ( preg_match( '/^((?:(.+)\.)?(?:activity|comment)\.(\d+))\.(reply|comment|tag|like)(?:\.(\d+))?/', $asset, $matches ) ) {
		$row->params()->set( 'overrides.group', 'asset' );
		$row->params()->set( 'overrides.group_parent', $matches[1] );
	}
}