<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Table\CommentTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\Comments;
use CBLib\Registry\ParamsInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var ActivityTable|CommentTable|NotificationTable $row
 * @var UserTable                                    $viewer
 * @var Activity|Comments|Notifications              $stream
 * @var CBplug_cbactivity                            $this
 * @var string                                       $output
 *
 * @var ParamsInterface                              $link
 * @var ParamsInterface                              $media
 */
?>
<audio style="width: 100%;" src="<?php echo htmlspecialchars( $media->getString( 'url' ) ); ?>" type="<?php echo htmlspecialchars( $media->getString( 'mimetype' ) ); ?>" controls preload="auto" class="streamItemAudio"></audio>