(function($) {
	var instances = [];
	var methods = {
		init: function( options ) {
			return this.each( function () {
				var $this = this;
				var cbactivity = $( $this ).data( 'cbactivity' );

				if ( cbactivity ) {
					return; // cbactivity is already bound; so no need to rebind below
				}

				cbactivity = {};
				cbactivity.options = ( typeof options != 'undefined' ? options : {} );
				cbactivity.defaults = $.fn.cbactivity.defaults;
				cbactivity.settings = $.extend( true, {}, cbactivity.defaults, cbactivity.options );
				cbactivity.element = $( $this );
				cbactivity.stream = $( $this ).data( 'cbactivity-stream' );

				if ( typeof cbactivity.stream == 'undefined' ) {
					cbactivity.stream = null;
				}

				if ( cbactivity.settings.useData ) {
					$.each( $.fn.cbactivity.dataMap, function( key, value ) {
						const dataValue = cbactivity.element.data( value );

						if ( typeof dataValue != 'undefined' ) {
							cbactivity.settings[key] = dataValue;
						}
					});
				}

				cbactivity.element.triggerHandler( 'cbactivity.init.before', [cbactivity] );

				if ( ! cbactivity.settings.init ) {
					return;
				}

				$.ajaxPrefilter( function( options, originalOptions, jqXHR ) {
					options.async = true;

					if ( ( options.dataType == 'script' ) || ( originalOptions.dataType == 'script' ) ) {
						options.cache = true;
					}
				});

				cbactivity.actionHandler = function( e ) {
					e.preventDefault();

					var element = $( this );

					if ( element.hasClass( 'streamRequesting' ) || element.hasClass( 'disabled' ) ) {
						return;
					}

					var containerId = element.data( 'cbactivity-container' );
					var container = null;

					// Actions can be outside of their container so we need to try and find their source container if possible:
					if ( ( typeof containerId != 'undefined' ) && ( ['items', 'stream'].indexOf( containerId ) !== -1 ) ) {
						var streamId = null;

						if ( typeof element.data( 'cbactivity-stream' ) != 'undefined' ) {
							streamId = element.data( 'cbactivity-stream' );
						} else {
							var parentActions = element.closest( '.streamItemActions[data-cbactivity-stream]' );

							if ( parentActions.length ) {
								streamId = parentActions.data( 'cbactivity-stream' );
							}
						}

						if ( streamId ) {
							if ( containerId == 'items' ) {
								container = filterSelector.call( $( '.stream' + streamId ).find( '.streamItems' ), cbactivity );
							} else if ( containerId == 'stream' ) {
								container = $( '.stream' + streamId );
							}
						}
					}

					if ( container === null ) {
						container = findContainer.call( element, cbactivity );
					}

					if ( ! container.length ) {
						return;
					}

					var actionUrl = element.data( 'cbactivity-action-url' );

					if ( ! actionUrl ) {
						actionUrl = element.attr( 'href' );
					}

					if ( ! actionUrl ) {
						return;
					}

					var actionOutput = element.data( 'cbactivity-action-output' );
					var actionTarget = element.data( 'cbactivity-action-target' );

					var confirmMessage = element.data( 'cbactivity-confirm' );
					var confirmButton = element.data( 'cbactivity-confirm-button' );

					element.addClass( 'streamRequesting' );

					var actionData = {};

					if ( container.data( 'cbactivity-inline' ) ) {
						actionData.inline = 1;
					}

					var callback = function() {
						$.ajax({
							url: actionUrl,
							type: 'GET',
							data: actionData,
							dataType: 'html',
							beforeSend: function( jqXHR, settings ) {
								filterSelector.call( container.find( '.streamLoading.hidden' ), cbactivity ).removeClass( 'hidden' );

								cbactivity.element.triggerHandler( 'cbactivity.action.send', [cbactivity, element, container, jqXHR, settings] );
							}
						}).fail( function( jqXHR, textStatus, errorThrown ) {
							filterSelector.call( container.find( '.streamLoading:not(.hidden)' ), cbactivity ).addClass( 'hidden' );

							element.removeClass( 'streamRequesting' );

							cbactivity.element.triggerHandler( 'cbactivity.action.error', [cbactivity, element, container, jqXHR, textStatus, errorThrown] );
						}).done( function( data, textStatus, jqXHR ) {
							filterSelector.call( container.find( '.streamLoading:not(.hidden)' ), cbactivity ).addClass( 'hidden' );

							element.removeClass( 'streamRequesting' );

							var response = null;

							try {
								response = JSON.parse( data );
							} catch( e ) {
								response = { message: data, type: null, output: null, target: null };
							}

							var responseMessage = ( typeof response.message !== 'undefined' ? response.message : null );
							var responseType = ( typeof response.type !== 'undefined' ? response.type : null );
							var newContent = null;

							filterSelector.call( container.find( '.streamItemAlert' ), cbactivity ).remove();

							var previousElement = cbactivity.element;

							if ( response && responseMessage ) {
								var loadScripts = [];

								var responseOutput = ( actionOutput ? actionOutput : ( typeof response.output !== 'undefined' ? response.output : null ) );
								var responseTarget = ( actionTarget ? actionTarget : ( typeof response.target !== 'undefined' ? response.target : null ) );

								if ( responseOutput || responseTarget ) {
									var target = null;

									if ( responseTarget ) {
										if ( responseTarget == 'self' ) {
											target = element;
										} else if ( responseTarget == 'items' ) {
											target = container.siblings( '.streamItems' );
										} else if ( responseTarget == 'container' ) {
											target = container;
										} else if ( responseTarget == 'stream' ) {
											target = cbactivity.element;
										} else {
											responseTarget = filterSelector.call( container.find( responseTarget ), cbactivity );

											if ( responseTarget.length ) {
												target = responseTarget;
											} else {
												target = element;
											}
										}
									} else {
										target = element;
									}

									newContent = $( responseMessage );
									loadScripts = parseHeaders.call( newContent, cbactivity );

									switch( responseOutput ) {
										case 'before':
											target.before( newContent );
											break;
										case 'after':
											target.after( newContent );
											break;
										case 'prepend':
											target.prepend( newContent );
											break;
										case 'append':
											target.append( newContent );
											break;
										case 'replace':
										default:
											if ( responseTarget == 'container' ) {
												target.siblings( '.streamItemHeaders' ).remove();
											} else if ( responseTarget == 'stream' ) {
												previousElement = cbactivity.element.clone( true );
											}

											target.replaceWith( newContent );

											if ( responseTarget == 'container' ) {
												container = newContent;
											} else if ( responseTarget == 'stream' ) {
												container = newContent;
												cbactivity.element = newContent;
											}
											break;
									}
								} else {
									newContent = $( '<div class=\"streamItemActionResponse\">' + responseMessage + '</div>' );
									loadScripts = parseHeaders.call( newContent, cbactivity );

									if ( container.data( 'cbactivity-inline' ) && ( responseType == 'notice' ) ) {
										var parentContainer = findContainer.call( container.parent(), cbactivity );

										if ( parentContainer.length ) {
											container = parentContainer;
										}
									}

									container.children( ':not(.hidden)' ).addClass( 'streamItemActionHidden hidden' );
									container.children( '.streamItemActionResponse' ).remove();
									container.append( newContent );
								}

								parseScripts.call( newContent, cbactivity, loadScripts );
							} else {
								if ( element.hasClass( 'streamItemActionResponsesRevert' ) ) {
									container.children( '.streamItemActionHidden' ).removeClass( 'streamItemActionHidden hidden' );
									container.children( '.streamItemActionResponse' ).remove();
								} else {
									container.siblings( '.streamItemHeaders' ).remove();

									container.remove();
								}
							}

							previousElement.triggerHandler( 'cbactivity.action.success', [cbactivity, element, container, newContent, response, data, textStatus, jqXHR] );

							if ( response && responseMessage ) {
								bindContainer.call( container, cbactivity, true );
							}
						});
					};

					if ( confirmMessage ) {
						$.cbconfirm( confirmMessage, { buttonYes: confirmButton } ).done( callback ).fail( function() {
							element.removeClass( 'streamRequesting' );
						});
					} else {
						callback();
					}
				};

				cbactivity.linkHandler = function( e ) {
					if ( $( e.target ).closest( '.streamItemAction,a' ).length || $( e.target ).is( '.streamItemAction,input,textarea,select,a,button,video,audio,iframe,embed,object' ) ) {
						return;
					}

					var linkUrl = $( this ).data( 'cbactivity-link' );

					if ( ! linkUrl )  {
						return;
					}

					var linkType = linkUrl.charAt( 0 );

					if ( ( linkType == '.' ) || ( linkType == '#' ) ) {
						filterSelector.call( findContainer.call( this, cbactivity ).find( linkUrl ), cbactivity ).click();
					} else {
						window.location.href = linkUrl;
					}
				};

				cbactivity.inputFocusHandler = function( e ) {
					if ( $( e.target ).closest( '.streamInputMessageActions' ).length || $( e.target ).closest( '.streamItemInputGroupAddon' ).length || $( e.target ).closest( 'a' ).length || $( e.target ).is( 'input,textarea,select,a,button' ) ) {
						return;
					}

					var input = $( this ).find( 'input:not(.hidden),textarea:not(.hidden),select:not(.hidden)' ).first();

					if ( ! input.is( e.target ) ) {
						input.focus();
					}
				};

				cbactivity.cancelNewHandler = function( e ) {
					e.preventDefault();
					e.stopPropagation();

					cancelStreamNew.call( this, cbactivity, true );
				};

				cbactivity.saveHandler = function( e ) {
					e.preventDefault();

					var element = $( this );

					if ( element.hasClass( 'streamRequesting' ) || element.hasClass( 'disabled' ) ) {
						return false;
					}

					var container = findContainer.call( element, cbactivity );

					if ( ! container.length ) {
						return false;
					}

					var isNew = ( typeof container.data( 'cbactivity-id' ) == 'undefined' );
					var saveData = {};

					if ( container.data( 'cbactivity-inline' ) ) {
						saveData.inline = 1;
					}

					element.ajaxSubmit({
						type: 'POST',
						data: saveData,
						dataType: 'html',
						beforeSend: function( jqXHR, settings ) {
							filterSelector.call( container.find( '.streamLoading.hidden' ), cbactivity ).removeClass( 'hidden' );

							element.addClass( 'streamRequesting' );

							cbactivity.element.triggerHandler( 'cbactivity.save.send', [cbactivity, element, container, isNew, jqXHR, settings] );
						},
						error: function( jqXHR, textStatus, errorThrown ) {
							filterSelector.call( container.find( '.streamLoading:not(.hidden)' ), cbactivity ).addClass( 'hidden' );

							element.removeClass( 'streamRequesting' );

							cbactivity.element.triggerHandler( 'cbactivity.save.error', [cbactivity, element, container, isNew, jqXHR, textStatus, errorThrown] );
						},
						success: function( data, textStatus, jqXHR ) {
							filterSelector.call( container.find( '.streamLoading:not(.hidden)' ), cbactivity ).addClass( 'hidden' );

							element.removeClass( 'streamRequesting' );

							var response = null;

							try {
								response = JSON.parse( data );
							} catch( e ) {
								response = { message: data, type: null, output: null, target: null };
							}

							var responseMessage = ( typeof response.message !== 'undefined' ? response.message : null );

							filterSelector.call( container.find( '.streamItemAlert' ), cbactivity ).remove();

							var previousElement = cbactivity.element;

							if ( response && responseMessage ) {
								var newContent = $( responseMessage );
								var loadScripts = parseHeaders.call( newContent, cbactivity );

								var responseOutput = ( typeof response.output !== 'undefined' ? response.output : null );
								var responseTarget = ( typeof response.target !== 'undefined' ? response.target : null );

								if ( responseOutput || responseTarget ) {
									var target = null;

									if ( responseTarget ) {
										if ( responseTarget == 'self' ) {
											target = element;
										} else if ( responseTarget == 'items' ) {
											target = container.siblings( '.streamItems' );
										} else if ( responseTarget == 'container' ) {
											target = container;
										} else if ( responseTarget == 'stream' ) {
											target = cbactivity.element;
										} else {
											responseTarget = filterSelector.call( container.find( responseTarget ), cbactivity );

											if ( responseTarget.length ) {
												target = responseTarget;
											} else {
												target = element;
											}
										}
									} else {
										target = element;
									}

									switch( responseOutput ) {
										case 'before':
											target.before( newContent );
											break;
										case 'after':
											target.after( newContent );
											break;
										case 'prepend':
											if ( target.hasClass( 'hidden' ) ) {
												target.removeClass( 'hidden' );
											}

											target.prepend( newContent );
											break;
										case 'append':
											if ( target.hasClass( 'hidden' ) ) {
												target.removeClass( 'hidden' );
											}

											target.append( newContent );
											break;
										case 'replace':
										default:
											if ( responseTarget == 'container' ) {
												target.siblings( '.streamItemHeaders' ).remove();
											} else if ( responseTarget == 'stream' ) {
												previousElement = cbactivity.element.clone( true );
											}

											target.replaceWith( newContent );

											if ( responseTarget == 'container' ) {
												container = newContent;
											} else if ( responseTarget == 'stream' ) {
												cbactivity.element = newContent;
											}
											break;
									}
								} else {
									if ( isNew ) {
										cancelStreamNew.call( element, cbactivity, false );

										var items = container.siblings( '.streamItems' );

										if ( items.hasClass( 'hidden' ) ) {
											items.removeClass( 'hidden' );
										}

										filterSelector.call( items.children( '.streamEmpty' ), cbactivity ).remove();

										var first = null;

										if ( cbactivity.settings.direction == 'up' ) {
											first = filterSelector.call( items.find( '.streamItem[data-cbactivity-id]:not(.streamItemPinned):last' ), cbactivity );
										} else {
											first = filterSelector.call( items.find( '.streamItem[data-cbactivity-id]:not(.streamItemPinned):first' ), cbactivity );
										}

										if ( cbactivity.settings.direction == 'up' ) {
											if ( first.length ) {
												newContent.insertAfter( first );
											} else {
												items.append( newContent );
											}
										} else {
											if ( first.length ) {
												newContent.insertBefore( first );
											} else {
												items.prepend( newContent );
											}
										}
									} else {
										container.siblings( '.streamItemHeaders' ).remove();

										container.replaceWith( newContent );
									}

									container = newContent;
								}

								parseScripts.call( newContent, cbactivity, loadScripts );
							}

							previousElement.triggerHandler( 'cbactivity.save.success', [cbactivity, element, container, newContent, isNew, response, data, textStatus, jqXHR] );

							if ( response && responseMessage ) {
								bindContainer.call( container, cbactivity, true );
							}
						}
					});

					return false;
				};

				cbactivity.closeActionsHandler = function( e ) {
					e.preventDefault();

					var element = $( this );

					if ( element.hasClass( 'streamItemAction' ) ) {
						return;
					}

					var container = findContainer.call( element, cbactivity );

					if ( ! container.length ) {
						return;
					}

					container.siblings( '.streamItemHeaders' ).remove();

					container.remove();

					cbactivity.element.triggerHandler( 'cbactivity.actions.close', [cbactivity, element, container] );
				};

				cbactivity.revertActionsHandler = function( e ) {
					e.preventDefault();

					var element = $( this );

					if ( element.hasClass( 'streamItemAction' ) ) {
						return;
					}

					var container = findContainer.call( element, cbactivity );

					if ( ! container.length ) {
						return;
					}

					container.children( '.streamItemActionHidden' ).removeClass( 'streamItemActionHidden hidden' );

					filterSelector.call( container.find( '.streamItemActionResponse' ), cbactivity ).remove();
					filterSelector.call( container.find( '.streamItemAlert' ), cbactivity ).remove();
					filterSelector.call( container.find( '.streamLoading:not(.hidden)' ), cbactivity ).addClass( 'hidden' );

					cbactivity.element.triggerHandler( 'cbactivity.actions.revert', [cbactivity, element, container] );
				};

				cbactivity.closeActionHandler = function( e ) {
					e.preventDefault();

					var element = $( this );

					if ( element.hasClass( 'streamItemAction' ) ) {
						return;
					}

					var container = findContainer.call( element, cbactivity );

					if ( ! container.length ) {
						return;
					}

					filterSelector.call( element.closest( '.streamItemActionResponse' ), cbactivity ).remove();
					filterSelector.call( container.find( '.streamLoading:not(.hidden)' ), cbactivity ).addClass( 'hidden' );

					cbactivity.element.triggerHandler( 'cbactivity.action.close', [cbactivity, element, container] );
				};

				cbactivity.displayNewHandler = function( e ) {
					var element = $( this );
					var container = findContainer.call( element, cbactivity );

					if ( ! container.length ) {
						return;
					}

					if ( container.hasClass( 'streamItemActive' ) ) {
						return;
					}

					e.stopPropagation();

					container.addClass( 'streamItemActive' );

					var input = filterSelector.call( container.find( '.streamInputMessage' ), cbactivity );

					if ( input.hasClass( 'streamInputMessageCollapse' ) ) {
						filterSelector.call( container.find( '.streamItemDisplay.hidden' ), cbactivity ).removeClass( 'hidden' );
					}

					input.focus();

					cbactivity.element.triggerHandler( 'cbactivity.new.display', [cbactivity, element, container] );

					bindContainer.call( container, cbactivity );
				};

				cbactivity.messageLimitHandler = function( e ) {
					var element = $( this );
					var container = findContainer.call( element, cbactivity );

					if ( ! container.length ) {
						return;
					}

					var inputLimit = element.data( 'cbactivity-input-limit' );

					if ( typeof inputLimit != 'undefined' ) {
						var inputLength = element.val().length;

						if ( inputLength > inputLimit ) {
							element.val( element.val().substr( 0, inputLimit ) );
						} else {
							filterSelector.call( container.find( '.streamInputMessageLimitCurrent' ), cbactivity ).html( element.val().length );
						}
					}
				};

				cbactivity.scrollerLeftHandler = function( e ) {
					e.preventDefault();

					var element = $( this );
					var container = findContainer.call( element, cbactivity );

					if ( ! container.length ) {
						return;
					}

					var scroll = element.closest( '.streamItemScroll' );
					var active = scroll.children( '.streamItemScrollContent:not(.hidden)' );
					var previous = active.prevAll(  '.streamItemScrollContent.hidden:first' );

					if ( ! previous.length ) {
						previous = scroll.children( '.streamItemScrollContent.hidden:last' );
					}

					if ( ! previous.length ) {
						return;
					}

					previous.removeClass( 'hidden' );
					active.addClass( 'hidden' );

					scroll.children( '.streamItemScrollContent' ).find( '.streamItemScrollDisable' ).addClass( 'disabled' ).prop( 'disabled', true );
					scroll.children( '.streamItemScrollContent' ).find( '.streamItemScrollHide' ).addClass( 'hidden' );

					previous.find( '.streamItemScrollDisable' ).removeClass( 'disabled' ).prop( 'disabled', false );
					previous.find( '.streamItemScrollHide' ).removeClass( 'hidden' );

					bindContainer.call( container, cbactivity );
				};

				cbactivity.scrollerRightandler = function( e ) {
					e.preventDefault();

					var element = $( this );
					var container = findContainer.call( element, cbactivity );

					if ( ! container.length ) {
						return;
					}

					var scroll = element.closest( '.streamItemScroll' );
					var active = scroll.children( '.streamItemScrollContent:not(.hidden)' );
					var next = active.nextAll(  '.streamItemScrollContent.hidden:first' );

					if ( ! next.length ) {
						next = scroll.children( '.streamItemScrollContent.hidden:first' );
					}

					if ( ! next.length ) {
						return;
					}

					next.removeClass( 'hidden' );
					active.addClass( 'hidden' );

					scroll.children( '.streamItemScrollContent' ).find( '.streamItemScrollDisable' ).addClass( 'disabled' ).prop( 'disabled', true );
					scroll.children( '.streamItemScrollContent' ).find( '.streamItemScrollHide' ).addClass( 'hidden' );

					next.find( '.streamItemScrollDisable' ).removeClass( 'disabled' ).prop( 'disabled', false );
					next.find( '.streamItemScrollHide' ).removeClass( 'hidden' );

					bindContainer.call( container, cbactivity );
				};

				cbactivity.locationHandler = function( e ) {
					e.preventDefault();

					var element = $( this );
					var container = findContainer.call( element, cbactivity );

					if ( ! container.length ) {
						return;
					}

					var target = element.data( 'cbactivity-location-target' );
					var error = element.data( 'cbactivity-location-error' );
					var allowFilter = ( element.data( 'cbactivity-location-filter' ) != false );

					if ( typeof target == 'undefined' ) {
						if ( typeof error != 'undefined' ) {
							$.cbconfirm( error, { buttonNo: false } );
						}

						return;
					}

					if ( typeof navigator.geolocation == 'undefined' ) {
						if ( typeof error != 'undefined' ) {
							$.cbconfirm( error, { buttonNo: false } );
						}

						return;
					}

					navigator.geolocation.getCurrentPosition( function( position ) {
						var location = position.coords.latitude + ',' + position.coords.longitude;
						var containerTarget = container.find( target );

						if ( allowFilter ) {
							containerTarget = filterSelector.call( containerTarget, cbactivity );
						}

						if ( containerTarget.is( 'input' ) ) {
							containerTarget.val( location );
						} else {
							containerTarget.html( location );
						}
					}, function () {
						if ( typeof error != 'undefined' ) {
							$.cbconfirm( error, { buttonNo: false } );
						}
					});
				};

				cbactivity.toggleHandler = function( e ) {
					e.preventDefault();

					streamToggle.call( this, cbactivity );
				};

				cbactivity.insertHandler = function( e ) {
					e.preventDefault();

					streamInsert.call( this, cbactivity );
				};

				cbactivity.themeHandler = function( e ) {
					e.preventDefault();

					streamTheme.call( this, cbactivity );
				};

				cbactivity.cbselectHandler = function() {
					if ( $( this ).hasClass( 'streamInputSelectToggle' ) ) {
						streamToggle.call( this, cbactivity );
					}

					if ( $( this ).hasClass( 'streamInputSelectInsert' ) ) {
						streamInsert.call( this, cbactivity );
					}

					if ( $( this ).hasClass( 'streamInputTheme' ) ) {
						streamTheme.call( this, cbactivity );
					}
				};

				cbactivity.moreHandler = function( e ) {
					e.preventDefault();

					var element = $( this );

					if ( element.hasClass( 'streamRequesting' ) || element.hasClass( 'disabled' ) ) {
						return;
					}

					var type = 'more';

					if ( element.hasClass( 'streamLoad' ) ) {
						type = 'load';
					} else if ( element.hasClass( 'streamUpdate' ) ) {
						type = 'update';
					}

					var container = filterSelector.call( element.closest( '.streamContainer' ), cbactivity );

					if ( ! container.length ) {
						return;
					}

					var items = filterSelector.call( container.find( '.streamItems' ), cbactivity );
					var post = {};
					var first = null;

					if ( type == 'update' ) {
						if ( cbactivity.settings.direction == 'up' ) {
							first = filterSelector.call( container.find( '.streamItem[data-cbactivity-timestamp]:not(.streamItemPinned):last' ), cbactivity );
						} else {
							first = filterSelector.call( container.find( '.streamItem[data-cbactivity-timestamp]:not(.streamItemPinned):first' ), cbactivity );
						}

						var updateTime = ( Date.now ? Date.now() : +( new Date() ) );

						if ( first.length )  {
							var firstTime = first.data( 'cbactivity-timestamp' );

							if ( firstTime ) {
								updateTime = firstTime;
							}
						}

						post.id = updateTime;
					}

					var url = element.data( 'cbactivity-' + type + '-url' );

					if ( ! url ) {
						url = element.attr( 'href' );
					}

					if ( ! url ) {
						return;
					}

					$.ajax({
						url: url,
						type: 'GET',
						data: post,
						dataType: 'html',
						beforeSend: function( jqXHR, settings ) {
							element.addClass( 'streamRequesting' );

							if ( type == 'load' ) {
								if ( element.hasClass( 'streamFilter' ) ) {
									element.siblings( '.streamFilter' ).addBack().addClass( 'text-muted text-plain disabled' ).prop( 'disabled', true );
								}

								filterSelector.call( container.find( '.streamLoading.hidden' ), cbactivity ).removeClass( 'hidden' );
								filterSelector.call( container.find( '.streamMore:not(.disabled)' ), cbactivity ).addClass( 'disabled' ).prop( 'disabled', true );
							} else if ( type == 'more' ) {
								element.addClass( 'disabled' ).prop( 'disabled', true ).html( '<div class=\"streamIconMoreLoading spinner-border spinner-border-sm\"></div>' );
							}

							cbactivity.element.triggerHandler( 'cbactivity.' + type + '.send', [cbactivity, element, container, jqXHR, settings] );
						}
					}).fail( function( jqXHR, textStatus, errorThrown ) {
						element.removeClass( 'streamRequesting' );

						if ( type == 'load' ) {
							if ( element.hasClass( 'streamFilter' ) ) {
								element.siblings( '.streamFilter' ).addBack().removeClass( 'text-muted text-plain disabled' ).prop( 'disabled', false );
							}

							filterSelector.call( container.find( '.streamLoading:not(.hidden)' ), cbactivity ).addClass( 'hidden' );
							filterSelector.call( container.find( '.streamMore.disabled' ), cbactivity ).removeClass( 'disabled' ).prop( 'disabled', false );
						} else if ( type == 'more' ) {
							element.remove();
						}

						cbactivity.element.triggerHandler( 'cbactivity.' + type + '.error', [cbactivity, element, container, jqXHR, textStatus, errorThrown] );
					}).done( function( data, textStatus, jqXHR ) {
						if ( type == 'load' ) {
							element.siblings( '.streamFilter.disabled' ).removeClass( 'text-muted text-plain disabled' ).prop( 'disabled', false );

							filterSelector.call( container.find( '.streamLoading:not(.hidden)' ), cbactivity ).addClass( 'hidden' );
						}

						element.removeClass( 'streamRequesting' );

						var newMore = null;

						if ( data ) {
							var dataHtml = $( data );

							dataHtml.find( '.streamItems > .streamItem' ).each( function() {
								if ( filterSelector.call( container.find( '.streamItem[data-cbactivity-id="' + $( this ).data( 'cbactivity-id' ) + '"]' ), cbactivity ).length ) {
									$( this ).remove();
								}
							});

							var loadScripts = parseHeaders.call( dataHtml, cbactivity );

							if ( type == 'load' ) {
								items.html( dataHtml );

								newMore = filterSelector.call( items.find( '.streamMoreContainer' ), cbactivity );
							} else if ( cbactivity.settings.direction == 'up' ) {
								if ( type == 'update' ) {
									if ( first.length ) {
										dataHtml.insertAfter( first );
									} else {
										items.append( dataHtml );
									}
								} else {
									items.prepend( dataHtml );

									newMore = filterSelector.call( container.find( '.streamMore:not(.disabled)' ), cbactivity );
								}
							} else {
								if ( type == 'update' ) {
									if ( first.length ) {
										dataHtml.insertBefore( first );
									} else {
										items.prepend( dataHtml );
									}
								} else {
									items.append( dataHtml );

									newMore = filterSelector.call( container.find( '.streamMore:not(.disabled)' ), cbactivity );
								}
							}

							parseScripts.call( dataHtml, cbactivity, loadScripts );
						} else if ( type == 'load' ) {
							items.html( '' );
						}

						var newMoreContainer = null;

						if ( type == 'load' ) {
							var oldMore = filterSelector.call( items.siblings( '.streamMoreContainer' ), cbactivity );

							if ( newMore && newMore.length ) {
								if ( newMore.hasClass( 'streamMore' ) )  {
									newMoreContainer = newMore.parent( '.streamMoreContainer' );
								}

								if ( oldMore.length ) {
									oldMore.replaceWith( newMore );
								} else {
									if ( cbactivity.settings.direction == 'up' ) {
										newMore.insertBefore( items );
									} else {
										newMore.insertAfter( items );
									}
								}
							} else if ( oldMore.length ) {
								oldMore.remove();
							}
						} else if ( type == 'more' ) {
							if ( newMore && newMore.length ) {
								if ( newMore.hasClass( 'streamMore' ) )  {
									newMoreContainer = newMore.parent( '.streamMoreContainer' );
								}

								element.replaceWith( newMore );
							} else {
								var moreContainer = element.closest( '.streamMoreContainer' );

								if ( moreContainer.length ) {
									moreContainer.remove();
								} else {
									element.remove();
								}
							}
						}

						if ( newMoreContainer && newMoreContainer.length ) {
							newMoreContainer.remove();
						}

						cbactivity.element.triggerHandler( 'cbactivity.' + type + '.success', [cbactivity, element, container, dataHtml, data, textStatus, jqXHR] );

						if ( data ) {
							bindContainer.call( dataHtml, cbactivity, true );

							if ( type == 'update' ) {
								if ( cbactivity.settings.autoUpdate ) {
									if ( ! $.fn.cbactivity.loader.autoUpdaterReady ) {
										// Restart the auto updater if it has expired:
										autoUpdater();
									} else {
										$.fn.cbactivity.loader.autoUpdaterAttempts = 0;
									}
								}
							} else {
								filterSelector.call( cbactivity.element.find( '.streamMore' ), cbactivity ).on( 'click', cbactivity.moreHandler );

								if ( cbactivity.settings.autoLoad && ( cbactivity.settings.direction != 'up' ) ) {
									if ( ! $.fn.cbactivity.loader.autoLoaderReady ) {
										// Restart the auto loader if it has expired:
										autoLoader();
									} else {
										$.fn.cbactivity.loader.autoLoaderAttempts = 0;
									}
								}
							}
						}
					});
				};

				cbactivity.cbselectFormat = function( selection, container ) {
					var icon = null;

					if ( typeof selection.icon != 'undefined' ) {
						icon = selection.icon;
					} else {
						icon = $( selection.element ).data( 'cbactivity-option-icon' );
					}

					if ( ( typeof icon != 'undefined' ) && icon ) {
						return icon + selection.text;
					} else {
						return selection.text;
					}
				};

				cbactivity.modalHandler = function( e, cbtooltip ) {
					e.preventDefault();

					var element = $( this );

					if ( element.hasClass( 'streamRequesting' ) || element.hasClass( 'disabled' ) ) {
						return false;
					}

					var modalUrl = element.data( 'cbactivity-modal-url' );

					if ( ! modalUrl ) {
						modalUrl = element.attr( 'href' );
					}

					if ( ! modalUrl ) {
						return false;
					}

					element.addClass( 'streamRequesting' );

					var ajax = null;

					cbtooltip.tooltip.qtip( 'api' ).set( 'content.text', function( e, api ) {
						if ( ajax == null ) {
							ajax = $.ajax({
								url: modalUrl,
								type: 'GET',
								dataType: 'html',
								beforeSend: function( jqXHR, settings ) {
									cbactivity.element.triggerHandler( 'cbactivity.modal.send', [cbactivity, element, jqXHR, settings] );
								}
							}).fail( function( jqXHR, textStatus, errorThrown ) {
								element.removeClass( 'streamRequesting' );

								if ( ! api.destroyed ) {
									api.hide();
								}

								cbactivity.element.triggerHandler( 'cbactivity.modal.error', [cbactivity, element, jqXHR, textStatus, errorThrown] );
							}).done( function( data, textStatus, jqXHR ) {
								element.removeClass( 'streamRequesting' );

								if ( api.destroyed ) {
									return;
								}

								api.elements.tooltip.removeClass( 'streamModalContainerLoad streamModalContainerLoading' );

								var dataHtml = null;

								if ( data ) {
									dataHtml = $( data );

									var loadScripts = parseHeaders.call( dataHtml, cbactivity );

									api.set( 'content.text', dataHtml );

									parseScripts.call( api.elements.content, cbactivity, loadScripts );
								} else {
									api.hide();
								}

								cbactivity.element.triggerHandler( 'cbactivity.modal.success', [cbactivity, element, dataHtml, data, textStatus, jqXHR] );

								if ( data ) {
									bindContainer.call( api.elements.content, cbactivity, true );
								}
							});
						}

						return '<div class="text-center m-3 streamModalLoading"><div class="spinner-border spinner-border-sm text-secondary"></div></div>';
					});

					cbactivity.element.triggerHandler( 'cbactivity.modal', [cbactivity, element, cbtooltip, ajax, e] );

					return ajax;
				};

				cbactivity.cbselectBeforeHandler = function( e, cbselect ) {
					if ( cbselect.element.val() > 0 ) {
						var target = cbselect.element.data( 'cbactivity-toggle-target' );

						if ( typeof target == 'undefined' ) {
							return;
						}

						var container = findContainer.call( cbselect.element, cbactivity );

						if ( ! container.length ) {
							return;
						}

						var selected = cbselect.element.find( ':selected' );
						var label = filterSelector.call( container.find( target ).find( '.streamInputSelectToggleLabel' ), cbactivity );

						if ( label.length ) {
							label.html( selected.text() );
						}

						var placeholderInput = filterSelector.call( container.find( target ).find( '.streamInputSelectTogglePlaceholder' ), cbactivity );

						if ( placeholderInput.length ) {
							var placeholder = selected.data( 'cbactivity-toggle-placeholder' );

							if ( typeof placeholder != 'undefined' ) {
								placeholderInput.attr( 'placeholder', placeholder );
							} else {
								placeholderInput.attr( 'placeholder', '' );
							}
						}

						var suggestionsInput = filterSelector.call( container.find( target ).find( '.streamInputAutoComplete' ), cbactivity );

						if ( suggestionsInput.length ) {
							var suggestions = selected.data( 'cbactivity-toggle-suggestions' );

							if ( typeof suggestions != 'undefined' ) {
								suggestionsInput.autocomplete( 'option', 'source', suggestions );
							} else {
								suggestionsInput.autocomplete( 'option', 'source', [] );
							}
						}
					}
				};

				cbactivity.cbselectAfterHandler = function( e, cbselect ) {
					var icon = cbselect.element.data( 'cbactivity-toggle-icon' );

					if ( typeof icon == 'undefined' ) {
						return;
					}

					cbselect.container.find( '.select2-selection' ).addClass( icon );
				};

				cbactivity.mediaToggleHandler = function( e ) {
					if ( $( this ).hasClass( 'streamToggleMediaOpen' ) ) {
						return;
					}

					$( this ).addClass( 'streamToggleMediaOpen' );
					$( this ).find( '.streamToggleMediaPreview' ).addClass( 'hidden' );
					$( this ).find( 'iframe,video,audio' ).attr( 'src', $( this ).data( 'cbgallery-video' ) ).removeClass( 'hidden' );
					$( this ).find( 'video,audio' ).attr( 'autoplay', 'autoplay' );
				};

				// Delegate action handling for tooltip usages (e.g. menus and modals):
				if ( cbactivity.stream ) {
					$( document ).on( 'click.cbactivity', 'body > .cb_template .streamItemAction[data-cbactivity-stream="' + cbactivity.stream + '"],.streamItemActions[data-cbactivity-stream="' + cbactivity.stream + '"] .streamItemAction', cbactivity.actionHandler );
				}

				// Destroy the cbactivity element:
				cbactivity.element.on( 'remove destroy.cbactivity', function() {
					cbactivity.element.cbactivity( 'destroy' );
				});

				// Rebind the cbactivity element to pick up any data attribute modifications:
				cbactivity.element.on( 'rebind.cbactivity', function() {
					cbactivity.element.cbactivity( 'rebind' );
				});

				// If the cbactivity element is modified we need to rebuild it to ensure all our bindings are still ok:
				cbactivity.element.on( 'modified.cbactivity', function( e, oldId, newId, index ) {
					if ( oldId != newId ) {
						cbactivity.element.cbactivity( 'rebind' );
					}
				});

				// If the cbactivity is cloned we need to rebind it back:
				cbactivity.element.on( 'cloned.cbactivity', function() {
					destroyStream.call( this, cbactivity );

					$( this ).cbactivity( cbactivity.options );
				});

				cbactivity.element.triggerHandler( 'cbactivity.init.after', [cbactivity] );

				// Bind the cbactivity to the element so it's reusable and chainable:
				cbactivity.element.data( 'cbactivity', cbactivity );

				// Add this instance to our instance array so we can keep track of our cbactivity instances:
				instances.push( cbactivity );

				bindContainer.call( $this, cbactivity, true );

				if ( cbactivity.settings.autoUpdate && ( ! $.fn.cbactivity.loader.autoUpdaterReady ) ) {
					// Don't start auto updater until at least 1 auto update stream is established and only if it hasn't already been started:
					autoUpdater();
				}

				if ( cbactivity.settings.autoLoad && ( cbactivity.settings.direction != 'up' ) && ( ! $.fn.cbactivity.loader.autoLoaderReady ) ) {
					// Don't start auto loader until at least 1 auto load stream is established and only if it hasn't already been started:
					autoLoader();
				}
			});
		},
		rebind: function() {
			var cbactivity = $( this ).data( 'cbactivity' );

			if ( ! cbactivity ) {
				return this;
			}

			cbactivity.element.cbactivity( 'destroy' );
			cbactivity.element.cbactivity( cbactivity.options );

			return this;
		},
		destroy: function() {
			var cbactivity = $( this ).data( 'cbactivity' );

			if ( ! cbactivity ) {
				return this;
			}

			$.each( instances, function( i, instance ) {
				if ( instance.element == cbactivity.element ) {
					instances.splice( i, 1 );

					return false;
				}

				return true;
			});

			destroyStream.call( cbactivity.element, cbactivity );

			cbactivity.element.triggerHandler( 'cbactivity.destroyed', [cbactivity] );

			return this;
		},
		instances: function() {
			return instances;
		}
	};

	function destroyStream( cbactivity ) {
		var element = ( this.jquery ? this : $( this ) );

		element.off( 'destroy.cbactivity' );
		element.off( 'rebind.cbactivity' );
		element.off( 'modified.cbactivity' );
		element.off( 'cloned.cbactivity' );
		element.removeData( 'cbactivity' );

		if ( cbactivity.stream ) {
			$( document ).off( 'click.cbactivity', 'body > .cb_template .streamItemAction[data-cbactivity-stream="' + cbactivity.stream + '"],.streamItemActions[data-cbactivity-stream="' + cbactivity.stream + '"] .streamItemAction', cbactivity.actionHandler );
		}

		filterSelector.call( element.find( '.streamItem[data-cbactivity-link]' ), cbactivity ).off( 'click', cbactivity.linkHandler );
		filterSelector.call( element.find( '.streamItemNewCancel' ), cbactivity ).off( 'click', cbactivity.cancelNewHandler );
		filterSelector.call( element.find( '.streamItemInputGroup' ), cbactivity ).off( 'click', cbactivity.inputFocusHandler );
		filterSelector.call( element.find( '.streamItemForm' ), cbactivity ).off( 'submit', cbactivity.saveHandler );
		filterSelector.call( element.find( '.streamItemAction' ), cbactivity ).off( 'click', cbactivity.actionHandler );
		filterSelector.call( element.find( '.streamItemActionResponsesClose' ), cbactivity ).off( 'click', cbactivity.closeActionsHandler );
		filterSelector.call( element.find( '.streamItemActionResponsesRevert' ), cbactivity ).off( 'click', cbactivity.revertActionsHandler );
		filterSelector.call( element.find( '.streamItemActionResponseClose' ), cbactivity ).off( 'click', cbactivity.closeActionHandler );
		filterSelector.call( element.find( '.streamItemNew .streamInputMessage.streamInputMessageCollapse' ), cbactivity ).off( 'click', cbactivity.displayNewHandler );
		filterSelector.call( element.find( '.streamInputMessage[data-cbactivity-input-limit]' ), cbactivity ).off( 'keyup input change', cbactivity.messageLimitHandler );
		filterSelector.call( element.find( '.streamItemScrollLeft' ), cbactivity ).off( 'click', cbactivity.scrollerLeftHandler );
		filterSelector.call( element.find( '.streamItemScrollRight' ), cbactivity ).off( 'click', cbactivity.scrollerRightandler );
		filterSelector.call( element.find( '.streamFindLocation' ), cbactivity ).off( 'click', cbactivity.locationHandler );
		filterSelector.call( element.find( '.streamToggle' ), cbactivity ).off( 'click', cbactivity.toggleHandler );
		filterSelector.call( element.find( 'select.streamInputSelect' ), cbactivity ).off( 'change', cbactivity.cbselectHandler );
		filterSelector.call( element.find( '.streamMore,.streamUpdate,.streamLoad' ), cbactivity ).off( 'click', cbactivity.moreHandler );
		filterSelector.call( element.find( '.streamModal' ), cbactivity ).off( 'cbtooltip.render', cbactivity.modalHandler );
		filterSelector.call( element.find( '.streamToggleMedia' ), cbactivity ).off( 'click', cbactivity.mediaToggleHandler );

		filterSelector.call( element.find( '.cbMoreLess' ), cbactivity ).cbmoreless( 'destroy' );
		filterSelector.call( element.find( '.cbRepeat' ), cbactivity ).cbrepeat( 'destroy' );
		filterSelector.call( element.find( 'select.streamInputSelect' ), cbactivity ).cbselect( 'destroy' );
		filterSelector.call( element.find( 'input.streamInputAutoComplete,textarea.streamInputAutoComplete' ), cbactivity ).autocomplete( 'destroy' );
		filterSelector.call( element.find( '.streamInputAutosize' ), cbactivity ).trigger( 'autosize.destroy' );

		filterSelector.call( element.find( '.streamItem' ), cbactivity ).each( function() {
			var activeClasses = $( this ).data( 'cbactivity-active-classes' );
			var inactiveClasses = $( this ).data( 'cbactivity-inactive-classes' );

			if ( typeof activeClasses != 'undefined' ) {
				$( this ).removeClass( activeClasses );
			}

			if ( typeof inactiveClasses != 'undefined' ) {
				$( this ).addClass( inactiveClasses );
			}
		});
	}

	function filterSelector( cbactivity ) {
		var element = ( this.jquery ? this : $( this ) );

		return	element.filter( function() {
					return ( $( this ).closest( '.streamContainer' ).is( cbactivity.element ) || $( this ).is( cbactivity.element ) );
				});
	}

	function findContainer( cbactivity, containerId ) {
		var element = ( this.jquery ? this : $( this ) );
		var container = filterSelector.call( element.closest( '.streamItem' ), cbactivity );

		if ( typeof containerId == 'undefined' ) {
			containerId = element.data( 'cbactivity-container' );
		}

		if ( typeof containerId != 'undefined' ) {
			if ( containerId == 'self' ) {
				container = element;
			} else if ( containerId == 'items' ) {
				container = element.closest( '.streamItems' );
			} else if ( containerId == 'item' ) {
				container = element.closest( '.streamItem' );
			} else if ( containerId == 'stream' ) {
				container = element.closest( '.streamContainer' );
			} else {
				container = $( containerId );

				if ( element.data( 'cbactivity-container-filter' ) != false ) {
					container = filterSelector.call( container, cbactivity );
				}
			}
		}

		return container;
	}

	function bindContainer( cbactivity, init ) {
		var element = ( this.jquery ? this : $( this ) );

		if ( init === true ) {
			filterSelector.call( element.find( '.cbMoreLess' ), cbactivity ).cbmoreless({ height: 400, tolerance: 400 });
			filterSelector.call( element.find( '.cbRepeat' ), cbactivity ).cbrepeat().on( 'cbrepeat.add', function() {
				$( this ).find( 'input,textarea,select' ).last().focus();
			});

			filterSelector.call( element.find( 'input.streamInputAutoComplete,textarea.streamInputAutoComplete' ), cbactivity ).each( function() {
				var suggestions = $( this ).data( 'cbactivity-suggestions' );

				if ( suggestions ) {
					suggestions = [];
				}

				$( this ).autocomplete({
					appendTo: cbactivity.element,
					classes: {
						'ui-autocomplete': 'm-0 p-0 list-unstyled bg-white border border-top-0 rounded-top-0 rounded-bottom auto-overflow cbActivityAutoCompleteResults'
					},
					minLength: ( suggestions ? 3 : 0 ),
					source: suggestions,
					select: function( event, ui ) {
						if ( ( typeof ui.item.emote != 'undefined' ) && ui.item.emote ) {
							var emoteInput = $( this ).closest( '.streamItemInputGroup' ).find( '.streamInputEmote' );

							if ( typeof emoteInput.data( 'cbselect' ) != 'undefined' ) {
								emoteInput.cbselect( 'set', ui.item.emote );
							} else {
								emoteInput.val( ui.item.emote );
							}
						}
					}
				}).autocomplete( 'widget' ).css({
					fontFamily: 'inherit',
					fontSize: 'inherit',
					maxHeight: '200px'
				}).menu( 'option', {
					classes: {
						'ui-menu-item': 'cbActivityAutoCompleteResult',
						'ui-menu-item-wrapper': 'm-0 p-2 bg-none border-0 text-inherit clearfix cbActivityAutoCompleteOption'
					},
					blur: function( event, ui ) {
						ui.item.removeClass( 'bg-primary cbActivityAutoCompleteActive' );
						ui.item.children( '.ui-menu-item-wrapper' ).removeClass( 'text-white' );
					},
					focus: function( event, ui ) {
						ui.item.addClass( 'bg-primary cbActivityAutoCompleteActive' );
						ui.item.children( '.ui-menu-item-wrapper' ).addClass( 'text-white' );
					}
				});

				$( this ).autocomplete( 'instance' )._renderItem = function( ul, item ) {
					return $( '<li>' ).append( $( '<div>' ).html( item.label ) ).appendTo( ul );
				}
			});

			filterSelector.call( element.find( 'select.streamInputSelect' ), cbactivity ).on( 'cbselect.init.before', cbactivity.cbselectBeforeHandler ).on( 'cbselect.init.after', cbactivity.cbselectAfterHandler );

			filterSelector.call( element.find( 'select.streamInputSelect:not(.streamInputTags):not([data-cbselect-url])' ), cbactivity ).cbselect({
				width: 'auto',
				height: 'auto',
				minimumResultsForSearch: Infinity,
				escapeMarkup: function( message ) {
					return message;
				},
				templateSelection: cbactivity.cbselectFormat,
				templateResult: cbactivity.cbselectFormat
			});

			filterSelector.call( element.find( 'select.streamInputSelect[data-cbselect-url]:not(.streamInputTags)' ), cbactivity ).each( function() {
				var minimumSearchLength = ( $( this ).find( 'option' ).length ? 3 : 0 );

				$( this ).cbselect({
					width: 'auto',
					height: 'auto',
					minimumInputLength: minimumSearchLength,
					maximumInputLength: ( element.data( 'cbactivity-options-search' ) != false ? 20 : 0 ),
					minimumResultsForSearch: ( element.data( 'cbactivity-options-search' ) != false ? 0 : Infinity ),
					templateSelection: cbactivity.cbselectFormat,
					templateResult: cbactivity.cbselectFormat,
					escapeMarkup: function( message ) {
						return message;
					},
					language: {
						errorLoading: function () {
							return null;
						},
						inputTooLong: function () {
							return null;
						},
						inputTooShort: function () {
							return null;
						},
						loadingMore: function () {
							return '<div class="text-center streamOptionsMore"><div class=\"spinner-border spinner-border-sm\"></div></div>';
						},
						noResults: function () {
							return null;
						},
						searching: function () {
							return null;
						}
					}
				});
			});

			filterSelector.call( element.find( 'select.streamInputSelect.streamInputTags' ), cbactivity ).cbselect({
				width: 'auto',
				height: 'auto',
				minimumInputLength: 3,
				maximumInputLength: 40,
				minimumResultsForSearch: 0,
				templateResult: cbactivity.cbselectFormat,
				language: {
					errorLoading: function () {
						return null;
					},
					inputTooLong: function () {
						return null;
					},
					inputTooShort: function () {
						return null;
					},
					loadingMore: function () {
						return '<div class="text-center streamOptionsMore"><div class=\"spinner-border spinner-border-sm\"></div></div>';
					},
					noResults: function () {
						return null;
					},
					searching: function () {
						return null;
					}
				}
			});

			filterSelector.call( element.find( '.cbTooltip,[data-hascbtooltip=\"true\"]' ), cbactivity ).cbtooltip();

			if ( element.is( '[data-cbactivity-link]' ) ) {
				element.on( 'click', cbactivity.linkHandler );
			}

			filterSelector.call( element.find( '.streamItem[data-cbactivity-link]' ), cbactivity ).on( 'click', cbactivity.linkHandler );
			filterSelector.call( element.find( '.streamItemNewCancel' ), cbactivity ).on( 'click', cbactivity.cancelNewHandler );
			filterSelector.call( element.find( '.streamItemInputGroup' ), cbactivity ).on( 'click', cbactivity.inputFocusHandler );
			filterSelector.call( element.find( '.streamItemForm' ), cbactivity ).on( 'submit', cbactivity.saveHandler );
			filterSelector.call( element.find( '.streamItemAction' ), cbactivity ).on( 'click', cbactivity.actionHandler );
			filterSelector.call( element.find( '.streamItemActionResponsesClose' ), cbactivity ).on( 'click', cbactivity.closeActionsHandler );
			filterSelector.call( element.find( '.streamItemActionResponsesRevert' ), cbactivity ).on( 'click', cbactivity.revertActionsHandler );
			filterSelector.call( element.find( '.streamItemActionResponseClose' ), cbactivity ).on( 'click', cbactivity.closeActionHandler );
			filterSelector.call( element.find( '.streamItemNew .streamInputMessage.streamInputMessageCollapse' ), cbactivity ).on( 'click', cbactivity.displayNewHandler );
			filterSelector.call( element.find( '.streamInputMessage[data-cbactivity-input-limit]' ), cbactivity ).on( 'keyup input change', cbactivity.messageLimitHandler );
			filterSelector.call( element.find( '.streamItemScrollLeft' ), cbactivity ).on( 'click', cbactivity.scrollerLeftHandler );
			filterSelector.call( element.find( '.streamItemScrollRight' ), cbactivity ).on( 'click', cbactivity.scrollerRightandler );
			filterSelector.call( element.find( '.streamFindLocation' ), cbactivity ).on( 'click', cbactivity.locationHandler );
			filterSelector.call( element.find( '.streamToggle' ), cbactivity ).on( 'click', cbactivity.toggleHandler );
			filterSelector.call( element.find( 'select.streamInputSelect' ), cbactivity ).on( 'change', cbactivity.cbselectHandler );
			filterSelector.call( element.find( '.streamMore,.streamUpdate,.streamLoad' ), cbactivity ).on( 'click', cbactivity.moreHandler );
			filterSelector.call( element.find( '.streamModal' ), cbactivity ).on( 'cbtooltip.render', cbactivity.modalHandler );
			filterSelector.call( element.find( '.streamToggleMedia' ), cbactivity ).on( 'click', cbactivity.mediaToggleHandler );

			filterSelector.call( element.find( '.streamInputAutosize' ), cbactivity ).autosize({
				append: '',
				resizeDelay: 0,
				placeholder: false
			});
		}

		filterSelector.call( element.find( '.streamInputAutosize' ), cbactivity ).trigger( 'autosize.resize' );

		cbactivity.element.triggerHandler( 'cbactivity.bind', [cbactivity, element, init] );
	}

	function streamToggle( cbactivity ) {
		var element = ( this.jquery ? this : $( this ) );
		var container = findContainer.call( element, cbactivity );

		if ( ! container.length ) {
			return;
		}

		var cbselect = ( typeof element.data( 'cbselect' ) != 'undefined' );

		var target = element.data( 'cbactivity-toggle-target' );
		var activeClasses = element.data( 'cbactivity-toggle-active-classes' );
		var inactiveClasses = element.data( 'cbactivity-toggle-inactive-classes' );

		var allowOpen = ( element.data( 'cbactivity-toggle-open' ) != false );
		var allowClose = ( element.data( 'cbactivity-toggle-close' ) != false );
		var allowFilter = ( element.data( 'cbactivity-toggle-filter' ) != false );

		var open = false;

		if ( cbselect || element.is( 'select' ) ) {
			var value = element.val();

			if ( cbselect ) {
				value = element.cbselect( 'get' );
			}

			open = ( ( ! value ) || ( value == 0 ) || ( value == '' ) );
		} else {
			if ( element.hasClass( 'streamToggleOpen' ) ) {
				open = true;
			}
		}

		if ( element.hasClass( 'streamInputSelect' ) && ( typeof target != 'undefined' ) ) {
			var selected = element.find( ':selected' );
			var label = filterSelector.call( container.find( target ).find( '.streamInputSelectToggleLabel' ), cbactivity );

			if ( label.length ) {
				label.html( selected.text() );
			}

			var placeholderInput = filterSelector.call( container.find( target ).find( '.streamInputSelectTogglePlaceholder' ), cbactivity );

			if ( placeholderInput.length ) {
				var placeholder = selected.data( 'cbactivity-toggle-placeholder' );

				if ( typeof placeholder != 'undefined' ) {
					placeholderInput.attr( 'placeholder', placeholder );
				} else {
					placeholderInput.attr( 'placeholder', '' );
				}
			}

			var suggestionsInput = filterSelector.call( container.find( target ).find( '.streamInputAutoComplete' ), cbactivity );

			if ( suggestionsInput.length ) {
				var suggestions = selected.data( 'cbactivity-toggle-suggestions' );

				if ( typeof suggestions != 'undefined' ) {
					suggestionsInput.autocomplete( 'option', 'source', suggestions );
				} else {
					suggestionsInput.autocomplete( 'option', 'source', [] );
				}
			}
		}

		if ( open ) {
			if ( allowClose ) {
				element.removeClass( 'streamToggleOpen' );

				if ( cbselect ) {
					element.cbselect( 'container' ).removeClass( 'streamToggleOpen' );
				}

				if ( typeof activeClasses != 'undefined' ) {
					element.removeClass( activeClasses );

					if ( cbselect ) {
						element.cbselect( 'container' ).removeClass( activeClasses );
					}
				}

				if ( typeof inactiveClasses != 'undefined' ) {
					element.addClass( inactiveClasses );

					if ( cbselect ) {
						element.cbselect( 'container' ).addClass( inactiveClasses );
					}
				}

				if ( typeof target != 'undefined' ) {
					if ( allowFilter ) {
						filterSelector.call( container.find( target ), cbactivity ).addClass( 'hidden' );
						filterSelector.call( container.find( target ).find( 'input,textarea,select' ), cbactivity ).prop( 'disabled', true );
					} else {
						container.find( target ).addClass( 'hidden' );
						container.find( target ).find( 'input,textarea,select' ).prop( 'disabled', true );
					}
				}
			}
		} else {
			if ( allowOpen ) {
				element.addClass( 'streamToggleOpen' );

				if ( cbselect ) {
					element.cbselect( 'container' ).addClass( 'streamToggleOpen' );
				}

				if ( typeof activeClasses != 'undefined' ) {
					element.addClass( activeClasses );

					if ( cbselect ) {
						element.cbselect( 'container' ).addClass( activeClasses );
					}
				}

				if ( typeof inactiveClasses != 'undefined' ) {
					element.removeClass( inactiveClasses );

					if ( cbselect ) {
						element.cbselect( 'container' ).removeClass( inactiveClasses );
					}
				}

				if ( typeof target != 'undefined' ) {
					var inputs = null;

					if ( allowFilter ) {
						filterSelector.call( container.find( target ), cbactivity ).removeClass( 'hidden' );

						inputs = filterSelector.call( container.find( target ).find( 'input,textarea,select' ), cbactivity ).prop( 'disabled', false );
					} else {
						container.find( target ).removeClass( 'hidden' );

						inputs = container.find( target ).find( 'input,textarea,select' ).prop( 'disabled', false );
					}

					setTimeout( function() {
						var focusInput = inputs.filter( ':not(.hidden)' ).first();

						focusInput.focus();

						if ( focusInput.hasClass( 'streamInputAutoComplete' ) ) {
							focusInput.autocomplete( 'search', '' );
						}
					}, 2 );
				}
			}
		}

		if ( element.hasClass( 'streamInputCheckbox' ) ) {
			var checkbox = element.find( 'input[type="checkbox"]' );

			if ( open ) {
				checkbox.prop( 'checked', false );
			} else {
				checkbox.prop( 'checked', true );
			}
		}
	}

	function streamInsert( cbactivity ) {
		var element = ( this.jquery ? this : $( this ) );
		var container = findContainer.call( element, cbactivity );

		if ( ! container.length ) {
			return;
		}

		var cbselect = ( typeof element.data( 'cbselect' ) != 'undefined' );
		var value = element.val();

		if ( cbselect ) {
			value = element.cbselect( 'get' );
		}

		if ( ( ! value ) || ( value == 0 ) ) {
			return;
		}

		var insert = element.find( 'option[value="' + value + '"]' ).data( 'cbactivity-option-insert' );

		if ( typeof insert == 'undefined' ) {
			insert = value;
		}

		var input = filterSelector.call( container.find( '.streamInputMessage' ), cbactivity );
		var position = input.prop( 'selectionStart' );

		var text = input.val();
		var textBefore = text.substring( 0, position );
		var textAfter = text.substring( position, text.length );

		input.val( textBefore + insert + textAfter ).trigger( 'change' ).trigger( 'autosize.resize' );

		position = ( input.val().indexOf( textBefore + insert ) + ( textBefore + insert ).length );

		if ( cbselect ) {
			element.cbselect( 'set', '' );
		} else {
			element.val( '' ).trigger( 'change' );
		}

		setTimeout( function() {
			input.focus();

			if ( input.get( 0 ).setSelectionRange ) {
				input.get( 0 ).setSelectionRange( position, position );
			}
		}, 2 );
	}

	function streamTheme( cbactivity ) {
		var element = ( this.jquery ? this : $( this ) );
		var container = findContainer.call( element, cbactivity );

		if ( ! container.length ) {
			return;
		}

		var cbselect = ( typeof element.data( 'cbselect' ) != 'undefined' );
		var value = element.val();

		if ( cbselect ) {
			value = element.cbselect( 'get' );
		}

		var inputContainer = filterSelector.call( container.find( '.streamInputMessageContainer' ), cbactivity );

		inputContainer.removeClass( 'streamMessageTheme' );

		if ( inputContainer.data( 'cbactivity-active-theme-background' ) ) {
			inputContainer.css({ backgroundImage: '' });
			inputContainer.data( 'cbactivity-active-theme-background', '' );
		}

		var activeThemeClass = inputContainer.data( 'cbactivity-active-theme-class' );

		if ( activeThemeClass ) {
			inputContainer.removeClass( activeThemeClass );
			inputContainer.data( 'cbactivity-active-theme-class', '' );
		}

		var input = filterSelector.call( container.find( '.streamInputMessage' ), cbactivity );

		if ( ( ! value ) || ( value == 0 ) ) {
			if ( container.hasClass( 'streamItemActive' ) ) {
				input.trigger( 'autosize.resize' );

				setTimeout( function() {
					input.focus();
				}, 2 );
			}

			return;
		}

		inputContainer.addClass( 'streamMessageTheme' );

		var option = element.find( 'option[value="' + value + '"]' );
		var background = option.data( 'cbactivity-option-background' );
		var cssClass = option.data( 'cbactivity-option-class' );

		if ( background ) {
			inputContainer.css({ backgroundImage: 'url(' + background + ')' });
			inputContainer.data( 'cbactivity-active-theme-background', background );
		}

		if ( cssClass ) {
			inputContainer.addClass( cssClass );
			inputContainer.data( 'cbactivity-active-theme-class', cssClass );
		}

		input.trigger( 'autosize.resize' );

		setTimeout( function() {
			input.focus();
		}, 2 );
	}

	function cancelStreamNew( cbactivity, isCancel ) {
		var element = ( this.jquery ? this : $( this ) );
		var container = findContainer.call( element, cbactivity );

		if ( ! container.length ) {
			return;
		}

		container.removeClass( 'streamItemActive' );

		filterSelector.call( container.find( '.streamItemActionResponse' ), cbactivity ).remove();

		var input = filterSelector.call( container.find( '.streamInputMessage' ), cbactivity );

		if ( input.hasClass( 'streamInputMessageCollapse' ) ) {
			filterSelector.call( container.find( '.streamItemDisplay:not(.hidden)' ), cbactivity ).addClass( 'hidden' );
		}

		filterSelector.call( container.find( 'input,textarea,select:not(.streamInputSelectInsert)' ), cbactivity ).each( function() {
			var type = $( this ).attr( 'type' );

			if ( ( type == 'checkbox' ) || ( type == 'radio' ) ) {
				if ( ( type == 'radio' ) && ( ( $( this ).siblings( 'input[type="radio"]' ).length + 1 ) == 2 ) && ( $( this ).val() == 0 ) ) {
					$( this ).prop( 'checked', true );
				} else {
					$( this ).prop( 'checked', false );
				}
			} else {
				if ( $( this ).is( 'select' ) ) {
					var value = '';

					if ( ( ! $( this ).children( 'option[value=""]:first' ).length ) && ( ! $( this ).hasClass( 'streamInputTags' ) ) ) {
						value = $( this ).children( 'option[value!=""]:first' ).val();
					}

					if ( typeof $( this ).data( 'cbselect' ) != 'undefined' ) {
						$( this ).cbselect( 'set', value );

						return;
					} else {
						$( this ).val( value );
					}
				} else {
					$( this ).val( '' );
				}
			}

			$( this ).trigger( 'change' );
		});

		input.val( '' );

		filterSelector.call( container.find( '.streamToggleOpen' ), cbactivity ).each( function() {
			streamToggle.call( this, cbactivity );
		});

		filterSelector.call( container.find( '.cbRepeat' ), cbactivity ).cbrepeat( 'reset' );

		if ( isCancel ) {
			cbactivity.element.triggerHandler( 'cbactivity.new.cancel', [cbactivity, element, container] );
		}

		bindContainer.call( container, cbactivity );
	}

	function parseHeaders( cbactivity ) {
		var element = ( this.jquery ? this : $( this ) );
		var headers = element.find( '.streamItemHeaders' );

		if ( ! headers.length ) {
			headers = element.filter( '.streamItemHeaders' );
		}

		if ( ! headers.length ) {
			return [];
		}

		var head = $( 'head' );
		var loadedCSS = [];
		var loadedScripts = [];

		head.find( 'link' ).each( function() {
			var cssUrl = $( this ).attr( 'href' );

			if ( typeof cssUrl != 'undefined' ) {
				loadedCSS.push( cssUrl )
			}
		});

		head.find( 'script' ).each( function() {
			var scriptUrl = $( this ).attr( 'src' );

			if ( typeof scriptUrl != 'undefined' ) {
				loadedScripts.push( scriptUrl )
			}
		});

		headers.children( 'link' ).each( function() {
			var cssUrl = $( this ).attr( 'href' );

			if ( ( typeof cssUrl == 'undefined' ) || ( loadedCSS.indexOf( cssUrl ) !== -1 ) ) {
				$( this ).remove();

				return;
			}

			var stylesheetPosition = $( 'head' ).find( 'link[href*="com_comprofiler"][rel="stylesheet"]' ).last();

			if ( ! stylesheetPosition.length ) {
				// CB isn't loaded so lets just do a temporary usage:
				return;
			}

			// CB is already loaded so lets be sure we insert these after CB:
			var stylesheet = document.createElement( 'link' );

			stylesheet.href = cssUrl;
			stylesheet.rel = 'stylesheet';

			stylesheetPosition[0].after( stylesheet );

			$( this ).remove();
		});

		var loadScripts = [];

		headers.children( 'script' ).each( function() {
			var scriptUrl = $( this ).attr( 'src' );

			if ( typeof scriptUrl == 'undefined' ) {
				loadScripts.push( this );
			} else {
				if ( loadedScripts.indexOf( scriptUrl ) === -1 ) {
					loadScripts.push( this );
				}
			}

			$( this ).remove();
		});

		return loadScripts;
	}

	function parseScripts( cbactivity, loadScripts ) {
		if ( ! loadScripts.length ) {
			return;
		}

		var element = ( this.jquery ? this : $( this ) );
		var scripts = $( '<div class="streamItemHeadersScripts" style="position: absolute; display: none; height: 0; width: 0; z-index: -999;" />' );

		var loadScript = function( i ) {
			var nextScript = ( i + 1 );
			var scriptUrl = $( this ).attr( 'src' );

			if ( scriptUrl ) {
				var scriptPosition = $( 'head' ).find( 'script[src*="com_comprofiler"]' ).last();

				if ( ! scriptPosition.length ) {
					// CB isn't loaded so lets just do a temporary usage:
					$.ajax({
						url: scriptUrl,
						dataType: 'script',
						cache: true
					}).always( function() {
						scripts.append( '<script type="text/javascript" src="' + scriptUrl + '"></script>' );

						if ( typeof loadScripts[nextScript] != 'undefined' ) {
							loadScript.call( loadScripts[nextScript], nextScript );
						}
					});
				} else {
					// CB is already loaded so lets be sure we insert these after CB:
					var script = document.createElement( 'script' );

					script.type = 'text/javascript';
					script.onload = function () {
						if ( typeof loadScripts[nextScript] != 'undefined' ) {
							loadScript.call( loadScripts[nextScript], nextScript );
						}
					};
					script.src = scriptUrl;

					scriptPosition[0].after( script );
				}
			} else {
				scripts.append( '<script type="text/javascript">' + $( this ).text() + '</script>' );

				if ( typeof loadScripts[nextScript] != 'undefined' ) {
					loadScript.call( loadScripts[nextScript], nextScript );
				}
			}
		};

		loadScript.call( loadScripts[0], 0 );

		var headers = element.find( '.streamItemHeaders' );

		if ( ! headers.length ) {
			headers = element.filter( '.streamItemHeaders' );
		}

		headers.append( scripts );
	}

	$.fn.cbactivity = function( options ) {
		if ( methods[options] ) {
			return methods[ options ].apply( this, Array.prototype.slice.call( arguments, 1 ) );
		} else if ( ( typeof options === 'object' ) || ( ! options ) ) {
			return methods.init.apply( this, arguments );
		}

		return this;
	};

	$.fn.cbactivity.loader = {
		autoUpdaterReady: false,
		autoUpdaterAttempts: 0,
		autoUpdaterInterval: 60000,
		autoUpdaterMaxAttempts: 60,
		autoLoaderReady: false,
		autoLoaderAttempts: 0,
		autoLoaderInterval: 2000,
		autoLoaderMaxAttempts: 150
	};

	function autoUpdater() {
		if ( $.fn.cbactivity.loader.autoUpdaterReady ) {
			return;
		}

		$.fn.cbactivity.loader.autoUpdaterReady = true;

		var autoUpdate = function() {
			if ( ! instances.length ) {
				return;
			}

			if ( ! document.hidden ) {
				$.each( instances, function( i, instance ) {
					if ( ( ! instance.settings.autoUpdate ) || ( ! instance.element.length ) ) {
						return false;
					}

					var update = filterSelector.call( instance.element.find( '.streamUpdate,.streamRefresh' ), instance );

					if ( ! update.length ) {
						return false;
					}

					update.click();
				});

				$.fn.cbactivity.loader.autoUpdaterAttempts++;
			}

			if ( ( ! $.fn.cbactivity.loader.autoUpdaterMaxAttempts ) || ( $.fn.cbactivity.loader.autoUpdaterAttempts < $.fn.cbactivity.loader.autoUpdaterMaxAttempts ) ) {
				setTimeout( autoUpdate, $.fn.cbactivity.loader.autoUpdaterInterval );
			} else {
				$.fn.cbactivity.loader.autoUpdaterReady = false;
			}
		};

		if ( ( ! $.fn.cbactivity.loader.autoUpdaterMaxAttempts ) || ( $.fn.cbactivity.loader.autoUpdaterAttempts < $.fn.cbactivity.loader.autoUpdaterMaxAttempts ) ) {
			setTimeout( autoUpdate, $.fn.cbactivity.loader.autoUpdaterInterval );
		}
	}

	function autoLoader() {
		if ( $.fn.cbactivity.loader.autoLoaderReady ) {
			return;
		}

		$.fn.cbactivity.loader.autoLoaderReady = true;

		var autoLoader = function() {
			if ( ! instances.length ) {
				return;
			}

			if ( ! document.hidden ) {
				$.each( instances, function( i, instance ) {
					if ( ( ! instance.settings.autoLoad ) || ( instance.settings.direction == 'up' ) || ( ! instance.element.length ) ) {
						return false;
					}

					var more = filterSelector.call( instance.element.find( '.streamMore' ), instance );

					if ( ! more.length ) {
						return false;
					}

					var top = $( window ).scrollTop();
					var bottom = ( top + $( window ).height() );

					var items = filterSelector.call( instance.element.find( '.streamItem[data-cbactivity-id]' ), instance );
					var item = items.eq( - Math.round( items.length / 3 ) );
					var moreTop = null;
					var moreBottom = null;

					if ( item.length ) {
						moreTop = item.offset().top;
						moreBottom = ( moreTop + item.height() );
					} else {
						moreTop = more.offset().top;
						moreBottom = ( moreTop + more.height() );
					}

					if ( ( top >= moreTop ) || ( bottom >= moreBottom ) ) {
						more.click();
					}
				});

				$.fn.cbactivity.loader.autoLoaderAttempts++;
			}

			if ( ( ! $.fn.cbactivity.loader.autoLoaderMaxAttempts ) || ( $.fn.cbactivity.loader.autoLoaderAttempts < $.fn.cbactivity.loader.autoLoaderMaxAttempts ) ) {
				setTimeout( autoLoader, $.fn.cbactivity.loader.autoLoaderInterval );
			} else {
				$.fn.cbactivity.loader.autoLoaderReady = false;
			}
		};

		if ( ( ! $.fn.cbactivity.loader.autoLoaderMaxAttempts ) || ( $.fn.cbactivity.loader.autoLoaderAttempts < $.fn.cbactivity.loader.autoLoaderMaxAttempts ) ) {
			setTimeout( autoLoader, ( $.fn.cbactivity.loader.autoLoaderInterval * 2 ) );
		}
	}

	$.fn.cbactivity.dataMap = {
		direction: 'cbactivity-direction',
		autoUpdate: 'cbactivity-autoupdate',
		autoLoad: 'cbactivity-autoload'
	};

	$.fn.cbactivity.defaults = {
		init: true,
		useData: true,
		direction: 'down',
		autoUpdate: false,
		autoLoad: false
	};
})(jQuery);