<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJiveEvents\Table\EventTable;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\NotificationsInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveEventActivity
{

	/**
	 * render frontend event activity
	 *
	 * @param ActivityTable|NotificationTable $row
	 * @param null|string                     $title
	 * @param null|string                     $date
	 * @param null|string                     $message
	 * @param null|string                     $insert
	 * @param null|string                     $footer
	 * @param array                           $menu
	 * @param Activity|Notifications          $stream
	 * @param array                           $assetMatches
	 * @param EventTable                      $event
	 * @param cbPluginHandler                 $plugin
	 * @param string                          $output
	 */
	public static function showEventActivity( &$row, &$title, &$date, &$message, &$insert, &$footer, &$menu, $stream, $assetMatches, $event, $plugin, $output )
	{
		global $_CB_framework, $_PLUGINS;

		$type						=	( isset( $assetMatches[3] ) ? $assetMatches[3] : '' );
		$user						=	CBuser::getMyUserDataInstance();
		$groupOwner					=	( $user->getInt( 'id', 0 ) === $event->group()->getInt( 'user_id', 0 ) );

		if ( CBGroupJive::canAccessGroup( $event->group(), $user ) ) {
			$groupName				=	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $event->group()->getInt( 'id', 0 ) ) ) . '">' . htmlspecialchars( CBTxt::T( $event->group()->getString( 'name' ) ) ) . '</a>';
		} else {
			$groupName				=	htmlspecialchars( CBTxt::T( $event->group()->getString( 'name' ) ) );
		}

		$userStatus					=	CBGroupJive::getGroupStatus( $user, $event->group() );
		$canAttend					=	( ( $event->status() !== 1 )
											 && ( ! $event->getInt( '_attending', 0 ) )
											 && ( $user->getInt( 'id', 0 ) && ( ( $event->group()->getInt( 'type', 0 ) === 4 ) || ( $userStatus >= 1 ) ) )
											 && ( ( ! $event->getInt( 'limit', 0 ) ) || ( $event->getInt( 'limit', 0 ) && ( $event->getInt( '_guests', 0 ) < $event->getInt( 'limit', 0 ) ) ) )
										);

		if ( $stream instanceof NotificationsInterface ) {
			if ( CBGroupJive::canAccessGroup( $event->group(), $user ) ) {
				$row->set( 'link', $_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $event->group()->getInt( 'id', 0 ), 'tab' => 'grouptabevents' ) ) );

				$eventName			=	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $event->group()->getInt( 'id', 0 ), 'tab' => 'grouptabevents' ) ) . '">' . htmlspecialchars( $event->getString( 'title' ) ) . '</a>';
			} else {
				$eventName			=	htmlspecialchars( $event->getString( 'title' ) );
			}

			switch ( $type ) {
				case 'event_approve':
					if ( $groupOwner ) {
						$title		=	CBTxt::T( 'EVENT_AWAITING_APPROVAL_IN_YOUR_GROUP', 'event [event] is awaiting approval in your group [group]', array( '[group]' => $groupName, '[event]' => $eventName ) );
					} else {
						$title		=	CBTxt::T( 'EVENT_AWAITING_APPROVAL_IN_GROUP', 'event [event] is awaiting approval in group [group]', array( '[group]' => $groupName, '[event]' => $eventName ) );
					}
					break;
				case 'event_approved':
					if ( $groupOwner ) {
						$title		=	CBTxt::T( 'EVENT_APPROVED_IN_YOUR_GROUP', 'event [event] approved in your group [group]', array( '[group]' => $groupName, '[event]' => $eventName ) );
					} else {
						$title		=	CBTxt::T( 'EVENT_APPROVED_IN_GROUP', 'event [event] approved in group [group]', array( '[group]' => $groupName, '[event]' => $eventName ) );
					}
					break;
				case 'event_edit':
					if ( $groupOwner ) {
						$title		=	CBTxt::T( 'EVENT_EDITED_IN_YOUR_GROUP', 'edited event [event] in your group [group]', array( '[group]' => $groupName, '[event]' => $eventName ) );
					} else {
						$title		=	CBTxt::T( 'EVENT_EDITED_IN_GROUP', 'edited event [event] in group [group]', array( '[group]' => $groupName, '[event]' => $eventName ) );
					}
					break;
				case 'event_attend':
					if ( $groupOwner ) {
						$title		=	CBTxt::T( 'ATTEND_EVENT_IN_YOUR_GROUP', 'attending event [event] in your group [group]', array( '[group]' => $groupName, '[event]' => $eventName ) );
					} else {
						$title		=	CBTxt::T( 'ATTEND_EVENT_IN_GROUP', 'attending event [event] in group [group]', array( '[group]' => $groupName, '[event]' => $eventName ) );
					}
					break;
				case 'event_unattend':
					if ( $groupOwner ) {
						$title		=	CBTxt::T( 'UNATTEND_EVENT_IN_YOUR_GROUP', 'no longer attending event [event] in your group [group]', array( '[group]' => $groupName, '[event]' => $eventName ) );
					} else {
						$title		=	CBTxt::T( 'UNATTEND_EVENT_IN_GROUP', 'no longer attending event [event] in group [group]', array( '[group]' => $groupName, '[event]' => $eventName ) );
					}
					break;
				case 'event_message':
					if ( $groupOwner ) {
						$title		=	CBTxt::T( 'MESSAGE_FROM_EVENT_IN_YOUR_GROUP', 'message from event [event] in your group [group]', array( '[group]' => $groupName, '[event]' => $eventName ) );
					} else {
						$title		=	CBTxt::T( 'MESSAGE_FROM_EVENT_IN_GROUP', 'message from event [event] in group [group]', array( '[group]' => $groupName, '[event]' => $eventName ) );
					}
					break;
				case 'event_new':
				default:
					if ( $groupOwner ) {
						$title		=	CBTxt::T( 'SCHEDULED_EVENT_IN_YOUR_GROUP', 'scheduled event [event] in your group [group]', array( '[group]' => $groupName, '[event]' => $eventName ) );
					} else {
						$title		=	CBTxt::T( 'SCHEDULED_EVENT_IN_GROUP', 'scheduled event [event] in group [group]', array( '[group]' => $groupName, '[event]' => $eventName ) );
					}

					if ( $canAttend ) {
						$returnUrl	=	base64_encode( $_CB_framework->pluginClassUrl( 'cbactivity', false, array( 'action' => 'notifications', 'stream' => $stream->id() ) ) );

						$date		.=	'<div class="notificationsButtonsGJEvent float-right">'
									.		'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'events', 'func' => 'attend', 'id' => $event->getInt( 'id', 0 ), 'return' => $returnUrl ) ) . '" class="notificationsButton notificationsButtonAttendGJEvent btn btn-xs btn-success">' . CBTxt::T( 'Attend Event' ) . '</a>'
									.	'</div>';
					}
					break;
			}
		} else {
			$showAddress			=	$plugin->params->getBool( 'groups_events_address', true );
			$address				=	htmlspecialchars( $event->getString( 'location' ) );
			$returnUrl				=	base64_encode( $_CB_framework->pluginClassUrl( 'cbactivity', false, array( 'action' => 'activity', 'stream' => $stream->id() ) ) );

			switch ( $type ) {
				case 'event_attend':
					if ( $stream->getInt( 'groupjive.ingroup', 0 ) === $event->group()->getInt( 'id', 0 ) ) {
						$title		=	CBTxt::T( 'attending an event' );
					} elseif ( $groupOwner ) {
						$title		=	CBTxt::T( 'ATTENDING_AN_EVENT_IN_YOUR_GROUP', 'attending an event in your group [group]', array( '[group]' => $groupName ) );
					} else {
						$title		=	CBTxt::T( 'ATTENDING_AN_EVENT_IN_GROUP', 'attending an event in group [group]', array( '[group]' => $groupName ) );
					}
					break;
				case 'event_new':
				default:
					if ( $stream->getInt( 'groupjive.ingroup', 0 ) === $event->group()->getInt( 'id', 0 ) ) {
						$title		=	CBTxt::T( 'scheduled an event' );
					} elseif ( $groupOwner ) {
						$title		=	CBTxt::T( 'SCHEDULED_AN_EVENT_IN_YOUR_GROUP', 'scheduled an event in your group [group]', array( '[group]' => $groupName ) );
					} else {
						$title		=	CBTxt::T( 'SCHEDULED_AN_EVENT_IN_GROUP', 'scheduled an event in group [group]', array( '[group]' => $groupName ) );
					}
					break;
			}

			if ( $showAddress ) {
				if ( $event->getString( 'address' ) ) {
					$mapUrl			=	CBTxt::T( 'GROUP_EVENT_ADDRESS_MAP_URL', 'https://www.google.com/maps/place/[address]', array( '[location]' => urlencode( $event->getString( 'location' ) ), '[address]' => urlencode( $event->getString( 'address' ) ) ) );
				} else {
					$mapUrl			=	CBTxt::T( 'GROUP_EVENT_LOCATION_MAP_URL', 'https://www.google.com/maps/search/[location]', array( '[location]' => urlencode( $event->getString( 'location' ) ), '[address]' => urlencode( $event->getString( 'address' ) ) ) );
				}

				if ( $mapUrl ) {
					$address		=	'<a href="' . htmlspecialchars( $mapUrl ) . '" target="_blank" rel="nofollow">' . $address . '</a>';
				}
			}

			$insert					=	'<div class="gjEventActivity">'
									.		'<div class="row no-gutters mb-2 gjGroupEventsRow' . ( $event->status() === 1 ? ' gjGroupEventExpired' : ( $event->status() === 2 ? ' gjGroupEventActive' : null ) ) . '">'
									.			'<div class="col-md-2 d-none d-md-block pr-md-2 gjGroupEventCalendar">'
									.				'<div class="card text-center">'
									.					'<div class="card-body p-1 gjGroupEventMonth">' . cbFormatDate( $event->getString( 'start' ), true, false, 'M' ) . '</div>'
									.					'<div class="card-footer p-1 gjGroupEventDay">' . cbFormatDate( $event->getString( 'start' ), true, false, 'j' ) . '</div>'
									.				'</div>'
									.			'</div>'
									.			'<div class="col-12 col-md-10 gjGroupEventContainer">'
									.				'<div class="card' . ( $event->status() === 1 ? ' border-warning' : ( $event->status() === 2 ? ' border-primary' : null ) ) . '">'
									.					'<div class="card-header p-2 gjGroupEventHeader">'
									.						'<div class="row no-gutters align-items-center">'
									.							'<div class="' . ( $canAttend ? 'col-sm-8' : 'col-12' ) . ' text-large text-center text-sm-left gjGroupEventTitle">' . htmlspecialchars( $event->getString( 'title' ) ) . '</div>';

			if ( $canAttend ) {
				$insert				.=							'<div class="col-sm-4 text-right gjGroupEventMenu">'
									.								'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'events', 'func' => 'attend', 'id' => $event->getInt( 'id', 0 ), 'return' => $returnUrl ) ) . '" class="btn btn-sm btn-success btn-sm-block gjButton gjButtonAttend">' . CBTxt::T( 'Attend Event' ) . '</a>'
									.							'</div>';
			}

			$insert					.=						'</div>'
									.					'</div>'
									.					'<div class="card-body p-2 text-small gjGroupEventDetails">';

			if ( $event->status() === 1 ) {
				$insert				.=						'<div class="text-warning text-sm-right gjGroupEventNotice">' . CBTxt::T( 'This event has ended.' ) . '</div>';
			} elseif ( $event->status() === 2 ) {
				if ( $event->getString( 'end' ) ) {
					$insert			.=						'<div class="text-primary text-sm-right gjGroupEventNotice">' . CBTxt::T( 'GROUP_EVENT_ENDS_IN', 'This event is currently in progress and ends in [timeago].', array( '[timeago]' => cbFormatDate( $event->getString( 'end' ), true, 'exacttimeago' ) ) ) . '</div>';
				} else {
					$insert			.=						'<div class="text-primary text-sm-right gjGroupEventNotice">' . CBTxt::T( 'This event is currently in progress.' ) . '</div>';
				}
			} else {
				$insert				.=						'<div class="text-sm-right gjGroupEventNotice">' . CBTxt::T( 'GROUP_EVENT_STARTS_IN', 'This event starts in [timeago].', array( '[timeago]' => cbFormatDate( $event->getString( 'start' ), true, 'exacttimeago' ) ) ) . '</div>';
			}

			$insert					.=						'<div class="gjGroupEventDate">'
									.							'<span class="fa fa-clock-o text-center gjGroupEventIcon"></span> ' . $event->date()
									.						'</div>'
									.						'<div class="gjGroupEventLocation">'
									.							'<span class="fa fa-map-marker text-center gjGroupEventIcon"></span> ' . $address
									.						'</div>'
									.						'<div class="row no-gutters gjGroupEventAttending">'
									.							'<div class="col-sm-6 gjGroupEventGuests">'
									.								'<span class="fa fa-users text-center gjGroupEventIcon"></span> ';

			if ( CBGroupJive::canAccessGroup( $event->group(), $user ) ) {
				$insert				.=								'<a href="' . htmlspecialchars( $_CB_framework->pluginClassUrl( $plugin->element, false, array( 'action' => 'events', 'func' => 'attending', 'id' =>  $event->getInt( 'id', 0 ), 'return' => $returnUrl ) ) ) . '">'
									.									( $event->getInt( 'limit', 0 ) ? CBTxt::T( 'GROUP_GUESTS_COUNT_LIMITED', '%%COUNT%% of [limit] Guest|%%COUNT%% of [limit] Guests', array( '%%COUNT%%' => $event->getInt( '_guests', 0 ), '[limit]' => $event->getInt( 'limit', 0 ) ) ) : CBTxt::T( 'GROUP_GUESTS_COUNT', '%%COUNT%% Guest|%%COUNT%% Guests', array( '%%COUNT%%' => $event->getInt( '_guests', 0 ) ) ) )
									.								'</a>';
			} else {
				$insert				.=								( $event->getInt( 'limit', 0 ) ? CBTxt::T( 'GROUP_GUESTS_COUNT_LIMITED', '%%COUNT%% of [limit] Guest|%%COUNT%% of [limit] Guests', array( '%%COUNT%%' => $event->getInt( '_guests', 0 ), '[limit]' => $event->getInt( 'limit', 0 ) ) ) : CBTxt::T( 'GROUP_GUESTS_COUNT', '%%COUNT%% Guest|%%COUNT%% Guests', array( '%%COUNT%%' => $event->getInt( '_guests', 0 ) ) ) );
			}

			$insert					.=							'</div>'
									.						'</div>'
									.					'</div>'
									.					'<div class="card-footer p-2 bg-transparent gjGroupEventDescription">'
									.						'<div class="cbMoreLess">'
									.							'<div class="cbMoreLessContent">'
									.								( $plugin->params->getBool( 'groups_events_content_plugins', false ) ? Application::Cms()->prepareHtmlContentPlugins( $event->getHtml( 'event' ), 'groupjive.event', $event->getInt( 'user_id', 0 ) ) : $event->getHtml( 'event' ) )
									.							'</div>'
									.							'<div class="fade-edge cbMoreLessOpen hidden">'
									.								'<a href="javascript: void(0);" class="cbMoreLessButton">' . CBTxt::T( 'See More' ) . '</a>'
									.							'</div>'
									.						'</div>'
									.					'</div>'
									.				'</div>'
									.			'</div>'
									.		'</div>'
									.	'</div>';
		}

		$_PLUGINS->trigger( 'gj_onAfterEventActivity', array( &$row, &$title, &$date, &$message, &$insert, &$footer, &$menu, $stream, $assetMatches, $event, $plugin, $output ) );
	}
}