<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\TemplateChanger\Trigger;

use CB\Database\Table\UserTable;
use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use CBLib\Registry\GetterInterface;

defined('CBLIB') or die();

class UserTrigger extends \cbPluginHandler
{

	/**
	 * @param UserTable $user
	 */
	public function setTemplate( $user )
	{
		global $_CB_framework, $ueConfig;

		$preview							=	Application::Input()->get( 'cbtmplpreview', null, GetterInterface::STRING );

		if ( $preview ) {
			if ( Application::MyUser()->isGlobalModerator() ) {
				$ueConfig['templatedir']	=	$preview;

				return;
			}

			$_CB_framework->enqueueMessage( CBTxt::T( 'Only moderators can preview templates.', 'error' ) );
		}

		if ( $this->params->get( 'templatechanger_user', 0, GetterInterface::INT ) ) {
			$templateUser					=	\CBuser::getMyUserDataInstance();
		} else {
			$templateUser					=	$user;
		}

		$template							=	$templateUser->get( 'template_profile', null, GetterInterface::STRING );

		if ( ! $template ) {
			return;
		}

		$ueConfig['templatedir']			=	$template;
	}
}