<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Database\Table\TabTable;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJiveVideo\CBGroupJiveVideo;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;

$_PLUGINS->loadPluginGroup( 'user' );

class CBplug_cbgroupjivevideo extends cbPluginHandler
{

	/**
	 * @param  TabTable   $tab       Current tab
	 * @param  UserTable  $user      Current user
	 * @param  int        $ui        1 front, 2 admin UI
	 * @param  array      $postdata  Raw unfiltred POST data
	 */
	public function getCBpluginComponent( $tab, $user, $ui, $postdata )
	{
		$format					=	$this->getInput()->getString( 'format' );

		if ( $format !== 'raw' ) {
			outputCbJs();
			outputCbTemplate();
		}

		$action					=	$this->getInput()->getString( 'action' );
		$function				=	$this->getInput()->getString( 'func' );
		$id						=	$this->getInput()->getInt( 'id', 0 );

		if ( $user === null ) {
			$user				=	CBuser::getMyUserDataInstance();
		}

		if ( $format !== 'raw' ) {
			ob_start();
		}

		if ( $action === 'video' ) {
			switch ( $function ) {
				case 'publish':
					$this->stateVideo( 1, $id, $user );
					break;
				case 'unpublish':
					$this->stateVideo( 0, $id, $user );
					break;
				case 'delete':
					$this->deleteVideo( $id, $user );
					break;
				case 'new':
					$this->showVideoEdit( null, $user );
					break;
				case 'edit':
					$this->showVideoEdit( $id, $user );
					break;
				case 'save':
					cbSpoofCheck( 'plugin' );
					$this->saveVideoEdit( $id, $user );
					break;
			}
		}

		if ( $format !== 'raw' ) {
			$html				=	ob_get_clean();

			$gjClass			=	CBGroupJive::getGlobalParams()->getString( 'general_class' );

			$return				=	'<div class="cbGroupJive' . ( $gjClass ? ' ' . htmlspecialchars( $gjClass ) : null ) . '">'
								.		$html
								.	'</div>';

			echo $return;
		}
	}

	/**
	 * prepare frontend video edit render
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function showVideoEdit( $id, $user )
	{
		global $_CB_framework;

		$row							=	CBGroupJiveVideo::getVideo( (int) $id );
		$isModerator					=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$groupId						=	$this->getInput()->getInt( 'group' );

		if ( $groupId === null ) {
			$group						=	$row->group();
		} else {
			$group						=	CBGroupJive::getGroup( $groupId );
		}

		$returnUrl						=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) );

		if ( ! CBGroupJive::canAccessGroup( $group, $user ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		} elseif ( ! $isModerator ) {
			if ( ( ! $row->getInt( 'id', 0 ) ) && ( ! CBGroupJive::canCreateGroupContent( $user, $group, 'video' ) ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to publish a video in this group.' ), 'error' );
			} elseif ( $row->getInt( 'id', 0 )
					   && ( CBGroupJive::getGroupStatus( $user, $group ) < 2 )
					   && ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) )
			) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to edit this video.' ), 'error' );
			}
		}

		CBGroupJive::getTemplate( 'video_edit', true, true, $this->element );

		$input							=	array();

		$publishedTooltip				=	cbTooltip( null, CBTxt::T( 'Select publish state of this video. Unpublished videos will not be visible to the public.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['published']				=	moscomprofilerHTML::yesnoButtonList( 'published', $publishedTooltip, $this->getInput()->getInt( 'post/published', $row->getInt( 'published', 1 ) ) );

		$titleTooltup					=	cbTooltip( null, CBTxt::T( 'Optionally input a video title to display instead of url.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['title']					=	'<input type="text" id="title" name="title" value="' . htmlspecialchars( $this->getInput()->getString( 'post/title', $row->getString( 'title' ) ) ) . '" class="form-control" size="35"' . $titleTooltup . ' />';

		$urlTooltip						=	cbTooltip( null, CBTxt::T( 'Input the URL to the video to publish.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['url']					=	'<input type="text" id="url" name="url" value="' . htmlspecialchars( $this->getInput()->getString( 'post/url', $row->getString( 'url' ) ) ) . '" class="form-control required" size="45"' . $urlTooltip . ' />';

		$input['url_limits']			=	CBTxt::T( 'GROUP_VIDEO_LIMITS_EXT', 'Your url must be of [ext] type.', array( '[ext]' => implode( ', ', array( 'youtube', 'mp4', 'ogv', 'ogg', 'webm', 'm4v' ) ) ) );

		$captionTooltip					=	cbTooltip( null, CBTxt::T( 'Optionally input a video caption.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['caption']				=	'<textarea id="caption" name="caption" class="form-control" cols="40" rows="5"' . $captionTooltip . '>' . htmlspecialchars( $this->getInput()->getString( 'post/caption', $row->getString( 'caption' ) ) ) . '</textarea>';

		$ownerTooltip					=	cbTooltip( null, CBTxt::T( 'Input the video owner id. Video owner determines the creator of the video specified as User ID.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['user_id']				=	'<input type="text" id="user_id" name="user_id" value="' . $this->getInput()->getInt( 'post/user_id', $this->getInput()->getInt( 'user', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) ) ) . '" class="digits required form-control" size="6"' . $ownerTooltip . ' />';

		HTML_groupjiveVideoEdit::showVideoEdit( $row, $input, $group, $user, $this );
	}

	/**
	 * save video
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function saveVideoEdit( $id, $user )
	{
		global $_CB_framework, $_PLUGINS;

		$row					=	CBGroupJiveVideo::getVideo( (int) $id );
		$isModerator			=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$groupId				=	$this->getInput()->getInt( 'group' );

		if ( $groupId === null ) {
			$group				=	$row->group();
		} else {
			$group				=	CBGroupJive::getGroup( $groupId );
		}

		$returnUrl				=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) );

		if ( ! CBGroupJive::canAccessGroup( $group, $user ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		} elseif ( ! $isModerator ) {
			if ( ( ! $row->getInt( 'id', 0 ) ) && ( ! CBGroupJive::canCreateGroupContent( $user, $group, 'video' ) ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to publish a video in this group.' ), 'error' );
			} elseif ( $row->getInt( 'id', 0 )
					   && ( CBGroupJive::getGroupStatus( $user, $group ) < 2 )
					   && ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) )
			) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to edit this video.' ), 'error' );
			}
		}

		if ( $isModerator ) {
			$row->set( 'user_id', $this->getInput()->getInt( 'post/user_id', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) ) );
		} else {
			$row->set( 'user_id', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) );
		}

		$canModerate			=	( CBGroupJive::getGroupStatus( $user, $group ) >= 2 );

		$row->set( 'published', ( $isModerator || $canModerate || ( $row->getInt( 'id', 0 ) && ( $row->getInt( 'published', 0 ) !== -1 ) ) || ( $group->params()->getInt( 'video', 1 ) !== 2 ) ? $this->getInput()->getInt( 'post/published', $row->getInt( 'published', 1 ) ) : -1 ) );
		$row->set( 'group', $group->getInt( 'id', 0 ) );
		$row->set( 'title', $this->getInput()->getString( 'post/title', $row->getString( 'title' ) ) );
		$row->set( 'url', $this->getInput()->getString( 'post/url', $row->getString( 'url' ) ) );
		$row->set( 'caption', $this->getInput()->getString( 'post/caption', $row->getString( 'caption' ) ) );

		if ( ( ! $isModerator ) && $this->params->getInt( 'groups_video_captcha', 0 ) ) {
			$_PLUGINS->loadPluginGroup( 'user' );

			$_PLUGINS->trigger( 'onCheckCaptchaHtmlElements', array() );

			if ( $_PLUGINS->is_errors() ) {
				$row->setError( $_PLUGINS->getErrorMSG() );
			}
		}

		$new					=	( ! $row->getInt( 'id', 0 ) );

		if ( $row->getError() || ( ! $row->check() ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_VIDEO_FAILED_TO_SAVE', 'Video failed to save! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );

			$this->showVideoEdit( $id, $user );
			return;
		}

		if ( $row->getError() || ( ! $row->store() ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_VIDEO_FAILED_TO_SAVE', 'Video failed to save! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );

			$this->showVideoEdit( $id, $user );
			return;
		}

		if ( $new ) {
			$extras				=	array(	'video_id'		=>	$row->getInt( 'id', 0 ),
											'video_title'	=>	htmlspecialchars( ( $row->getString( 'title' ) ? $row->getString( 'title' ) : $row->name() ) ),
											'video_caption'	=>	htmlspecialchars( $row->getString( 'caption' ) ),
											'video_size'	=>	$row->size(),
											'video_type'	=>	$row->mimeType(),
											'video_url'		=>	htmlspecialchars( $row->getString( 'url' ) ),
											'video_date'	=>	cbFormatDate( $row->getString( 'date' ), true, false, CBTxt::T( 'GROUP_VIDEO_DATE_FORMAT', 'M j, Y' ) ),
											'video'			=>	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ), 'tab' => 'grouptabvideo' ) ) . '">' . htmlspecialchars( ( $row->getString( 'title' ) ? $row->getString( 'title' ) : $row->name() ) ) . '</a>' );

			if ( $row->getInt( 'published', 0 ) === 1 ) {
				CBGroupJive::sendNotifications( 'video_new', CBTxt::T( 'New group video' ), CBTxt::T( '[user] has published the video [video] in the group [group]!' ), $row->group(), $row->getInt( 'user_id', 0 ), null, array( $user->getInt( 'id', 0 ) ), 1, $extras );
			} elseif ( ( $row->getInt( 'published', 0 ) === -1 ) && ( $row->group()->params()->getInt( 'video', 1 ) === 2 ) ) {
				CBGroupJive::sendNotifications( 'video_approve', CBTxt::T( 'New group video awaiting approval' ), CBTxt::T( '[user] has published the video [video] in the group [group] and is awaiting approval!' ), $row->group(), $row->getInt( 'user_id', 0 ), null, array( $user->getInt( 'id', 0 ) ), 2, $extras );

				cbRedirect( $returnUrl, CBTxt::T( 'Video published successfully and awaiting approval!' ) );
			}

			cbRedirect( $returnUrl, CBTxt::T( 'Video published successfully!' ) );
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'Video saved successfully!' ) );
		}
	}

	/**
	 * set video publish state status
	 *
	 * @param int       $state
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function stateVideo( $state, $id, $user )
	{
		global $_CB_framework;

		$row				=	CBGroupJiveVideo::getVideo( (int) $id );
		$returnUrl			=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ) ) );

		if ( $row->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $row->group(), $user ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( CBGroupJive::getGroupStatus( $user, $row->group() ) < 2 ) {
					if ( ( $row->getInt( 'published', 0 ) === -1 )
						 && ( $user->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) )
						 && ( $row->group()->params()->getInt( 'video', 1 ) === 2 )
					) {
						cbRedirect( $returnUrl, CBTxt::T( 'Your video is awaiting approval.' ), 'error' );
					} elseif ( ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) ) {
						cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to publish or unpublish this video.' ), 'error' );
					}
				}
			}
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'Video does not exist.' ), 'error' );
		}

		$currentState		=	$row->getInt( 'published', 0 );

		$row->set( 'published', (int) $state );

		if ( $row->getError() || ( ! $row->store() ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_VIDEO_STATE_FAILED_TO_SAVE', 'Video state failed to saved. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( $state && ( $currentState === -1 ) ) {
			$extras			=	array(	'video_id'		=>	$row->getInt( 'id', 0 ),
										'video_title'	=>	htmlspecialchars( ( $row->getString( 'title' ) ? $row->getString( 'title' ) : $row->name() ) ),
										'video_caption'	=>	htmlspecialchars( $row->getString( 'caption' ) ),
										'video_size'	=>	$row->size(),
										'video_type'	=>	$row->mimeType(),
										'video_url'		=>	htmlspecialchars( $row->getString( 'url' ) ),
										'video_date'	=>	cbFormatDate( $row->getString( 'date' ), true, false, CBTxt::T( 'GROUP_VIDEO_DATE_FORMAT', 'M j, Y' ) ),
										'video'			=>	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ), 'tab' => 'grouptabvideo' ) ) . '">' . htmlspecialchars( ( $row->getString( 'title' ) ? $row->getString( 'title' ) : $row->name() ) ) . '</a>' );

			if ( $row->getInt( 'user_id', 0 ) !== $user->getInt( 'id', 0 ) ) {
				CBGroupJive::sendNotification( 'video_approved', 4, $user, $row->getInt( 'user_id', 0 ), CBTxt::T( 'Video publish request accepted' ), CBTxt::T( 'Your video [video] publish request in the group [group] has been accepted!' ), $row->group(), $extras );
			}

			CBGroupJive::sendNotifications( 'video_new', CBTxt::T( 'New group video' ), CBTxt::T( '[user] has published the video [video] in the group [group]!' ), $row->group(), $row->getInt( 'user_id', 0 ), null, array( $user->getInt( 'id', 0 ) ), 1, $extras );
		}

		cbRedirect( $returnUrl, CBTxt::T( 'Video state saved successfully!' ) );
	}

	/**
	 * delete video
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function deleteVideo( $id, $user )
	{
		global $_CB_framework;

		$row			=	CBGroupJiveVideo::getVideo( (int) $id );
		$returnUrl		=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ) ) );

		if ( $row->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $row->group(), $user ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) && ( CBGroupJive::getGroupStatus( $user, $row->group() ) < 2 ) ) {
					cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to delete this video.' ), 'error' );
				}
			}
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'Video does not exist.' ), 'error' );
		}

		if ( ! $row->canDelete() ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_VIDEO_FAILED_TO_DELETE', 'Video failed to delete. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( ! $row->delete() ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_VIDEO_FAILED_TO_DELETE', 'Video failed to delete. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		cbRedirect( $returnUrl, CBTxt::T( 'Video deleted successfully!' ) );
	}
}