<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CB\Database\Table\PluginTable;
use CBLib\Registry\Registry;
use CBLib\Registry\GetterInterface;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\Comments;
use CB\Plugin\Activity\Following;
use CB\Plugin\Activity\Likes;
use CB\Plugin\Activity\CBActivity;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class plgContentcbactivitybot extends JPlugin
{

	/**
	 * Loads and returns cb activity plugin
	 *
	 * @return bool|PluginTable
	 */
	private function loadActivity()
	{
		global $_PLUGINS;

		static $plugin		=	null;

		if ( $plugin === null ) {
			if ( ( ! file_exists( JPATH_SITE . '/libraries/CBLib/CBLib/Core/CBLib.php' ) ) || ( ! file_exists( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' ) ) ) {
				$plugin		=	false;

				return true;
			}

			include_once( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' );

			cbimport( 'cb.html' );
			cbimport( 'language.front' );

			$_PLUGINS->loadPluginGroup( 'user' );

			$plugin			=	$_PLUGINS->getLoadedPlugin( 'user', 'cbactivity' );

			outputCbJs();
			outputCbTemplate();
		}

		return $plugin;
	}

	/**
	 * @param string $context The context of the content being passed to the plugin.
	 * @param mixed  &$row    An object with a "text" property
	 * @param mixed  $params  Additional parameters. See {@see PlgContentContent()}.
	 * @param int    $page    Optional page number. Unused. Defaults to zero.
	 *
	 * @return mixed
	 */
	public function onContentAfterDisplay( $context, &$row, &$params, $page = 0 )
	{
		global $_CB_framework;

		if ( ( $context == 'com_finder.indexer' ) || ( ( ! $this->params->get( 'comments' ) ) && ( ! $this->params->get( 'likes' ) ) ) ) {
			return null;
		}

		$contexts					=	$this->params->get( 'include_context', 'com_content.article' );

		if ( ! $contexts ) {
			$contexts				=	'com_content.article';
		}

		$contexts					=	explode( ',', $contexts );
		$contextAllowed				=	false;

		foreach ( $contexts as $includeContext ) {
			if ( strpos( $context, $includeContext ) !== false ) {
				$contextAllowed		=	true;
			}
		}

		if ( ! $contextAllowed ) {
			return null;
		}

		$categoryId					=	( isset( $row->catid ) ? (int) $row->catid : 0 );
		$articleId					=	( isset( $row->id ) ? (int) $row->id : 0 );
		$authorId					=	( isset( $row->created_by ) ? (int) $row->created_by : 0 );

		$excludeCategories			=	$this->params->get( 'exclude_categories' );

		if ( $excludeCategories ) {
			$excludeCategories		=	explode( ',', $excludeCategories );

			if ( in_array( $categoryId, $excludeCategories ) ) {
				return null;
			}
		}

		$excludeArticles			=	$this->params->get( 'exclude_articles' );

		if ( $excludeArticles ) {
			$excludeArticles		=	explode( ',', $excludeArticles );

			if ( in_array( $articleId, $excludeArticles ) ) {
				return null;
			}
		}

		$excludeAuthors				=	$this->params->get( 'exclude_authors' );

		if ( $excludeAuthors ) {
			$excludeAuthors			=	explode( ',', $excludeAuthors );

			if ( in_array( $authorId, $excludeAuthors ) ) {
				return null;
			}
		}

		$plugin						=	$this->loadActivity();

		if ( ! $plugin ) {
			return null;
		}

		$asset						=	$this->params->get( 'asset' );

		if ( ! $asset ) {
			$asset					=	'article.' . $articleId;
		}

		$asset						=	str_replace( array( '[category_id]', '[article_id]', '[page_id]' ), array( $categoryId, $articleId, (int) $_CB_framework->itemid() ), $asset );
		$return						=	null;

		if ( $this->params->get( 'likes' ) ) {
			$likes					=	new Likes( $asset, $authorId );

			$likes->parse( $this->params->toArray(), 'likes_' );

			$likes->set( 'content.context', $context );
			$likes->set( 'content.article', $articleId );

			if ( CBActivity::canCreate( 'like', $likes ) || $likes->rows() ) {
				if ( $this->params->get( 'likes_layout' ) == 'stream' ) {
					$display		=	$likes->likes();
				} else {
					$display		=	$likes->likes( 'button' );
				}

				$return				.=	'<div class="cbActivityArticleLike">'
									.		$display
									.	'</div>';
			}
		}

		if ( $this->params->get( 'comments' ) ) {
			$comments				=	new Comments( $asset, $authorId );

			$comments->parse( $this->params->toArray(), 'comments_' );

			$comments->set( 'content.context', $context );
			$comments->set( 'content.article', $articleId );

			if ( CBActivity::canCreate( 'comment', $comments ) || $comments->rows() ) {
				$layout				=	$this->params->get( 'comments_layout' );

				if ( in_array( $layout, array( 'button', 'toggle' ) ) ) {
					$display		=	$comments->comments( 'button' );
				} else {
					$display		=	$comments->comments();
				}

				$return				.=	'<div class="auto-overflow' . ( $return ? ' mt-2' : null ) . ( $layout != 'button' ? ' bg-light border-top' : null ) . ' cbActivityArticleComments">'
									.		( $layout != 'button' ? '<div class="m-2 cbActivityArticleCommentsInner">' : null )
									.		$display
									.		( $layout != 'button' ? '</div>' : null )
									.	'</div>';
			}
		}

		if ( ! $return ) {
			return null;
		}

		$return						=	'<div class="cb_template cb_template_' . selectTemplate( 'dir' ) . '">'
									.		$return
									.	'</div>';

		return $return;
	}

	/**
	 * @param string $context The context of the content being passed to the plugin.
	 * @param mixed  &$row    An object with a "text" property
	 * @param mixed  $params  Additional parameters. See {@see PlgContentContent()}.
	 * @param int    $page    Optional page number. Unused. Defaults to zero.
	 *
	 * @return bool
	 */
	public function onContentPrepare( $context, &$row, &$params, $page = 0 )
	{
		if ( ( $context == 'com_finder.indexer' ) || ( ! isset( $row->text ) ) ) {
			return true;
		}

		$ignore			=	$this->params->get( 'ignore_context' );

		if ( $ignore ) {
			$ignore		=	explode( ',', $ignore );

			foreach ( $ignore as $ignoreContext ) {
				if ( strpos( $context, $ignoreContext ) !== false ) {
					return true;
				}
			}
		}

		if ( strpos( $row->text, '[cbactivity:' ) === false ) {
			return true;
		}

		$plugin			=	$this->loadActivity();

		if ( ! $plugin ) {
			return true;
		}

		$row->text		=	$this->substituteText( $row->text, $context, $row, $plugin );

		return true;
	}

	/**
	 * @param string      $text
	 * @param string      $context
	 * @param mixed       $row
	 * @param PluginTable $plugin
	 * @return mixed
	 */
	private function substituteText( $text, $context, $row, $plugin )
	{
		global $_CB_framework;

		$ignore		=	array();
		$ignoreId	=	0;
		$streamId	=	0;

		$text		=	preg_replace_callback( '%\[cbactivity:ignore\](.*?)\[/cbactivity:ignore\]%si', function( array $matches ) use ( &$ignore, &$ignoreId )
							{
								$ignoreId++;

								$ignore[$ignoreId]		=	$matches[1];

								return '[cbactivity:ignored ' . (int) $ignoreId . ']';
							},
							$text );

		$text		=	preg_replace_callback( '%\[cbactivity:(activity|notifications|comments|follow|like)((?: [a-zA-Z_-]+=(?:"|&quot;)(?:(?!&quot;)[^"])+(?:"|&quot;))*) */\]%i', function( array $matches ) use ( $_CB_framework, &$streamId, $context, $row, $plugin )
							{
								$streamId++;

								$params					=	new Registry();

								if ( preg_match_all( '/(?:([a-zA-Z-_]+)=(?:"|&quot;)((?:(?!&quot;)[^"])+)(?:"|&quot;))+/i', $matches[2], $options, PREG_SET_ORDER ) ) {
									foreach( $options as $option ) {
										$k				=	( isset( $option[1] ) ? $option[1] : null );
										$v				=	( isset( $option[2] ) ? $option[2] : null );

										if ( $k ) {
											if ( is_numeric( $v ) ) {
												$v		=	(int) $v;
											} elseif ( strtolower( $v ) === 'true' ) {
												$v		=	true;
											} elseif ( strtolower( $v ) === 'false' ) {
												$v		=	false;
											}

											$params->set( $k, $v );
										}
									}
								}

								$asset					=	$params->getString( 'asset' );
								$articleId				=	0;

								if ( strpos( $context, 'com_content' ) !== false ) {
									$articleId			=	( isset( $row->id ) ? (int) $row->id : 0 );

									if ( $articleId && ( ! $asset ) && ( $matches[1] != 'notifications' ) ) {
										$asset			=	'article.' . $articleId;
									}
								}

								$asset					=	str_replace( array( '[article_id]', '[page_id]' ), array( $articleId, (int) $_CB_framework->itemid() ), $asset );
								$return					=	null;

								if ( $matches[1] == 'activity' ) {
									$activity			=	new Activity( $asset );

									$activity->parse( $params );

									$activity->set( 'content.context', $context );
									$activity->set( 'content.id', $streamId );
									$activity->set( 'content.article', $articleId );

									if ( ( ! CBActivity::canCreate( 'activity', $activity ) ) && ( ! $activity->rows() ) ) {
										return null;
									}

									if ( in_array( $params->getString( 'layout', 'stream' ), array( 'button', 'toggle' ) ) ) {
										$return			=	$activity->activity( 'button' );
									} else {
										$return			=	$activity->activity();
									}

									$return				=	'<div class="cb_template cb_template_' . selectTemplate( 'dir' ) . ' cbActivityContentActivity">'
														.		$return
														.	'</div>';
								} elseif ( $matches[1] == 'notifications' ) {
									$notifications		=	new Notifications( $asset );

									$notifications->parse( $params );

									$notifications->set( 'content.context', $context );
									$notifications->set( 'content.id', $streamId );
									$notifications->set( 'content.article', $articleId );

									$layout				=	$params->getString( 'layout', 'button' );

									switch ( $params->getString( 'state', 'unread' ) ) {
										case 'read':
											if ( in_array( $layout, array( 'button', 'toggle' ) ) ) {
												$notifications->set( 'read', 'read' );
											} else {
												$notifications->set( 'read', 'readonly' );
											}
											break;
										case 'unread':
											if ( in_array( $layout, array( 'button', 'toggle' ) ) ) {
												$notifications->set( 'read', 'unread' );
											} else {
												$notifications->set( 'read', 'unreadonly' );
											}
											break;
										case 'all':
											$notifications->set( 'read', 'status' );
											break;
									}

									if ( in_array( $layout, array( 'button', 'toggle' ) ) ) {
										$return			=	$notifications->notifications( 'button' );
									} else {
										if ( ! $notifications->rows() ) {
											return null;
										}

										$return			=	$notifications->notifications();
									}

									$return				=	'<div class="cb_template cb_template_' . selectTemplate( 'dir' ) . ' cbActivityContentNotifications">'
														.		$return
														.	'</div>';
								} elseif ( $matches[1] == 'comments' ) {
									$comments			=	new Comments( $asset );

									$comments->parse( $params );

									$comments->set( 'content.context', $context );
									$comments->set( 'content.id', $streamId );
									$comments->set( 'content.article', $articleId );

									if ( ( ! CBActivity::canCreate( 'comment', $comments ) ) && ( ! $comments->rows() ) ) {
										return null;
									}

									if ( in_array( $params->getString( 'layout', 'stream' ), array( 'button', 'toggle' ) ) ) {
										$return			=	$comments->comments( 'button' );
									} else {
										$return			=	$comments->comments();
									}

									$return				=	'<div class="cb_template cb_template_' . selectTemplate( 'dir' ) . ' cbActivityContentComments">'
														.		$return
														.	'</div>';
								} elseif ( $matches[1] == 'follow' ) {
									$following			=	new Following( $asset );

									$following->parse( $params );

									$following->set( 'content.context', $context );
									$following->set( 'content.id', $streamId );
									$following->set( 'content.article', $articleId );

									if ( ( ! CBActivity::canCreate( 'follow', $following ) ) && ( ! $following->rows() ) ) {
										return null;
									}

									if ( $params->getString( 'layout', 'button' ) == 'stream' ) {
										$return			=	$following->following();
									} else {
										$return			=	$following->following( 'button' );
									}

									$return				=	'<span class="cb_template cb_template_' . selectTemplate( 'dir' ) . ' cbActivityContentFollow">'
														.		$return
														.	'</span>';
								} elseif ( $matches[1] == 'like' ) {
									$likes				=	new Likes( $asset );

									$likes->parse( $params );

									$likes->set( 'content.context', $context );
									$likes->set( 'content.id', $streamId );
									$likes->set( 'content.article', $articleId );

									if ( ( ! CBActivity::canCreate( 'like', $likes ) ) && ( ! $likes->rows() ) ) {
										return null;
									}

									if ( $params->getString( 'layout', 'button' ) == 'stream' ) {
										$return			=	$likes->likes();
									} else {
										$return			=	$likes->likes( 'button' );
									}

									$return				=	'<span class="cb_template cb_template_' . selectTemplate( 'dir' ) . ' cbActivityContentLike">'
														.		$return
														.	'</span>';
								}

								return $return;
							},
							$text );

		foreach ( $ignore as $id => $ignored ) {
			$text	=	str_replace( '[cbactivity:ignored ' . (int) $id . ']', $ignored, $text );
		}

		return $text;
	}
}