<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2022 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Core\AutoLoader;
use CBLib\Registry\ParamsInterface;
use CBLib\Registry\Registry;
use CB\Database\Table\PluginTable;
use CB\Database\Table\TabTable;
use CB\Database\Table\FieldTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

AutoLoader::registerExactMap( '%^CB/Plugin/Conditional/(.+)%i', __DIR__ . '/library/$1.php' );

function plug_cbconditional_install()
{
	global $_CB_database;

	// Migrate plugin params if they exist and determine if we even need to migrate
	$plugin										=	new PluginTable();

	if ( $plugin->load( array( 'element' => 'cbconditional' ) ) ) {
		$pluginParams							=	new Registry( $plugin->getRaw( 'params' ) );

		if ( $pluginParams->has( 'cond_backend' ) || $pluginParams->has( 'cond_reset' ) || $pluginParams->has( 'cond_debug' ) ) {
			$pluginParams->set( 'conditions_backend', $pluginParams->getInt( 'cond_backend', 0 ) );
			$pluginParams->set( 'conditions_reset', $pluginParams->getInt( 'cond_reset', 1 ) );

			$pluginParams->unsetEntry( 'cond_backend' );
			$pluginParams->unsetEntry( 'cond_reset' );
			$pluginParams->unsetEntry( 'cond_debug' );

			$plugin->set( 'params', $pluginParams->asJson() );

			$plugin->store();
		}
	}

	// Migrate legacy tab conditions
	$migratedTabs								=	array();

	$query										=	'SELECT *'
												.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_tabs' )
												.	"\n WHERE " . $_CB_database->NameQuote( 'params' ) . " LIKE " . $_CB_database->Quote( '%cbconditional_display%' );
	$_CB_database->setQuery( $query );
	$tabs										=	$_CB_database->loadObjectList( null, '\CB\Database\Table\TabTable', array( $_CB_database ) );

	/** @var TabTable[] $tabs */
	foreach ( $tabs as $tab ) {
		$tabParams								=	new Registry( $tab->getRaw( 'params' ) );
		$tabParamsOld							=	$tabParams->asJson();

		$tabCondition							=	0;
		$tabConditions							=	array();

		for ( $i = 1; $i <= 5; $i++ ) {
			$conditional						=	( $i > 1 ? $i : null );
			$display							=	$tabParams->getInt( 'cbconditional_display' . $conditional, 0 );

			if ( ! $display ) {
				plug_cbconditional_remove_params( $tabParams, $conditional );

				continue;
			}

			$mode								=	( $tabParams->getInt( 'cbconditional_mode' . $conditional, 0 ) ? 1 : 2 );

			if ( ! $tabCondition ) {
				$tabCondition					=	$mode;
			}

			$conditionField						=	$tabParams->getString( 'cbconditional_field' . $conditional );

			if ( in_array( $conditionField, array( 'customviewaccesslevels', 'customusergroups' ), true ) ) {
				$operator						=	0;
			} else {
				$operator						=	$tabParams->getInt( 'cbconditional_operator' . $conditional, 0 );
			}

			if ( $tabCondition !== $mode ) {
				$operator						=	plug_cbconditional_invert_operator( $operator );
			}

			$tabConditions[]					=	array(	'field'						=>	$conditionField,
															'field_custom'				=>	$tabParams->getRaw( 'cbconditional_customvalue' . $conditional ),
															'field_custom_translate'	=>	$tabParams->getInt( 'cbconditional_customvalue_translate' . $conditional, 0 ),
															'field_viewaccesslevels'	=>	$tabParams->getString( 'cbconditional_customviewaccesslevels' . $conditional ),
															'field_usergroups'			=>	$tabParams->getString( 'cbconditional_customusergroups' . $conditional ),
															'operator_viewaccesslevels'	=>	( in_array( $operator, array( 0, 1 ), true ) ? $operator : 0 ),
															'operator_usergroups'		=>	( in_array( $operator, array( 0, 1 ), true ) ? $operator : 0 ),
															'operator'					=>	$operator,
															'value'						=>	$tabParams->getRaw( 'cbconditional_value' . $conditional ),
															'value_translate'			=>	$tabParams->getInt( 'cbconditional_value_translate' . $conditional, 0 ),
															'locations'					=>	plug_cbconditional_migrate_location( $tabParams, $conditional )
														);

			plug_cbconditional_remove_params( $tabParams, $conditional );
		}

		if ( $tabConditions ) {
			$tabParams->set( 'cbconditional_conditioned', $tabCondition );

			$tabParams->set( 'cbconditional_conditions', array( array( 'condition' => $tabConditions ) ) );

			$tabParams->set( 'cbconditional_debug', '-1' );
		}

		if ( $tabParamsOld !== $tabParams->asJson() ) {
			$tab->set( 'params', $tabParams->asJson() );

			$tab->store();

			$migratedTabs[]						=	$tab->getInt( 'tabid', 0 );
		}
	}

	// Migrate legacy field conditions:
	$migratedFields								=	array();

	$query										=	'SELECT *'
												.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_fields' )
												.	"\n WHERE " . $_CB_database->NameQuote( 'params' ) . " LIKE " . $_CB_database->Quote( '%cbconditional_display%' );
	$_CB_database->setQuery( $query );
	$fields										=	$_CB_database->loadObjectList( null, '\CB\Database\Table\FieldTable', array( $_CB_database ) );

	$fieldOthers								=	array();

	/** @var FieldTable[] $fields */
	foreach ( $fields as $field ) {
		$fieldParams							=	new Registry( $field->getRaw( 'params' ) );
		$fieldParamsOld							=	$fieldParams->asJson();

		$fieldCondition							=	0;
		$fieldConditions						=	array();

		for ( $i = 1; $i <= 5; $i++ ) {
			$conditional						=	( $i > 1 ? $i : null );
			$display							=	$fieldParams->getInt( 'cbconditional_display' . $conditional, 0 );

			if ( ! $display ) {
				plug_cbconditional_remove_params( $fieldParams, $conditional );

				continue;
			}

			if ( $display === 1 ) {
				$fieldsShow						=	explode( '|*|', $fieldParams->getString( 'cbconditional_show' . $conditional ) );

				foreach ( $fieldsShow as $fieldId ) {
					$fieldOthers[$fieldId][]	=	array(	'mode'						=>	1,
															'field'						=>	$field->getInt( 'fieldid', 0 ) . ',' . $field->getString( 'name' ),
															'field_custom'				=>	$fieldParams->getRaw( 'cbconditional_customvalue' . $conditional ),
															'field_custom_translate'	=>	$fieldParams->getInt( 'cbconditional_customvalue_translate' . $conditional, 0 ),
															'field_viewaccesslevels'	=>	$fieldParams->getString( 'cbconditional_customviewaccesslevels' . $conditional ),
															'field_usergroups'			=>	$fieldParams->getString( 'cbconditional_customusergroups' . $conditional ),
															'operator_viewaccesslevels'	=>	0,
															'operator_usergroups'		=>	0,
															'operator'					=>	$fieldParams->getInt( 'cbconditional_operator' . $conditional, 0 ),
															'value'						=>	$fieldParams->getRaw( 'cbconditional_value' . $conditional ),
															'value_translate'			=>	$fieldParams->getInt( 'cbconditional_value_translate' . $conditional, 0 ),
															'locations'					=>	plug_cbconditional_migrate_location( $fieldParams, $conditional )
														);
				}

				$fieldsHide						=	explode( '|*|', $fieldParams->getString( 'cbconditional_hide' . $conditional ) );

				foreach ( $fieldsHide as $fieldId ) {
					$fieldOthers[$fieldId][]	=	array(	'mode'						=>	2,
															'field'						=>	$field->getInt( 'fieldid', 0 ) . ',' . $field->getString( 'name' ),
															'field_custom'				=>	$fieldParams->getRaw( 'cbconditional_customvalue' . $conditional ),
															'field_custom_translate'	=>	$fieldParams->getInt( 'cbconditional_customvalue_translate' . $conditional, 0 ),
															'field_viewaccesslevels'	=>	$fieldParams->getString( 'cbconditional_customviewaccesslevels' . $conditional ),
															'field_usergroups'			=>	$fieldParams->getString( 'cbconditional_customusergroups' . $conditional ),
															'operator_viewaccesslevels'	=>	0,
															'operator_usergroups'		=>	0,
															'operator'					=>	$fieldParams->getInt( 'cbconditional_operator' . $conditional, 0 ),
															'value'						=>	$fieldParams->getRaw( 'cbconditional_value' . $conditional ),
															'value_translate'			=>	$fieldParams->getInt( 'cbconditional_value_translate' . $conditional, 0 ),
															'locations'					=>	plug_cbconditional_migrate_location( $fieldParams, $conditional )
														);
				}
			} else {
				$mode							=	( $fieldParams->getInt( 'cbconditional_mode' . $conditional, 0 ) ? 1 : 2 );

				if ( ! $fieldCondition ) {
					$fieldCondition				=	$mode;
				}

				$conditionField					=	$fieldParams->getString( 'cbconditional_field' . $conditional );

				if ( in_array( $conditionField, array( 'customviewaccesslevels', 'customusergroups' ), true ) ) {
					$operator					=	0;
				} else {
					$operator					=	$fieldParams->getInt( 'cbconditional_operator' . $conditional, 0 );
				}

				if ( $fieldCondition !== $mode ) {
					$operator					=	plug_cbconditional_invert_operator( $operator );
				}

				$fieldConditions[]				=	array(	'field'						=>	$conditionField,
															'field_custom'				=>	$fieldParams->getRaw( 'cbconditional_customvalue' . $conditional ),
															'field_custom_translate'	=>	$fieldParams->getInt( 'cbconditional_customvalue_translate' . $conditional, 0 ),
															'field_viewaccesslevels'	=>	$fieldParams->getString( 'cbconditional_customviewaccesslevels' . $conditional ),
															'field_usergroups'			=>	$fieldParams->getString( 'cbconditional_customusergroups' . $conditional ),
															'operator_viewaccesslevels'	=>	( in_array( $operator, array( 0, 1 ), true ) ? $operator : 0 ),
															'operator_usergroups'		=>	( in_array( $operator, array( 0, 1 ), true ) ? $operator : 0 ),
															'operator'					=>	$operator,
															'value'						=>	$fieldParams->getRaw( 'cbconditional_value' . $conditional ),
															'value_translate'			=>	$fieldParams->getInt( 'cbconditional_value_translate' . $conditional, 0 ),
															'locations'					=>	plug_cbconditional_migrate_location( $fieldParams, $conditional )
														);
			}

			plug_cbconditional_remove_params( $fieldParams, $conditional );
		}

		if ( $fieldConditions ) {
			$fieldParams->set( 'cbconditional_conditioned', $fieldCondition );

			$fieldParams->set( 'cbconditional_conditions', array( array( 'condition' => $fieldConditions ) ) );

			$fieldParams->set( 'cbconditional_debug', '-1' );
		}

		if ( $fieldParamsOld !== $fieldParams->asJson() ) {
			$field->set( 'params', $fieldParams->asJson() );

			$field->store();

			$migratedFields[]					=	$field->getInt( 'fieldid', 0 );
		}
	}

	// Migration field conditional others:
	foreach ( $fieldOthers as $fieldId => $conditions ) {
		$field									=	new FieldTable();

		$field->load( $fieldId );

		if ( ! $field->getInt( 'fieldid', 0 ) ) {
			continue;
		}

		$fieldParams							=	new Registry( $field->getRaw( 'params' ) );
		$fieldParamsOld							=	$fieldParams->asJson();

		$fieldCondition							=	$fieldParams->getInt( 'cbconditional_conditioned', 0 );
		$fieldConditions						=	array();

		foreach ( $conditions as $condition ) {
			$mode								=	$condition['mode'];

			if ( ! $fieldCondition ) {
				$fieldCondition					=	$mode;
			}

			$conditionField						=	$condition['field'];

			if ( $conditionField === 'customviewaccesslevels' ) {
				$operator						=	$condition['operator_viewaccesslevels'];
			} elseif ( $conditionField === 'customusergroups' ) {
				$operator						=	$condition['operator_usergroups'];
			} else {
				$operator						=	$condition['operator'];
			}

			if ( $fieldCondition !== $mode ) {
				$operator						=	plug_cbconditional_invert_operator( $operator );
			}

			$fieldConditions[]					=	array(	'field'						=>	$condition['field'],
															'field_custom'				=>	$condition['field_custom'],
															'field_custom_translate'	=>	$condition['field_custom_translate'],
															'field_viewaccesslevels'	=>	$condition['field_viewaccesslevels'],
															'field_usergroups'			=>	$condition['field_usergroups'],
															'operator_viewaccesslevels'	=>	( in_array( $operator, array( 0, 1 ), true ) ? $operator : 0 ),
															'operator_usergroups'		=>	( in_array( $operator, array( 0, 1 ), true ) ? $operator : 0 ),
															'operator'					=>	$operator,
															'value'						=>	$condition['value'],
															'value_translate'			=>	$condition['value_translate'],
															'locations'					=>	plug_cbconditional_migrate_location( $condition )
														);
		}

		if ( $fieldConditions ) {
			$fieldParams->set( 'cbconditional_conditioned', $fieldCondition );

			// We need to add the conditional others usages as OR cases to existing conditions:
			$existingConditions					=	$fieldParams->subTree( 'cbconditional_conditions' )->asArray();

			foreach ( $fieldConditions as $newCondition ) {
				$existingConditions[]			=	array( 'condition' => array( $newCondition ) );
			}

			$fieldParams->set( 'cbconditional_conditions', $existingConditions );

			$fieldParams->set( 'cbconditional_debug', '-1' );
		}

		if ( $fieldParamsOld !== $fieldParams->asJson() ) {
			$field->set( 'params', $fieldParams->asJson() );

			$field->store();

			$migratedFields[]					=	$field->getInt( 'fieldid', 0 );
		}
	}

	$customConditionTypes						=	array(	'customvalue', 'customviewaccesslevels', 'customusergroups', 'customlanguages',
															'custommoderators', 'customusers', 'customconnections', 'customcode', 'customquery', 'customsubscriptions' );
	$fieldNameMap								=	array();

	// Migrate old tab condition params:
	$query										=	'SELECT *'
												.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_tabs' );
	if ( $migratedTabs ) {
		$query									.=	"\n WHERE " . $_CB_database->NameQuote( 'tabid' ) . " NOT IN " . $_CB_database->safeArrayOfIntegers( $migratedTabs )
												.	"\n AND " . $_CB_database->NameQuote( 'params' ) . " LIKE " . $_CB_database->Quote( '%cbconditional_conditioned%' );
	} else {
		$query									.=	"\n WHERE " . $_CB_database->NameQuote( 'params' ) . " LIKE " . $_CB_database->Quote( '%cbconditional_conditioned%' );
	}
	$_CB_database->setQuery( $query );
	$tabs										=	$_CB_database->loadObjectList( null, '\CB\Database\Table\TabTable', array( $_CB_database ) );

	if ( $tabs ) {
		$query									=	"SELECT " . $_CB_database->NameQuote( 'fieldid' )
												.	", " . $_CB_database->NameQuote( 'name' )
												.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_fields' );
		$_CB_database->setQuery( $query );
		$fieldNameMap							=	$_CB_database->loadAssocList( 'name', 'fieldid' );
	}

	/** @var TabTable[] $tabs */
	foreach ( $tabs as $tab ) {
		$tabParams								=	new Registry( $tab->getRaw( 'params' ) );
		$tabParamsOld							=	$tabParams->asJson();

		$tabConditions							=	$tabParams->subTree( 'cbconditional_conditions' );

		foreach ( $tabConditions as $orIndex => $orCondition ) {
			/** @var ParamsInterface $orCondition */
			$tabAndConditions					=	$orCondition->subTree( 'condition' );

			foreach ( $tabAndConditions as $andIndex => $andCondition ) {
				/** @var ParamsInterface $andCondition */
				if ( ! $andCondition->has( 'locations' ) ) {
					$andCondition->set( 'locations', plug_cbconditional_migrate_location( $andCondition ) );
				}

				$conditionField					=	$andCondition->getString( 'field' );

				if ( $conditionField && ( ! in_array( $conditionField, $customConditionTypes, true ) ) && ( ! is_numeric( $conditionField ) ) ) {
					$andCondition->set( 'field', ( isset( $fieldNameMap[$conditionField] ) ? (string) $fieldNameMap[$conditionField] : '' ) );
				}

				plug_cbconditional_remove_params( $andCondition );

				$tabAndConditions->set( $andIndex, $andCondition->asArray() );
			}

			$tabConditions->set( $orIndex, array( 'condition' => $tabAndConditions->asArray() ) );
		}

		$tabParams->set( 'cbconditional_conditions', $tabConditions->asArray() );

		if ( $tabParamsOld !== $tabParams->asJson() ) {
			$tab->set( 'params', $tabParams->asJson() );

			$tab->store();
		}
	}

	// Migrate old field condition params:
	$query										=	'SELECT *'
												.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_fields' );
	if ( $migratedFields ) {
		$query									.=	"\n WHERE " . $_CB_database->NameQuote( 'fieldid' ) . " NOT IN " . $_CB_database->safeArrayOfIntegers( $migratedFields )
												.	"\n AND " . $_CB_database->NameQuote( 'params' ) . " LIKE " . $_CB_database->Quote( '%cbconditional_conditioned%' );
	} else {
		$query									.=	"\n WHERE " . $_CB_database->NameQuote( 'params' ) . " LIKE " . $_CB_database->Quote( '%cbconditional_conditioned%' );
	}
	$_CB_database->setQuery( $query );
	$fields										=	$_CB_database->loadObjectList( null, '\CB\Database\Table\FieldTable', array( $_CB_database ) );

	/** @var FieldTable[] $fields */
	foreach ( $fields as $field ) {
		$fieldParams							=	new Registry( $field->getRaw( 'params' ) );
		$fieldParamsOld							=	$fieldParams->asJson();

		$fieldConditions						=	$fieldParams->subTree( 'cbconditional_conditions' );

		foreach ( $fieldConditions as $orIndex => $orCondition ) {
			/** @var ParamsInterface $orCondition */
			$fieldAndConditions					=	$orCondition->subTree( 'condition' );

			foreach ( $fieldAndConditions as $andIndex => $andCondition ) {
				/** @var ParamsInterface $andCondition */
				if ( ! $andCondition->has( 'locations' ) ) {
					$andCondition->set( 'locations', plug_cbconditional_migrate_location( $andCondition ) );
				}

				$conditionField					=	$andCondition->getString( 'field' );

				if ( $conditionField && ( ! in_array( $conditionField, $customConditionTypes, true ) ) && ( ! is_numeric( $conditionField ) ) ) {
					$conditionFieldPair			=	explode( ',', $conditionField );

					if ( count( $conditionFieldPair ) < 2 ) {
						array_unshift( $conditionFieldPair, 0 );
					}

					$conditionFieldId			=	(int) array_shift( $conditionFieldPair );

					$andCondition->set( 'field', ( $conditionFieldId ? (string) $conditionFieldId : '' ) );
				}

				plug_cbconditional_remove_params( $andCondition );

				$fieldAndConditions->set( $andIndex, $andCondition->asArray() );
			}

			$fieldConditions->set( $orIndex, array( 'condition' => $fieldAndConditions->asArray() ) );
		}

		$fieldParams->set( 'cbconditional_conditions', $fieldConditions->asArray() );

		if ( $fieldParamsOld !== $fieldParams->asJson() ) {
			$field->set( 'params', $fieldParams->asJson() );

			$field->store();
		}
	}
}

/**
 * @param array|ParamsInterface $object
 * @param null|int              $index
 * @return string
 */
function plug_cbconditional_migrate_location( $object, $index = null )
{
	$locations						=	array();

	if ( $object instanceof Registry ) {
		if ( $index === null ) {
			if ( $object->getInt( 'location_registration' ) ) {
				$locations[]	=	'register';
			}

			if ( $object->getInt( 'location_profile_edit' ) ) {
				$locations[]	=	'edit';
			}

			if ( $object->getInt( 'location_profile_view' ) ) {
				$locations[]	=	'profile';
			}

			if ( $object->getInt( 'location_userlist_search' ) ) {
				$locations[]	=	'search';
			}

			if ( $object->getInt( 'location_userlist_view' ) ) {
				$locations[]	=	'list';
			}
		} else {
			if ( $object->getInt( 'cbconditional_target_reg' . $index, 1 ) ) {
				$locations[]	=	'register';
			}

			if ( $object->getInt( 'cbconditional_target_edit' . $index, 1 ) ) {
				$locations[]	=	'edit';
			}

			if ( $object->getInt( 'cbconditional_target_view' . $index, 1 ) ) {
				$locations[]	=	'profile';
			}

			if ( $object->getInt( 'cbconditional_target_search' . $index, 0 ) ) {
				$locations[]	=	'search';
			}

			if ( $object->getInt( 'cbconditional_target_list' . $index, 1 ) ) {
				$locations[]	=	'list';
			}
		}
	} else {
		if ( $object['location_reg'] ) {
			$locations[]		=	'register';
		}

		if ( $object['location_edit'] ) {
			$locations[]		=	'edit';
		}

		if ( $object['location_view'] ) {
			$locations[]		=	'profile';
		}

		if ( $object['location_search'] ) {
			$locations[]		=	'search';
		}

		if ( $object['location_list'] ) {
			$locations[]		=	'list';
		}
	}

	return implode( '|*|', $locations );
}

/**
 * @param int $operator
 * @return int
 */
function plug_cbconditional_invert_operator( $operator )
{
	switch ( $operator ) {
		case 1:
			$operator	=	0;
			break;
		case 2:
			$operator	=	3;
			break;
		case 3:
			$operator	=	2;
			break;
		case 4:
			$operator	=	5;
			break;
		case 5:
			$operator	=	4;
			break;
		case 6:
			$operator	=	7;
			break;
		case 7:
			$operator	=	6;
			break;
		case 8:
			$operator	=	9;
			break;
		case 9:
			$operator	=	8;
			break;
		case 10:
			$operator	=	11;
			break;
		case 11:
			$operator	=	10;
			break;
		case 0:
		default:
			$operator	=	1;
			break;
	}

	return $operator;
}

/**
 * @param Registry $oldParams
 * @param int      $index
 */
function plug_cbconditional_remove_params( &$oldParams, $index = null )
{
	if ( $index === null ) {
		$oldParams->unsetEntry( 'location_registration' );
		$oldParams->unsetEntry( 'location_profile_edit' );
		$oldParams->unsetEntry( 'location_profile_view' );
		$oldParams->unsetEntry( 'location_registration' );
		$oldParams->unsetEntry( 'location_userlist_search' );
		$oldParams->unsetEntry( 'location_userlist_view' );
	} else {
		$oldParams->unsetEntry( 'cbconditional_display' . $index );
		$oldParams->unsetEntry( 'cbconditional_field' . $index );
		$oldParams->unsetEntry( 'cbconditional_customvalue' . $index );
		$oldParams->unsetEntry( 'cbconditional_customvalue_translate' . $index );
		$oldParams->unsetEntry( 'cbconditional_customviewaccesslevels' . $index );
		$oldParams->unsetEntry( 'cbconditional_customusergroups' . $index );
		$oldParams->unsetEntry( 'cbconditional_operator' . $index );
		$oldParams->unsetEntry( 'cbconditional_value' . $index );
		$oldParams->unsetEntry( 'cbconditional_value_translate' . $index );
		$oldParams->unsetEntry( 'cbconditional_show' . $index );
		$oldParams->unsetEntry( 'cbconditional_hide' . $index );
		$oldParams->unsetEntry( 'cbconditional_options_show' . $index );
		$oldParams->unsetEntry( 'cbconditional_options_hide' . $index );
		$oldParams->unsetEntry( 'cbconditional_mode' . $index );
		$oldParams->unsetEntry( 'cbconditional_target_reg' . $index );
		$oldParams->unsetEntry( 'cbconditional_target_edit' . $index );
		$oldParams->unsetEntry( 'cbconditional_target_view' . $index );
		$oldParams->unsetEntry( 'cbconditional_target_search' . $index );
		$oldParams->unsetEntry( 'cbconditional_target_list' . $index );
	}
}