(function($) {
	var instances = [];
	var cache = {};
	var methods = {
		init: function( options ) {
			return this.each( function () {
				var $this = this;
				var cbcodeautocomplete = $( $this ).data( 'cbcodeautocomplete' );

				if ( cbcodeautocomplete ) {
					return; // cbcodeautocomplete is already bound; so no need to rebind below
				}

				cbcodeautocomplete = {};
				cbcodeautocomplete.options = options;
				cbcodeautocomplete.defaults = $.fn.cbcodeautocomplete.defaults;
				cbcodeautocomplete.settings = $.extend( true, {}, cbcodeautocomplete.defaults, cbcodeautocomplete.options );
				cbcodeautocomplete.element = $( $this );

				if ( cbcodeautocomplete.settings.useData ) {
					$.each( cbcodeautocomplete.defaults, function( key, value ) {
						if ( ( key != 'init' ) && ( key != 'useData' ) ) {
							// Dash Separated:
							var dataValue = cbcodeautocomplete.element.data( 'cbcodeautocomplete' + key.charAt( 0 ).toUpperCase() + key.slice( 1 ) );

							if ( typeof dataValue != 'undefined' ) {
								cbcodeautocomplete.settings[key] = dataValue;
							} else {
								// No Separater:
								dataValue = cbcodeautocomplete.element.data( 'cbcodeautocomplete' + key.charAt( 0 ).toUpperCase() + key.slice( 1 ).toLowerCase() );

								if ( typeof dataValue != 'undefined' ) {
									cbcodeautocomplete.settings[key] = dataValue;
								}
							}
						}
					});
				}

				cbcodeautocomplete.element.trigger( 'cbcodeautocomplete.init.before', [cbcodeautocomplete] );

				if ( ! cbcodeautocomplete.settings.init ) {
					return;
				}

				if ( ( cbcodeautocomplete.settings.fields === null ) || ( ! $.isArray( cbcodeautocomplete.settings.fields ) ) ) {
					cbcodeautocomplete.settings.fields = [];
				}

				cbcodeautocomplete.repeat = cbcodeautocomplete.element.closest( '.cbRepeatRow' ).length;

				var target = findTarget.call( cbcodeautocomplete.element );
				var targetName = target.attr( 'name' );

				cache[targetName] = {};

				target.autocomplete({
					appendTo: cbcodeautocomplete.element,
					classes: {
						'ui-autocomplete': 'm-0 p-0 list-unstyled bg-white border border-top-0 rounded-top-0 rounded-bottom auto-overflow cbCodeAutoCompleteResults'
					},
					minLength: cbcodeautocomplete.settings.length,
					change: function( event, ui ) {
						if ( ! cbcodeautocomplete.settings.strict )  {
							return;
						}

						if ( ui.item == null ) {
							var currentData = target.data( 'cbcodefield-source' );
							var currentMatched = false;

							if ( currentData ) {
								var currentValue = target.val();

								if ( currentValue ) {
									$.each( currentData, function( key, value ) {
										if ( currentValue == value.value ) {
											currentMatched = true;
											return false;
										} else if ( currentValue == value.label ) {
											currentMatched = true;

											target.val( value.value );

											return false;
										}
									});
								}
							}

							if ( ! currentMatched ) {
								target.val( '' ).focus();
							}
						}
					},
					source: function( request, response ) {
						var term = request.term;

						if ( term in cache[targetName] ) {
							response( cache[targetName][term] );
							return;
						}

						if ( cbcodeautocomplete.element.hasClass( 'cbCodeAutoCompleteRequesting' ) ) {
							response();
							return;
						}

						var post = { value: term };

						if ( cbcodeautocomplete.repeat ) {
							post['field'] = target.attr( 'name' );
						}

						if ( cbcodeautocomplete.settings.fields ) {
							$.each( cbcodeautocomplete.settings.fields, function( index, fieldId ) {
								var fieldTarget = null;

								if ( cbcodeautocomplete.repeat ) {
									fieldTarget = findTarget.call( cbcodeautocomplete.element.closest( '.cbRepeatRow' ).find( fieldId ) );

									if ( ! fieldTarget.length ) {
										fieldTarget = findTarget.call( $( fieldId ) );
									}
								} else {
									fieldTarget = findTarget.call( $( fieldId ) );
								}

								if ( ! fieldTarget.length ) {
									return true;
								}

								var fieldName = fieldTarget.attr( 'name' );

								if ( cbcodeautocomplete.repeat ) {
									fieldName = fieldName.replace( /^.+__\d+__/g, '' );
								}

								if ( fieldName == targetName ) {
									return true;
								}

								if ( fieldName.length ) {
									post[fieldName] = getValue.call( fieldTarget );
								}
							});
						}

						cbcodeautocomplete.element.addClass( 'cbCodeAutoCompleteRequesting' );

						$.ajax({
							url: cbcodeautocomplete.settings.url,
							type: 'POST',
							dataType: 'json',
							data: post,
							converters: {
								'text json': function( result ) {
									try {
										return JSON.parse( result );
									} catch( e ) {
										return null;
									}
								}
							}
						}).done( function( data ) {
							cache[targetName][term] = data;

							target.data( 'cbcodefield-source', data );

							response( data );
						}).fail( function() {
							response();
						}).always( function() {
							cbcodeautocomplete.element.removeClass( 'cbCodeAutoCompleteRequesting' );
						});
					}
				}).autocomplete( 'widget' ).css({
					fontFamily: 'inherit',
					fontSize: 'inherit',
					maxHeight: cbcodeautocomplete.settings.height
				}).menu( 'option', {
					classes: {
						'ui-menu-item': 'cbCodeAutoCompleteResult',
						'ui-menu-item-wrapper': 'm-0 p-2 bg-none border-0 text-inherit cbCodeAutoCompleteOption'
					},
					blur: function( event, ui ) {
						ui.item.removeClass( 'bg-primary cbCodeAutoCompleteActive' );
						ui.item.children( '.ui-menu-item-wrapper' ).removeClass( 'text-white' );
					},
					focus: function( event, ui ) {
						ui.item.addClass( 'bg-primary cbCodeAutoCompleteActive' );
						ui.item.children( '.ui-menu-item-wrapper' ).addClass( 'text-white' );
					}
				});

				// Destroy the cbcodeautocomplete element:
				cbcodeautocomplete.element.on( 'remove.cbcodeautocomplete destroy.cbcodeautocomplete', function() {
					cbcodeautocomplete.element.cbcodeautocomplete( 'destroy' );
				});

				// Rebind the cbcodeautocomplete element to pick up any data attribute modifications:
				cbcodeautocomplete.element.on( 'rebind.cbcodeautocomplete', function() {
					cbcodeautocomplete.element.cbcodeautocomplete( 'rebind' );
				});

				// If the cbcodeautocomplete element is modified we need to rebuild it to ensure all our bindings are still ok:
				cbcodeautocomplete.element.on( 'modified.cbcodeautocomplete', function( e, oldId, newId, index ) {
					if ( oldId != newId ) {
						var urlAttr = cbcodeautocomplete.element.attr( 'data-cbcodeautocomplete-url' );

						if ( typeof urlAttr != 'undefined' ) {
							cbcodeautocomplete.element.attr( 'data-cbcodeautocomplete-url', urlAttr.replace( oldId, newId ) );
						}

						var urlData = cbcodeautocomplete.element.data( 'cbcodeautocomplete-url' );

						if ( typeof urlData != 'undefined' ) {
							cbcodeautocomplete.element.data( 'cbcodeautocomplete-url', urlData.replace( oldId, newId ) );
						}

						cbcodeautocomplete.element.cbajaxfield( 'rebind' );
					}
				});

				// If the cbajaxfield is cloned we need to rebind it back:
				cbcodeautocomplete.element.on( 'cloned.cbcodeautocomplete', function() {
					$( this ).off( '.cbcodeautocomplete' );
					$( this ).removeData( 'cbcodeautocomplete' );
					$( this ).children( '.ui-autocomplete' ).remove();

					var target = findTarget.call( this );

					target.removeClass( 'ui-autocomplete-input' );
					target.removeAttr( 'autocomplete' );
					target.off( target.data( 'ui-autocomplete' ).eventNamespace );
					target.off( target.data( 'ui-autocomplete' ).menu.eventNamespace );
					target.removeData( 'ui-autocomplete' );

					$( this ).cbcodeautocomplete( cbcodeautocomplete.options );
				});

				cbcodeautocomplete.element.trigger( 'cbcodeautocomplete.init.after', [cbcodeautocomplete] );

				// Bind the cbcodeautocomplete to the element so it's reusable and chainable:
				cbcodeautocomplete.element.data( 'cbcodeautocomplete', cbcodeautocomplete );

				// Add this instance to our instance array so we can keep track of our cbcodeautocomplete instances:
				instances.push( cbcodeautocomplete );
			});
		},
		rebind: function() {
			var cbcodeautocomplete = $( this ).data( 'cbcodeautocomplete' );

			if ( ! cbcodeautocomplete ) {
				return this;
			}

			cbcodeautocomplete.element.cbcodeautocomplete( 'destroy' );
			cbcodeautocomplete.element.cbcodeautocomplete( cbcodeautocomplete.options );

			return this;
		},
		destroy: function() {
			var cbcodeautocomplete = $( this ).data( 'cbcodeautocomplete' );

			if ( ! cbcodeautocomplete ) {
				return false;
			}

			$.each( instances, function( i, instance ) {
				if ( instance.element == cbcodeautocomplete.element ) {
					instances.splice( i, 1 );

					return false;
				}

				return true;
			});

			cbcodeautocomplete.element.off( '.cbcodeautocomplete' );

			findTarget.call( cbcodeautocomplete.element ).autocomplete( 'destroy' );

			cbcodeautocomplete.element.removeData( 'cbcodeautocomplete' );
			cbcodeautocomplete.element.trigger( 'cbcodeautocomplete.destroyed', [cbcodeautocomplete] );

			return true;
		},
		instances: function() {
			return instances;
		}
	};

	function findTarget() {
		var element = ( this.jquery ? this : $( this ) );
		var target = null;

		if ( element.is( 'input' ) || element.is( 'select' ) || element.is( 'textarea' ) ) {
			target = element;
		} else {
			target = element.find( 'input,select,textarea' ).not( '[name$="__srmch"]' ).first();

			if ( target.is( ':checkbox' ) || target.is( ':radio' ) ) {
				target = element.find( 'input[name="' + target.attr( 'name' ) + '"]' );
			}
		}

		return target;
	}

	function getValue() {
		var element = ( this.jquery ? this : $( this ) );
		var value = null;

		if ( element.is( 'input' ) || element.is( 'select' ) || element.is( 'textarea' ) ) {
			if ( element.is( 'input[type="checkbox"]' ) || element.is( 'input[type="radio"]' ) ) {
				value = [];

				element.each( function() {
					if ( $( this ).is( ':checked' ) ) {
						value.push( $( this ).val() );
					}
				});
			} else if ( element.is( 'select[multiple]' ) ) {
				value = element.val();

				if ( value && ( ! $.isArray( value ) ) ) {
					value = value.split( ',' );
				}
			} else {
				value = element.val();
			}
		}

		return value;
	}

	$.fn.cbcodeautocomplete = function( options ) {
		if ( methods[options] ) {
			return methods[ options ].apply( this, Array.prototype.slice.call( arguments, 1 ) );
		} else if ( ( typeof options === 'object' ) || ( ! options ) ) {
			return methods.init.apply( this, arguments );
		}

		return this;
	};

	$.fn.cbcodeautocomplete.defaults = {
		init: true,
		useData: true,
		url: null,
		fields: [],
		length: null,
		strict: false,
		height: '200px'
	};
})(jQuery);