<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\NotificationsInterface;
use CBLib\Registry\Registry;
use CB\Plugin\Activity\CBActivity;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * render frontend page activity
 *
 * @var ActivityTable|NotificationTable $row
 * @var string                          $title
 * @var string                          $date
 * @var string                          $message
 * @var string                          $insert
 * @var string                          $footer
 * @var array                           $menu
 * @var Activity|Notifications          $stream
 * @var array                           $matches
 * @var CBplug_cbactivity               $this
 * @var string                          $output
 */
$notification					=	( $stream instanceof NotificationsInterface );
$id								=	(int) $matches[1];
$type							=	( isset( $matches[2] ) ? $matches[2] : null );

switch ( $type ) {
	case 'comment':
		if ( $notification ) {
			$title				=	CBTxt::T( 'COMMENTED_ON_URL_TITLE', 'commented on page <a href="[url]">[title]</a>', array( '[url]' => JRoute::_( 'index.php?Itemid=' . $id ), '[title]' => '#' . $id ) );
		} else {
			$title				=	CBTxt::T( 'commented on page' );
		}
		break;
	case 'like':
		if ( $notification ) {
			$title				=	CBTxt::T( 'LIKED_URL_TITLE', 'liked page <a href="[url]">[title]</a>', array( '[url]' => JRoute::_( 'index.php?Itemid=' . $id ), '[title]' => '#' . $id ) );
		} else {
			$title				=	CBTxt::T( 'liked page' );
		}
		break;
	default:
		if ( $notification ) {
			$title				=	CBTxt::T( 'SHARED_URL_TITLE', 'shared page <a href="[url]">[title]</a>', array( '[url]' => JRoute::_( 'index.php?Itemid=' . $id ), '[title]' => '#' . $id ) );
		} else {
			$title				=	CBTxt::T( 'shared page' );
		}
		break;
}

if ( $notification ) {
	$row->set( 'link', JRoute::_( 'index.php?Itemid=' . $id, false ) );
}

/** @var Registry $page */
$page							=	$row->source();

if ( ( ! $page->getInt( 'id' ) ) || in_array( $page->getString( 'type' ), array( 'separator', 'heading' ), true ) ) {
	return;
}

switch ( $page->getString( 'type' ) ) {
	case 'url':
		if ( ( strpos( $page->getString( 'link' ), 'index.php?' ) === 0 ) && ( strpos( $page->getString( 'link' ), 'Itemid=' ) === false ) ) {
			$page->set( 'flink', $page->getString( 'link' ) . '&Itemid=' . $page->getInt( 'id' ) );
		}
		break;
	case 'alias':
		$page->set( 'flink', 'index.php?Itemid=' . $page->getInt( 'params/aliasoptions' ) );

		if ( JLanguageMultilang::isEnabled() ) {
			$newItem			=	CBActivity::getMenuItem( $id );

			if ( $newItem->getInt( 'id' ) && $newItem->getString( 'language' ) && ( $newItem->getString( 'language' ) !== '*' ) ) {
				$page->set( 'flink', $page->getString( 'flink' ) . '&lang=' . $newItem->getString( 'language' ) );
			}
		}
		break;
	default:
		$page->set( 'flink', 'index.php?Itemid=' . $page->getInt( 'id' ) );
		break;
}

if ( ( strpos( $page->getString( 'flink' ), 'index.php?' ) !== false ) && strcasecmp( substr( $page->getString( 'flink' ), 0, 4 ), 'http' ) ) {
	$page->set( 'flink', JRoute::_( $page->getString( 'flink' ), true, $page->getInt( 'params/secure' ) ) );
} else {
	$page->set( 'flink', JRoute::_( $page->getString( 'flink' ) ) );
}

if ( ! $page->getString( 'flink' ) ) {
	return;
}

$page->set( 'title', htmlspecialchars( $page->getString( 'title' ), ENT_COMPAT, 'UTF-8', false ) );
$page->set( 'anchor_title', htmlspecialchars( $page->getString( 'params/menu-anchor_title' ), ENT_COMPAT, 'UTF-8', false ) );
$page->set( 'anchor_rel', htmlspecialchars( $page->getString( 'params/menu-anchor_rel' ), ENT_COMPAT, 'UTF-8', false ) );
$page->set( 'menu_image', htmlspecialchars( $page->getString( 'params/menu_image' ), ENT_COMPAT, 'UTF-8', false ) );
$page->set( 'menu_image_css', htmlspecialchars( $page->getString( 'params/menu_image_css' ), ENT_COMPAT, 'UTF-8', false ) );

$attributes						=	array();

if ( $page->getString( 'anchor_title' ) ) {
	$attributes['title']		=	$page->getString( 'anchor_title' );
}

if ( $page->getString( 'anchor_rel' ) ) {
	$attributes['rel']			=	$page->getString( 'anchor_rel' );
}

if ( $page->getInt( 'browserNav' ) === 1 ) {
	$attributes['target']		=	'_blank';

	if ( $page->getString( 'type' ) !== 'component' ) {
		$attributes['rel']		=	'noopener noreferrer';

		if ( $page->getString( 'anchor_rel' ) === 'nofollow' ) {
			$attributes['rel']	.=	' nofollow';
		}
	}
} elseif ( $page->getInt( 'browserNav' ) === 2 ) {
	$attributes['onclick']		=	"window.open( this.href, 'targetWindow', 'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes' ); return false;";
}

$pageTitle						=	JHtml::_( 'link', JFilterOutput::ampReplace( htmlspecialchars( $page->getString( 'flink' ), ENT_COMPAT, 'UTF-8', false ) ), $page->getString( 'title' ), $attributes );
$pageImage						=	null;

if ( $page->getString( 'menu_image' ) ) {
	$imageAttributes			=	array();
	$imageAttributes['class']	=	'img-fluid w-auto mw-100 streamItemImage';

	$pageImage					=	JHtml::_( 'link', JFilterOutput::ampReplace( htmlspecialchars( $page->getString( 'flink' ), ENT_COMPAT, 'UTF-8', false ) ), JHtml::_( 'image', $page->getString( 'menu_image' ), $page->getString( 'title' ), $imageAttributes ), $attributes );
}

if ( $notification ) {
	$row->set( 'link', $page->getString( 'flink' ) );

	switch ( $type ) {
		case 'comment':
			$title				=	CBTxt::T( 'COMMENTED_ON_PAGE_TITLE', 'commented on page [title]', array( '[title]' => $pageTitle ) );
			break;
		case 'like':
			$title				=	CBTxt::T( 'LIKED_PAGE_TITLE', 'liked page [title]', array( '[title]' => $pageTitle ) );
			break;
		default:
			$title				=	CBTxt::T( 'SHARED_PAGE_TITLE', 'shared page [title]', array( '[title]' => $pageTitle ) );
			break;
	}
} else {
	$insert						=	'<div class="bg-light border p-2 streamItemAttachment cbPageActivity">'
								.		'<div class="d-block d-sm-flex media streamMedia streamItemAttachmentInner">';

	if ( $pageImage ) {
		$insert					.=			'<div class="mb-2 mb-sm-0 pr-sm-2 media-left w-sm-100 mw-50 mw-sm-100 streamMediaLeft streamItemAttachmentMedia">'
								.				$pageImage
								.			'</div>';
	}

	$insert						.=			'<div class="media-body streamMediaBody streamItemAttachmentInfo">'
								.				'<div class="cbMoreLess">'
								.					'<div class="cbMoreLessContent">'
								.						'<div><strong>' . $pageTitle . '</strong></div>'
								.						htmlspecialchars( $page->getString( 'params/menu-meta_description', '' ), ENT_COMPAT, 'UTF-8', false )
								.					'</div>'
								.					'<div class="fade-edge cbMoreLessOpen hidden">'
								.						'<a href="javascript: void(0);" class="cbMoreLessButton">' . CBTxt::T( 'See More' ) . '</a>'
								.					'</div>'
								.				'</div>'
								.			'</div>'
								.		'</div>'
								.	'</div>';

	if ( $type ) {
		$row->params()->set( 'overrides.likes_asset', 'page.' . $id );
		$row->params()->set( 'overrides.comments_asset', 'page.' . $id );
	} else {
		$row->params()->set( 'overrides.likes_asset', 'asset' );
		$row->params()->set( 'overrides.comments_asset', 'asset' );
	}
}