<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * Determines what to display based off the core/custom asset
 *
 * @var ActivityTable|NotificationTable $row
 * @var string                          $title
 * @var string                          $message
 * @var string                          $date
 * @var string                          $insert
 * @var string                          $footer
 * @var array                           $menu
 * @var Activity|Notifications          $stream
 * @var CBplug_cbactivity               this
 * @var string                          $output
 */

$rowAsset	=	$row->getString( 'asset' );

if ( preg_match( '/^(?:(.+)\.)?activity\.(\d+)(?:\.(comment|tag|like)(?:\.(\d+))?)?/', $rowAsset, $matches ) ) {
	require CBActivity::getTemplate( $stream->getString( 'template' ), 'core/display/activity', false );
} elseif ( preg_match( '/^(?:(.+)\.)?comment\.(\d+)(?:\.(reply|tag|like)(?:\.(\d+))?)?/', $rowAsset, $matches ) ) {
	require CBActivity::getTemplate( $stream->getString( 'template' ), 'core/display/comment', false );
} elseif ( preg_match( '/^profile\.(\d+)\.([a-zA-Z]+)(?:\.(.+))?/', $rowAsset, $matches ) ) {
	switch ( $matches[2] ) {
		case 'login';
			require CBActivity::getTemplate( $stream->getString( 'template' ), 'core/display/login', false );
			break;
		case 'logout';
			require CBActivity::getTemplate( $stream->getString( 'template' ), 'core/display/logout', false );
			break;
		case 'registration';
			require CBActivity::getTemplate( $stream->getString( 'template' ), 'core/display/registration', false );
			break;
		case 'update';
			require CBActivity::getTemplate( $stream->getString( 'template' ), 'core/display/update', false );
			break;
		case 'avatar';
			require CBActivity::getTemplate( $stream->getString( 'template' ), 'core/display/avatar', false );
			break;
		case 'canvas';
			require CBActivity::getTemplate( $stream->getString( 'template' ), 'core/display/canvas', false );
			break;
		case 'connection';
			require CBActivity::getTemplate( $stream->getString( 'template' ), 'core/display/connection', false );
			break;
	}
} elseif ( preg_match( '/^blog\.(\d+)(?:\.(comment|like)(?:\.(\d+))?)?/', $rowAsset, $matches ) ) {
	require CBActivity::getTemplate( $stream->getString( 'template' ), 'core/display/blog', false );
} elseif ( preg_match( '/^article\.(\d+)(?:\.(comment|like)(?:\.(\d+))?)?/', $rowAsset, $matches ) ) {
	require CBActivity::getTemplate( $stream->getString( 'template' ), 'core/display/article', false );
} elseif ( preg_match( '/^page\.(\d+)(?:\.(comment|like)(?:\.(\d+))?)?/', $rowAsset, $matches ) ) {
	require CBActivity::getTemplate( $stream->getString( 'template' ), 'core/display/page', false );
} elseif ( preg_match( '/^kunena\.(\d+)\.(create|reply)/', $rowAsset, $matches ) ) {
	require CBActivity::getTemplate( $stream->getString( 'template' ), 'core/display/kunena', false );
} elseif ( preg_match( '/^pm\.(\d+)/', $rowAsset, $matches ) ) {
	require CBActivity::getTemplate( $stream->getString( 'template' ), 'core/display/pm', false );
}