<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJiveWall\Table\WallTable;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\NotificationsInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveWallActivity
{

	/**
	 * render frontend wall activity
	 *
	 * @param ActivityTable|NotificationTable $row
	 * @param null|string                     $title
	 * @param null|string                     $date
	 * @param null|string                     $message
	 * @param null|string                     $insert
	 * @param null|string                     $footer
	 * @param array                           $menu
	 * @param Activity|Notifications          $stream
	 * @param array                           $assetMatches
	 * @param WallTable                       $post
	 * @param cbPluginHandler                 $plugin
	 * @param string                          $output
	 */
	public static function showWallActivity( &$row, &$title, &$date, &$message, &$insert, &$footer, &$menu, $stream, $assetMatches, $post, $plugin, $output )
	{
		global $_CB_framework, $_PLUGINS;

		$type					=	( isset( $assetMatches[3] ) ? $assetMatches[3] : '' );
		$user					=	CBuser::getMyUserDataInstance();

		if ( CBGroupJive::canAccessGroup( $post->group(), $user ) ) {
			$groupName			=	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $post->group()->getInt( 'id', 0 ) ) ) . '">' . htmlspecialchars( CBTxt::T( $post->group()->getString( 'name' ) ) ) . '</a>';
		} else {
			$groupName			=	htmlspecialchars( CBTxt::T( $post->group()->getString( 'name' ) ) );
		}

		if ( $stream instanceof NotificationsInterface ) {
			if ( CBGroupJive::canAccessGroup( $post->group(), $user ) ) {
				$row->set( 'link', $_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $post->group()->getInt( 'id', 0 ), 'tab' => 'grouptabwall' ) ) );
			}

			$groupOwner			=	( $user->getInt( 'id', 0 ) === $post->group()->getInt( 'user_id', 0 ) );

			switch ( $type ) {
				case 'wall_approve':
					if ( $groupOwner ) {
						$title	=	CBTxt::T( 'POST_AWAITING_APPROVAL_IN_YOUR_GROUP', 'post is awaiting approval in your group [group]', array( '[group]' => $groupName ) );
					} else {
						$title	=	CBTxt::T( 'POST_AWAITING_APPROVAL_IN_GROUP', 'post is awaiting approval in group [group]', array( '[group]' => $groupName ) );
					}
					break;
				case 'wall_approved':
					if ( $groupOwner ) {
						$title	=	CBTxt::T( 'POST_APPROVED_IN_YOUR_GROUP', 'post approved in your group [group]', array( '[group]' => $groupName ) );
					} else {
						$title	=	CBTxt::T( 'POST_APPROVED_IN_GROUP', 'post approved in group [group]', array( '[group]' => $groupName ) );
					}
					break;
				case 'wall_reply':
					if ( $groupOwner ) {
						$title	=	CBTxt::T( 'POSTED_REPLY_IN_YOUR_GROUP', 'posted reply in your group [group]', array( '[group]' => $groupName ) );
					} else {
						$title	=	CBTxt::T( 'POSTED_REPLY_IN_GROUP', 'posted reply in group [group]', array( '[group]' => $groupName ) );
					}
					break;
				case 'wall_new':
				default:
					if ( $groupOwner ) {
						$title	=	CBTxt::T( 'POSTED_IN_YOUR_GROUP', 'posted in your group [group]', array( '[group]' => $groupName ) );
					} else {
						$title	=	CBTxt::T( 'POSTED_IN_GROUP', 'posted in group [group]', array( '[group]' => $groupName ) );
					}
					break;
			}
		} else {
			if ( $stream->getInt( 'groupjive.ingroup', 0 ) !== $post->group()->getInt( 'id', 0 ) ) {
				$title			=	CBTxt::T( 'POSTED_IN_GROUP', 'posted in group [group]', array( '[group]' => $groupName ) );
			}

			$message			=	$post->post();
		}

		$_PLUGINS->trigger( 'gj_onAfterWallActivity', array( &$row, &$title, &$date, &$message, &$insert, &$footer, &$menu, $stream, $assetMatches, $post, $plugin, $output ) );
	}
}