<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJive\Table\NotificationTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjivePhotoNotifications
{

	/**
	 * render frontend group photo notify params
	 *
	 * @param NotificationTable $row
	 * @param array             $input
	 * @param GroupTable        $group
	 * @param UserTable         $user
	 * @param cbPluginHandler   $plugin
	 * @return string
	 */
	public static function showPhotoNotifications( $row, $input, $group, $user, $plugin )
	{
		$isModerator	=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$isOwner		=	( $user->getInt( 'id', 0 ) === $group->getInt( 'user_id', 0 ) );
		$status			=	CBGroupJive::getGroupStatus( $user, $group );

		$return			=	'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
						.		'<label for="params__photo_new" class="col-form-label col-9 pr-2">' . CBTxt::T( 'Upload of new photo' ) . '</label>'
						.		'<div class="cb_field col-3 text-right">'
						.			$input['photo_new']
						.		'</div>'
						.	'</div>';

		if ( ( $isModerator || $isOwner || ( $status >= 2 ) ) && ( $group->params()->getInt( 'photo', 1 ) === 2 ) ) {
			$return		.=	'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
						.		'<label for="params__photo_approve" class="col-form-label col-9 pr-2">' . CBTxt::T( 'New photo requires approval' ) . '</label>'
						.		'<div class="cb_field col-3 text-right">'
						.			$input['photo_approve']
						.		'</div>'
						.	'</div>';
		}

		return $return;
	}
}