<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\Gallery\CBGallery;
use CB\Plugin\Gallery\Table\ItemTable;
use CB\Plugin\Gallery\Gallery;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_cbgalleryItemContainer
{

	/**
	 * @param ItemTable       $row
	 * @param UserTable       $viewer
	 * @param Gallery         $gallery
	 * @param cbPluginHandler $plugin
	 * @param string          $output
	 * @return string
	 */
	public static function showItemContainer( $row, $viewer, $gallery, $plugin, $output = null )
	{
		global $_CB_framework, $_PLUGINS;

		$canModerate					=	CBGallery::canModerate( $gallery );

		static $JS_LOADED				=	0;

		if ( ! $JS_LOADED++ ) {
			$_CB_framework->outputCbJQuery( "$( '.galleryModalToggle' ).cbgallery();", 'cbgallery' );
		}

		$menu							=	array();

		$content						=	$_PLUGINS->trigger( 'gallery_onDisplayItem', array( &$row, &$menu, $gallery ) );

		$rowId							=	md5( $gallery->id() . '_' . $row->getInt( 'id', 0 ) );
		$owner							=	( $viewer->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) );
		$title							=	( $row->getString( 'title' ) ? $row->getString( 'title' ) : $row->name() );
		$type							=	$row->getString( 'type' );
		$pending						=	( ( $row->getInt( 'published', 1 ) === -1 ) && $gallery->getBool( $type . '_create_approval', false ) );
		$solid							=	( ( ! in_array( $type, array( 'photos', 'videos' ), true ) ) && ( ( $type === 'files' ) && ( ! ( ( $row->extension() === 'svg' ) || ( CBGallery::getExtensionType( $row->extension() ) === 'photos' ) ) ) ) && ( ! $row->getString( 'thumbnail' ) ) );

		$name							=	$title;
		$embed							=	'<div class="d-flex h-100 w-100 justify-content-center align-items-center galleryItemEmbed">'
										.		'<span class="display-1 align-middle galleryImageIcon"><span class="fa fa-question"></span></span>'
										.	'</div>';
		$returnUrl						=	base64_encode( $gallery->location() );

		if ( $row->exists() ) {
			$displayPath				=	$_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'display', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ), 'raw', 0, true );
			$data						=	array();

			if ( $row->getString( '_previous' ) !== null ) {
				$data['previous']		=	$row->getString( '_previous' );
			}

			if ( $row->getString( '_next' ) !== null ) {
				$data['next']			=	$row->getString( '_next' );
			}

			$modal						=	cbTooltip( null, null, null, array( '90%', '90%' ), null, null, null, 'data-hascbtooltip="true" data-cbtooltip-modal="true" data-cbtooltip-open-solo=".galleryModal" data-cbtooltip-classes="galleryModal" data-cbtooltip-content-classes="p-0" data-cbtooltip-button-close="false" data-cbgallery-url="' . $displayPath . '" data-cbgallery-request="' . htmlspecialchars( json_encode( $data ) ) . '"' );
			$name						=	'<a href="javascript: void(0);" class="galleryItemName galleryModalToggle"' . $modal . '>' . $name . '</a>';
			$embed						=	'<a href="javascript: void(0);" class="d-flex h-100 w-100 justify-content-center align-items-center galleryItemEmbed galleryModalToggle" aria-label="' . htmlspecialchars( $title ) . '"' . $modal . ( $output !== 'preview' ? ' tabindex="-1"' : null ) . '>' . $row->thumbnail( $gallery, -1 ) . '</a>';
		}

		$buttons						=	array();

		if ( $output === 'approval' ) {
			$buttons[]					=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) . '" class="btn btn-sm btn-success galleryButton galleryButtonApprove">' . CBTxt::T( 'Approve' ) . '</a>';
		}

		if ( ( ! in_array( $output, array( 'compact', 'preview', 'module' ), true ) ) && ( $canModerate || $owner || $menu ) ) {
			$menuItems					=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 galleryMenuItems">';

			if ( $menu ) {
				$menuItems				.=		'<li class="galleryMenuItem">' . implode( '</li><li class="galleryMenuItem">', $menu ) . '</li>';
			}

			if ( $canModerate || $owner ) {
				$menuItems				.=		'<li class="galleryMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'edit', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';

				if ( $output !== 'approval' ) {
					if ( $pending ) {
						if ( $canModerate ) {
							$menuItems	.=		'<li class="galleryMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Approve' ) . '</a></li>';
						}
					} elseif ( $row->getInt( 'published', 1 ) > 0 ) {
						// CBTxt::T( 'ARE_YOU_SURE_UNPUBLISH_TYPE', 'Are you sure you want to unpublish this [type]?', array( '[type]' => CBGallery::translateType( $type, false, true ) ) )
						$menuItems		.=		'<li class="galleryMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'ARE_YOU_SURE_UNPUBLISH_' . strtoupper( $type ) . ' ARE_YOU_SURE_UNPUBLISH_TYPE', 'Are you sure you want to unpublish this [type]?', array( '[type]' => CBGallery::translateType( $type, false, true ) ) ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'unpublish', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-times-circle"></span> ' . CBTxt::T( 'Unpublish' ) . '</a></li>';
					} else {
						$menuItems		.=		'<li class="galleryMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Publish' ) . '</a></li>';
					}
				}

				// CBTxt::T( 'ARE_YOU_SURE_DELETE_TYPE', 'Are you sure you want to delete this [type]?', array( '[type]' => CBGallery::translateType( $type, false, true ) ) )
				$menuItems				.=		'<li class="galleryMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'ARE_YOU_SURE_DELETE_' . strtoupper( $type ) . ' ARE_YOU_SURE_DELETE_TYPE', 'Are you sure you want to delete this [type]?', array( '[type]' => CBGallery::translateType( $type, false, true ) ) ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>';
			}

			$menuItems					.=	'</ul>';

			$menuAttr					=	cbTooltip( null, $menuItems, null, 'auto', null, null, null, 'class="border btn btn-light btn-sm' . ( $output !== 'approval' ? ' cbCanvasLayoutHoverMenu' : null ) . ' cbCanvasLayoutMenu galleryContainerMenu" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' );

			$buttons[]					=	'<button type="button" ' . trim( $menuAttr ) . ' aria-label="' . htmlspecialchars( CBTxt::T( 'Media Menu' ) ) . '"><span class="pl-2 pr-2 align-bottom text-large fa fa-ellipsis-v"></span></button>';
		}

		$return							=	'<div class="position-relative' . ( ! in_array( $output, array( 'compact', 'preview' ), true ) ? ' col-6' . ( $output !== 'module' ? ' col-sm-4 col-lg-3' : null ) : 'h-100 w-100' ) . ' galleryItemContainer galleryContainer galleryContainer' . htmlspecialchars( ucfirst( $type ) ) . ' galleryContainer' . $rowId . ( $solid ? ' galleryContainerSolid' : null ) . '">'
										.		'<div class="card position-absolute w-100 h-100 no-overflow rounded-0 cbCanvasLayout cbCanvasLayoutHover">'
										.			'<div class="card-header rounded-0 p-0 border-0 w-100 h-100 cbCanvasLayoutTop">'
										.				$embed;

		if ( $buttons ) {
			$return						.=				'<div class="position-absolute text-right p-1 cbCanvasLayoutActions">'
										.					implode( ' ', $buttons )
										.				'</div>';
		}

		$return							.=			'</div>';

		if ( $output !== 'preview' ) {
			$return						.=			'<div class="position-absolute card-footer rounded-0 p-1 bg-white' . ( ! $solid ? ' d-none d-sm-block cbCanvasLayoutHoverShow' : null ) . ' cbCanvasLayoutFooter">'
										.				'<div class="text-truncate text-large cbCanvasLayoutContent">'
										.					$name
										.				'</div>';

			if ( ! in_array( $output, array( 'compact', 'module' ), true ) ) {
				$icons					=	array();

				if ( $pending ) {
					$icons[]			=	cbTooltip( null, CBTxt::T( 'Pending Approval' ), null, 'auto', null, '<span class="fa fa-warning text-warning"></span>', null, 'class="galleryContainerIconPending" data-cbtooltip-position-my="bottom center" data-cbtooltip-position-at="top center" data-cbtooltip-classes="qtip-simple"' );
				} elseif ( $row->getInt( 'published', 1 ) !== 1 ) {
					$icons[]			=	cbTooltip( null, CBTxt::T( 'Unpublished' ), null, 'auto', null, '<span class="fa fa-eye-slash"></span>', null, 'class="galleryContainerIconUnpublished" data-cbtooltip-position-my="bottom center" data-cbtooltip-position-at="top center" data-cbtooltip-classes="qtip-simple"' );
				}

				if ( count( $gallery->types() ) > 1 ) {
					$icons[]			=	cbTooltip( null, CBTxt::T( 'ITEM_EXT_TYPE', '[ext] [type]', array( '[ext]' => strtoupper( $row->extension( false, true ) ), '[type]' => CBGallery::translateType( $type ) ) ), null, 'auto', null, '<span class="fa ' . CBGallery::getTypeIcon( $row ) . '"></span>', null, 'class="galleryContainerIconType" data-cbtooltip-position-my="bottom center" data-cbtooltip-position-at="top center" data-cbtooltip-classes="qtip-simple"' );
				}

				$return					.=				'<div class="d-none d-sm-flex text-small text-muted d-flex flex-wrap no-gutters cbCanvasLayoutContent">'
										.					'<div class="text-truncate' . ( $icons ? ' col-sm-6' : null ) . ' cbCanvasLayoutContent">'
										.						'<span title="' . htmlspecialchars( $row->getString( 'date' ) ) . '">'
										.							cbFormatDate( $row->getString( 'date' ), true, false, CBTxt::T( 'GALLERY_SHORT_DATE_FORMAT', 'M j, Y' ) )
										.						'</span>'
										.					'</div>';

				if ( $icons ) {
					$return				.=					'<div class="text-truncate col-sm-6 text-sm-right cbCanvasLayoutContent">'
										.						implode( ' ', $icons )
										.					'</div>';
				}

				$return					.=				'</div>'
										.				( $content ? '<div class="cbCanvasLayoutContent galleryContainerIntegrations">' . implode( '', $content ) . '</div>' : null );
			}

			$return						.=			'</div>';
		}

		$return							.=		'</div>'
										.	'</div>';

		return $return;
	}
}