<?php // no direct access

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

?>
<h1><?php echo JText::_('INVOICES_TITLE'); ?></h1>

<form action="index.php" method="get" name="adminForm">
  <div class="table_scrolls">
    <table class="table table-striped table-hover items_table_responsive">
      <thead>
      <tr class="headerfinances">

        <th width="20%"><?php echo JHTML::_( 'grid.sort', 'INVOICE_DATE', 'i.invoice_date', $this->lists['order_Dir'], $this->lists['order']); ?></th>
        <th width="15%"><?php echo JText::_('INVOICE_NUM'); ?></th>
        <th width="15%"><?php echo JText::_('TO_NAME'); ?></th>
        <th width="20%" align="right"><?php echo JText::_('SUBTOTAL'); ?></th>
        <th width="20%" align="right"><?php echo JText::_('TOTAL'); ?></th>
        <th width="10%"></th>
      </tr>
    </thead>
      <?php $k = 1; 
      $number = $this->pagination->limitstart + 1 ;

      $total_global = 0 ;
      if(count($this->items)){
       for ($i = 0, $n=count( $this->items ); $i < $n; $i++)	{ 

        ?>
        <tr class="linefinances<?php echo $k; ?>" >

          <td><?php echo JHTML::_('date', $this->items[$i]->invoice_date, JText::_('DATE_FORMAT_LC3'), false); ?></td>
          <td><?php echo $this->items[$i]->invoice_num; ?></td>
          <td><?php echo $this->items[$i]->to_name; ?></td>
          <td align="right"><?php echo InvoicesHelper::format($this->items[$i]->subtotal, $this->items[$i]->currency_before, $this->items[$i]->currency_after); ?></td>
          <td align="right"><?php echo InvoicesHelper::format($this->items[$i]->total, $this->items[$i]->currency_before, $this->items[$i]->currency_after); ?></td>
          <td><?php echo InvoicesHelper::view_modal_button($this->items[$i]->id); ?> <?php echo InvoicesHelper::view_online_button($this->items[$i]->id); ?> <?php echo InvoicesHelper::download_pdf_button($this->items[$i]->id); ?> <?php echo InvoicesHelper::send_email_button($this->items[$i]->id); ?></td>
        </tr>
        <?php $k = 3 - $k;
        $number++;
      }
    }
    else{ ?>
    <tr class="linefinances1" >
      <td align="center" colspan="6"><?php echo JText::_('NO_INVOICES_AVAILABLE'); ?></td>
    </tr>
    <?php } ?>
    <tfoot>
      <tr class="footfinances">
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td class="totals" align="right"></td>
      </tr>
    </tfoot>
  </table>
</div>
<input type="hidden" name="option" value="com_invoices" />
<input type="hidden" name="view" value="invoices" />
<input type="hidden" name="filter_order" value="<?php echo JRequest::getVar('filter_order'); ?>" />
<input type="hidden" name="filter_order_Dir" value="<?php echo JRequest::getVar('filter_order_Dir'); ?>" />
<div class="pagination" align="center"> <?php echo $this->pagination->getListFooter(); ?> </div>
</form>
<div align="center"><?php echo InvoicesHelper::showInvoicesFooter(); ?></div>
