<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.joomlathat.com
# Technical Support:  Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

$numtaxes = count($this->taxes);
switch ($numtaxes) {
  case 0:
    $boxclass = "col-md-sp5" ;
    break;
  case 1:
    $boxclass = "col-md-2" ;
    break;
  case 2:
    $boxclass = "col-md-sp7" ;
    break;

  default:
    $boxclass = "col-md-2" ;
    break;
}
?>

<div class="row at_totals ">

  <div class="<?php echo $boxclass; ?> col-sm-6 text-right hidden-xs">
    <div class="dashboard-box dashboard-info">
    <div class="row ">
        <div class="col-xs-6 hidden-md col-lg-6">
          <div class="  module-wrapper">
          <?php
          $modules = JModuleHelper::getModules("num_invoices_backend_small");
          $document = JFactory::getDocument();
          $renderer = $document->loadRenderer('module');
          $attribs  = array();
          $attribs['style'] = 'xhtml';
          foreach ( @$modules as $mod )
          {
            if($mod->module == "mod_content_statistics_compare"){
              $this->cs_modules[] = $mod;
            }
            echo $renderer->render($mod, $attribs);
          }
          ?>
        </div>
      </div>
        <div class="col-xs-6 col-md-12 col-lg-6">
          <div class=" resume-number ">

            <div class="big_number summary-number total_invoices" id="summary_num_invoices">{{ summary.num_invoices }}</div>
            <span class="resume-title"><?php echo JText::_('NUM_INVOICES'); ?></span>
            <span class="timeframe-title">&nbsp;</span>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="<?php echo $boxclass; ?> col-sm-6 text-right ">
    <div class="dashboard-box dashboard-inverse">
    <div class="row ">
        <div class="col-xs-6 hidden-md col-lg-6">
          <div class="  module-wrapper">
          <?php
          $modules = JModuleHelper::getModules("total_invoices_backend_small");
          $document = JFactory::getDocument();
          $renderer = $document->loadRenderer('module');
          $attribs  = array();
          $attribs['style'] = 'xhtml';
          foreach ( @$modules as $mod )
          {
            if($mod->module == "mod_content_statistics_compare"){
              $this->cs_modules[] = $mod;
            }
            echo $renderer->render($mod, $attribs);
          }
          ?>
        </div>
      </div>
        <div class="col-xs-6 col-md-12 col-lg-6">
          <div class=" resume-number ">

            <div class="big_number summary-number" id="summary_total_invoices">{{ total_invoices() | currency(currency_id) }}</div>
            <span class="resume-title"><?php echo JText::_('TOTAL_INVOICES'); ?><?php if($this->params->get('multiple_currency', false)){ ?> ({{ currency.currency_code }})<?php } ?></span>
            <span class="timeframe-title">&nbsp;</span>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="<?php echo $boxclass; ?> col-sm-6 text-right hidden-xs">
    <div class="dashboard-box dashboard-light">
    <div class="row ">
        <div class="col-xs-6 hidden-md col-lg-6">
          <div class="  module-wrapper">
          <?php
          $modules = JModuleHelper::getModules("subtotal_invoices_backend_small");
          $document = JFactory::getDocument();
          $renderer = $document->loadRenderer('module');
          $attribs  = array();
          $attribs['style'] = 'xhtml';
          foreach ( @$modules as $mod )
          {
            if($mod->module == "mod_content_statistics_compare"){
              $this->cs_modules[] = $mod;
            }
            echo $renderer->render($mod, $attribs);
          }
          ?>
        </div>
      </div>
        <div class="col-xs-6 col-md-12 col-lg-6">
          <div class=" resume-number ">

            <div class="big_number summary-number" id="summary_subtotal_invoices">{{ subtotal_invoices() | currency(currency_id) }}</div>
            <span class="resume-title"><?php echo JText::_('SUBTOTAL_INVOICES'); ?><?php if($this->params->get('multiple_currency', false)){ ?> ({{ currency.currency_code }})<?php } ?></span>
            <span class="timeframe-title">&nbsp;</span>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php foreach($this->taxes as $tax){ ?>

  <div class="<?php echo $boxclass; ?> col-sm-6 text-right hidden-xs">
    <div class="dashboard-box dashboard-warning">
    <div class="row ">
        <div class="col-xs-6 hidden-md col-lg-6">
          <div class="  module-wrapper">
          <?php
          $modules = JModuleHelper::getModules("tax_".$tax->id."_backend_small");
          $document = JFactory::getDocument();
          $renderer = $document->loadRenderer('module');
          $attribs  = array();
          $attribs['style'] = 'xhtml';
          foreach ( @$modules as $mod )
          {
            if($mod->module == "mod_content_statistics_compare"){
              $this->cs_modules[] = $mod;
            }
            echo $renderer->render($mod, $attribs);
          }
          ?>
        </div>
      </div>
        <div class="col-xs-6 col-md-12 col-lg-6">
          <div class=" resume-number ">

            <div class="big_number summary-number" id="summary_tax_<?php echo $tax->id; ?>">{{ total_tax(<?php echo $tax->id; ?>) | currency(currency_id) }}</div>
            <span class="resume-title"><?php echo $tax->name; ?><?php if($this->params->get('multiple_currency', false)){ ?> ({{ currency.currency_code }})<?php } ?></span>
            <span class="timeframe-title">&nbsp;</span>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php } ?>

  <div class="<?php echo $boxclass; ?> col-sm-6 text-right hidden-xs">
    <div class="dashboard-box dashboard-success">
    <div class="row ">
        <div class="col-xs-6 hidden-md col-lg-6">
          <div class="  module-wrapper">
          <?php
          $modules = JModuleHelper::getModules("total_income_backend_small");
          $document = JFactory::getDocument();
          $renderer = $document->loadRenderer('module');
          $attribs  = array();
          $attribs['style'] = 'xhtml';
          foreach ( @$modules as $mod )
          {
            if($mod->module == "mod_content_statistics_compare"){
              $this->cs_modules[] = $mod;
            }
            echo $renderer->render($mod, $attribs);
          }
          ?>
        </div>
      </div>
        <div class="col-xs-6 col-md-12 col-lg-6">
          <div class=" resume-number ">

            <div class="big_number summary-number" id="summary_total_income">{{ total_income() | currency(currency_id) }}</div>
            <span class=" resume-title"><?php echo JText::_('TOTAL_INCOME'); ?><?php if($this->params->get('multiple_currency', false)){ ?> ({{ currency.currency_code }})<?php } ?></span>
            <span class="timeframe-title">&nbsp;</span>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="<?php echo $boxclass; ?> col-sm-6 text-right hidden-xs">
    <div class="dashboard-box dashboard-important">
    <div class="row ">
        <div class="col-xs-6 hidden-md col-lg-6">
          <div class="  module-wrapper">
          <?php
          $modules = JModuleHelper::getModules("pending_income_backend_small");
          $document = JFactory::getDocument();
          $renderer = $document->loadRenderer('module');
          $attribs  = array();
          $attribs['style'] = 'xhtml';
          foreach ( @$modules as $mod )
          {
            if($mod->module == "mod_content_statistics_compare"){
              $this->cs_modules[] = $mod;
            }
            echo $renderer->render($mod, $attribs);
          }
          ?>
        </div>
      </div>
        <div class="col-xs-6 col-md-12 col-lg-6">
          <div class=" resume-number ">

            <div class="big_number summary-number" id="summary_pending_income">{{ pending_income() | currency(currency_id) }}</div>
            <span class="resume-title"><?php echo JText::_('PENDING_INCOME'); ?><?php if($this->params->get('multiple_currency', false)){ ?> ({{ currency.currency_code }})<?php } ?></span>
            <span class="timeframe-title">&nbsp;</span>
          </div>
        </div>
      </div>
    </div>
  </div>

</div>
