<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.joomlathat.com
# Technical Support:  Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

?>
<div class="form-group form-group-lg">
  <label class="control-label col-md-2" for="to_name"> <?php echo JText::_( 'RECIPIENT_NAME' ); ?></label>
  <div class="controls col-md-10">
    <input  class="form-control"
            type="text"
            name="to_name"
            id="to_name"

            maxlength="255"
            v-model="invoice.to_name"
            placeholder="<?php echo JText::_( 'RECIPIENT_NAME_PLACEHOLDER' ); ?>" />
  </div>
</div>
<div class="form-group">
  <label class="control-label col-md-2" for="to_company"> <?php echo JText::_( 'COMPANY' ); ?></label>
  <div class="controls col-md-10">
    <input class="form-control" type="text" name="to_company" id="to_company"  maxlength="255" v-model="invoice.to_company" placeholder="<?php echo JText::_( 'COMPANY' ); ?>" />
  </div>
</div>
<div class="form-group">
  <label class="control-label col-md-2" for="to_address"> <?php echo JText::_( 'RECIPIENT_ADDRESS' ); ?></label>
  <div class="controls col-md-10">
    <textarea class="form-control"  name="to_address" id="to_address" cols="40" rows="4"  placeholder="<?php echo JText::_( 'RECIPIENT_ADDRESS' ); ?>" v-model="invoice.to_address"></textarea>
  </div>
</div>
<div class="form-group">
  <label class="control-label col-md-2" for="to_city"> <?php echo JText::_( 'CITY' ); ?></label>
  <div class="controls col-md-4">
    <input class="form-control " type="text" name="to_city" id="to_city"  maxlength="255" v-model="invoice.to_city" placeholder="<?php echo JText::_( 'RECIPIENT_CITY_PLACEHOLDER' ); ?>" />
  </div>
  <label class="control-label col-md-2" for="to_city"> <?php echo JText::_( 'ZIP' ); ?></label>
  <div class="controls col-md-4">
    <input class="form-control " type="text" name="to_zipcode" id="to_zipcode"  maxlength="255" v-model="invoice.to_zipcode" placeholder="<?php echo JText::_( 'RECIPIENT_ZIPCODE_PLACEHOLDER' ); ?>" />
  </div>
</div>
<div class="form-group">
  <label class="control-label col-md-2" for="to_city"> <?php echo JText::_( 'STATE' ); ?></label>
  <div class="controls col-md-4">
    <input class="form-control " type="text" name="to_state" id="to_state"  maxlength="255" v-model="invoice.to_state" placeholder="<?php echo JText::_( 'RECIPIENT_STATE_PLACEHOLDER' ); ?>" />
  </div>
  <label class="control-label col-md-2" for="to_city"> <?php echo JText::_( 'COUNTRY' ); ?></label>
  <div class="controls col-md-4">
    <input class="form-control " type="text" name="to_country" id="to_country"  maxlength="255" v-model="invoice.to_country" placeholder="<?php echo JText::_( 'RECIPIENT_COUNTRY_PLACEHOLDER' ); ?>" />
  </div>
</div>
<div class="form-group">
  <label class="control-label col-md-2" for="to_email"> <?php echo JText::_( 'EMAIL' ); ?></label>
  <div class="controls col-md-10">
    <input class="form-control" type="email" name="to_email" id="to_email"  maxlength="255" v-model="invoice.to_email" placeholder="<?php echo JText::_( 'EMAIL' ); ?>" />
  </div>
</div>
<div class="form-group">
  <label class="control-label col-md-2" for="to_phone"> <?php echo JText::_( 'PHONE' ); ?></label>
  <div class="controls col-md-10">
    <input class="form-control" type="text" name="to_phone" id="to_phone"  maxlength="255" v-model="invoice.to_phone" placeholder="<?php echo JText::_( 'PHONE' ); ?>" />
  </div>
</div>
<div class="form-group has-feedback" id="vatid_container">
  <label class="control-label col-md-2" for="to_vatid"> <?php echo JText::_( 'VATID' ); ?></label>
  <div class="controls col-md-10">
    <?php if ($this->params->get('euvat_verification', 1)): ?>
      <div class="input-group">
        <input class="form-control"
                type="text"
                name="to_vatid"
                id="to_vatid"
                maxlength="255"
                v-model="invoice.to_vatid"
                placeholder="<?php echo JText::_( 'VATID' ); ?>" />
        <span class="input-group-btn">
          <button class="btn btn-default" type="button" @click="validate_eu_vat()"><?php echo JText::_('VERIFY_EU_VAT_ID'); ?></button>
        </span>
      </div><!-- /input-group -->
      <span class="glyphicon glyphicon-ok form-control-feedback" aria-hidden="true"></span>
      <span class="glyphicon glyphicon-refresh glyphicon-spin form-control-feedback hide" id="spinner_euvat"></span>
      <span id="inputGroupSuccess1Status" class="sr-only">(success)</span>
    <?php else: ?>
      <input class="form-control"
              type="text"
              name="to_vatid"
              id="to_vatid"

              maxlength="255"
              v-model="invoice.to_vatid"
              placeholder="<?php echo JText::_( 'VATID' ); ?>" />
    <?php endif; ?>
  </div>
</div>

<hr />

<div class="form-group">
  <label class="control-label col-md-2" ><?php echo JText::_( 'CONTACT_OPTIONS' ); ?></label>
  <input  class="form-control"
          type="hidden"
          name="user_id"
          id="user_id"
          v-model="invoice.user_id" />

  <div class="controls col-md-3">
    <div class="btn-group">
      <button type="button"
              class="btn btn-info"
              :class="{active: invoice.vincular_cliente_checkbox == 1}"
              data-original-title="<? echo JText::_('LINK_TO_EXISTING_CONTACT'); ?>"
              data-toggle="tooltip"
              @click="toggleContactOptions(1)">
        <span class="glyphicon glyphicon-user" ></span>
      </button>
      <button type="button"
              class="btn btn-info"
              :class="{active: !invoice.vincular_cliente_checkbox == 2}"
              data-original-title="<? echo JText::_('CREATE_NEW_CONTACT'); ?>"
              data-toggle="tooltip"
              @click="toggleContactOptions(2)">
        <span class="glyphicon glyphicon-plus-sign" ></span>
      </button>
      <button type="button"
              class="btn btn-info"
              :class="{active: invoice.vincular_cliente_checkbox == 3}"
              data-original-title="<? echo JText::_('UPDATE_CONTACT_DATA'); ?>"
              data-toggle="tooltip"
              @click="toggleContactOptions(3)">
        <span class="glyphicon glyphicon-refresh" ></span>
      </button>
      <button type="button"
              class="btn btn-info"
              :class="{active: !invoice.vincular_cliente_checkbox == 4}"
              data-original-title="<? echo JText::_('DO_NOT_LINK_TO_CONTACT'); ?>"
              data-toggle="tooltip"
              @click="toggleContactOptions(4)">
          <span class="glyphicon glyphicon-remove" ></span>
      </button>
    </div>
    <input  type="hidden"
            name="vincular_cliente_checkbox"
            :value="invoice.vincular_cliente_checkbox">
  </div>

  <label class="control-label col-md-2" ><?php echo JText::_( 'CONTACT' ); ?></label>

  <div class="controls col-md-5">
    <input  type="text"
            class="form-control "
            readonly
            id="vincular_cliente"
            size="30"
            v-model="invoice.contact_name"
            placeholder="<?php echo JText::_( 'CONTACT_NAME_PLACEHOLDER' ); ?>" />
  </div>

</div>

<hr />

<div class="form-group">
  <label class="control-label col-md-2" for="search_user"><?php echo JText::_( 'LINK_TO_JOOMLA_USER' ); ?></label>
  <div class="controls col-md-10">
    <div class="row">

      <div class="col-md-4">

        <input  type="text"
                class="form-control "
                readonly
                id="username"
                size="40"
                v-model="username_id"
                placeholder="<?php echo JText::_( 'JOOMLA_USERNAME_PLACEHOLDER' ); ?>" />

        <input  class="inputbox input-mini small-margin-top"
                type="hidden"
                name="joomla_user_id"
                id="joomla_user_id"
                size="4"
                maxlength="11"
                v-model="invoice.joomla_user_id" />

      </div>

      <div class="col-md-8">

        <div class="controls">
          <input  class="form-control"
                  type="text"
                  name="search_user"
                  id="search_user"
                  value=""
                  size="30"
                  placeholder="<?php echo JText::_('TYPE_TO_SEARCH_USER'); ?>" />
        </div>

        <div id="log_clientes"></div>

      </div>
    </div>
  </div>

</div>
