<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.joomlathat.com
# Technical Support:  Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

?>

<div class="form-group">
  <label class="control-label col-md-2" for="publish1"> <?php echo JText::_( 'PUBLISHED' ); ?> </label>
  <div class="controls col-md-10">
    <div class="btn-group">
      <button type="button"
              class="btn"
              id="publish1"
              :class="{'btn-success active': invoice.publish, 'btn-default': !invoice.publish}"
              @click="togglePublish(1)"><?php echo JText::_('JYES'); ?></button>
      <button type="button"
              class="btn"
              id="publish0"
              :class="{'btn-danger active': !invoice.publish, 'btn-default': invoice.publish}"
              @click="togglePublish(0)"><?php echo JText::_('JNO'); ?></button>
    </div>
    <input  type="hidden"
            name="publish"
            :value="invoice.publish">
  </div>
</div>

<div class="form-group">
  <label class="control-label col-md-2" for="start_publish_"> <?php echo JText::_( 'START_PUBLISHING'); ?> </label>
  <div class="controls col-md-4">
   <div class="input-group" >
      <input  class="form-control "
              type="text"
              name="start_publish"
              id="start_publish_"
              data-date-format="yyyy-mm-dd"
              v-model="invoice.start_publish"
              placeholder="<?php echo JText::_('NOT_SETTED'); ?>"/>

        <span class="input-group-btn">
          <span class="btn btn-default" id="start_publish_btn_"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
        </span>
    </div>
  </div>
  <label class="control-label col-md-2" for="end_publish_"> <?php echo JText::_( 'END_PUBLISHING'); ?> </label>
  <div class="controls col-md-4">
   <div class="input-group" >
      <input  class="form-control "
              type="text"
              name="end_publish"
              id="end_publish_"
              data-date-format="yyyy-mm-dd"
              v-model="invoice.end_publish"
              placeholder="<?php echo JText::_('NOT_SETTED'); ?>"/>

        <span class="input-group-btn">
          <span class="btn btn-default" id="end_publish_btn_"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
        </span>
    </div>
  </div>
  <span class="help-block col-md-offset-2 col-md-10"><?php echo JText::_('PUBLISH_EXPLANATION'); ?></span>
</div>

<hr />

<div class="form-group">
  <label class="control-label col-md-2" for="public_link"> <?php echo JText::_( $this->layout_type . '_PUBLIC_LINK'); ?> </label>
  <div class="controls col-md-10">
    <div class="input-group">
      <input  onClick="this.select();"
              class="form-control "
              id="public_link"
              readonly
              type="text"
              v-model="invoice.public_link" />
      <span class="input-group-btn">
        <button class="btn btn-default" type="button" onClick="jQuery('#public_link').select();"><?php echo JText::_('COPY'); ?></button>
      </span>
    </div><!-- /input-group -->
    <input type="hidden" name="auth_code" v-model="invoice.auth_code" />
  </div>
  <span class="help-block col-md-offset-2 col-md-10"><?php echo JText::_('PUBLIC_LINK_EXPLANATION'); ?></span>
</div>
