<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

jimport('joomla.application.component.model');

class TaxesModelTax extends JModelLegacy
{

	var $input;

	function __construct()
	{
		parent::__construct();

		$mainframe = JFactory::getApplication();
		$this->input = $mainframe->input;

		$array = $this->input->get('cid',  0, '', 'array');
		$this->setId((int)$array[0]);

		$this->params = JComponentHelper::getParams( 'com_invoices' );

	}

	function setId($id)
	{
		// Set id and wipe data
		$this->_id		= $id;
		$this->_data	= null;

	}

	function &getData()
	{
		// Load the data
		if (empty( $this->_data )) {
			$query = ' SELECT te.* FROM #__invoices_taxes as te '.

					'  WHERE te.id = '.$this->_id;
			$this->_db->setQuery( $query );
			$this->_data = $this->_db->loadObject();


		}
		//print_r( $this->_data);die();
		if (!$this->_data) {
			$this->_data = new stdClass();
			$this->_data->id = 0;
			$this->_data->name = "";
			$this->_data->type = "";
			$this->_data->value = 0;
			$this->_data->show_column = "";
            $this->_data->checked = "";
			$this->_data->ordering = 1;
			$this->_data->calculate_on = 1;

		}

		return $this->_data;
	}

	function &getTypes()
	{
		// Load the data
		if (empty( $this->types )) {

			$this->types[] = "percent" ;
			$this->types[] = "static" ;

		}

		return $this->types;
	}

	function store()
	{
		$row = $this->getTable();

		$data = $this->input->post->getArray();

		// Bind the form fields to the album table
		if (!$row->bind($data)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		if (!$row->check()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		if (!$row->store()) {
			print_r($row);die();
			$this->setError( $this->_db->getErrorMsg() );
			return false;
		}
		//print_r($row);die();

		if(!$data["id"]){ // it's a new invoice
			$data["id"] = $row->id;
		}

		return true;
	}


	function delete()
	{
		$cids = $this->input->get( 'cid', array(0), 'post', 'array' );

		$row = $this->getTable();

		if (count( $cids )) {
			foreach($cids as $cid) {

				if (!$row->delete( $cid )) {
					$this->setError( $row->getErrorMsg() );
					return false;
				}
			}
		}
		return true;
	}

}
