<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

class InvoicesControllerInvoice extends InvoicesController
{

	function __construct()
	{
		parent::__construct();

		// Register Extra tasks
		$this->registerTask( 'add'  , 	'edit' );
		$this->registerTask( 'apply',	'save' );

	}

	function display( $cachable = false, $urlparams = array())
	{

		$modal = $this->input->getInt( 'modal' ) ;
		$tmpl = $this->input->getString( 'tmpl' ) ;

		if(($modal || $tmpl == "component")){

			$layout = $this->input->getString( 'layout' );

			$model = $this->getModel('invoice');

			$view = $this->getInvoiceView();

			$params = JComponentHelper::getParams( 'com_invoices' );

			$view->setModel($model);

			$view->invoice = $model->getData();
			$view->items = $model->getItems();
			$view->template = $model->getTemplate();
			$view->taxes = $model->getTaxesInvoice();
			$view->payments = $model->getPaymentsInvoice();
			$view->payments2 = $model->getPaymentsInvoice2();

			$view->params = $params;

			$content = $view->loadTemplate( 'email' );

			$data = $this->get_invoice_data();

			$return = new stdClass();

			//we fill the content to return
			$return->content = $content ;
			$return->data = $data ;

			$this->sendJSONResponse($return);

		}

		parent::display($cachable,$urlparams);
	}

	static function getInvoiceView()
	{
		if (!class_exists( 'InvoicesViewInvoice' ))
		{
			// Build the path to the model based upon a supplied base path
			$path = JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_invoices'.DS.'views'.DS.'invoice'.DS.'view.html.php';
			$false = false;

			// If the model file exists include it and try to instantiate the object
			if (file_exists( $path )) {
				require_once( $path );
				//require_once(JPATH_SITE.DS.'components'.DS.'com_finances'.DS.'views'.DS.'item'.DS.'tmpl'.DS.'default_email.php');
				if (!class_exists( 'InvoicesViewInvoice' )) {
					JError::raiseWarning( 0, 'View class InvoicesViewInvoice not found in file.' );
					return $false;
				}
			} else {
				JError::raiseWarning( 0, 'View InvoicesViewInvoice not supported. File not found.' );
				return $false;
			}
		}

		$view = new InvoicesViewInvoice();
		return $view;
	}

	function edit()
	{
		if(InvoicesHelper::allowEdit()){
			$this->input->set( 'view', 'invoice' );
			$this->input->set( 'layout', 'form'  );
			$this->input->set( 'hidemainmenu', 1);

			$modal = $this->input->getInt( 'modal' ) ;
			$tmpl = $this->input->getString( 'tmpl' ) ;

			if(($modal || $tmpl == "component")){
				$layout = $this->input->getString( 'layout' );

				$model = $this->getModel('invoice');

				$return = new stdClass();

				//we fill the content to return
				$return->data = $model->getData();

				$this->sendJSONResponse($return);

			}

			parent::display();
		}

		else return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
	}

	function save()
	{
		$model = $this->getModel('invoice');

		$type = $this->input->getInt('type');

		switch($type){
			case 1: //invoice

			if ($id = $model->store()) {
				$msg = JText::_( 'INVOICE_SAVED' );
				$type = "message";
			} else {
				$msg = JText::_( 'ERROR_SAVING_INVOICE' );
				$type = "error";
			}

			break;
			case 2://quote

			if ($id = $model->store()) {
				$msg = JText::_( 'QUOTE_SAVED' );
				$type = "message";
			} else {
				$msg = JText::_( 'ERROR_SAVING_QUOTE' );
				$type = "error";
			}

			break;
		}

		$task = $this->input->getCmd( 'task' );
		$tab = $this->input->getCmd( 'tab' );

		switch ($task)
		{
			case 'apply':
				$link = 'index.php?option=com_invoices&controller=invoice&task=edit&cid[]='. $id.'&tab='.$tab ;
				break;

			case 'save':
			default:
				$link = 'index.php?option=com_invoices';
				break;
		}

		if($this->input->getInt('ajax')) {
			//we fill the notification to return
			$return = new stdClass();
			$return->notifications = array();
			$return->notifications[0] = new stdClass();
			$return->notifications[0]->message = $msg;
			$return->notifications[0]->type = $type;

			//we fill the content to return
			$return->content = $model->getDataDisplay($id) ;

			//we return the totals as well
			$modelinvoices = $this->getModel('invoices');
			$return->summary = $modelinvoices->getTotals();

			//return json
			$this->sendJSONResponse($return);
		}

		$this->setRedirect($link, $msg);
	}

	function remove()
	{
		$mainframe = JFactory::getApplication();

		$type = $this->input->getInt('type');

		if(InvoicesHelper::canDelete()){
			$model = $this->getModel('invoice');

			switch($type){
				case 1: //invoice

				if(!$model->delete()) {
					$msg = JText::_( 'ERROR_DELETING_INVOICES' );
					$type = "error";
				} else {
					$msg = JText::_( 'INVOICES_DELETED' );
					$type = "message";
				}

				break;
				case 2://quote

				if(!$model->delete()) {
					$msg = JText::_( 'ERROR_DELETING_QUOTES' );
					$type = "error";
				} else {
					$msg = JText::_( 'QUOTES_DELETED' );
					$type = "message";
				}

				break;
			}

			$this->setRedirect( 'index.php?option=com_invoices', $msg );
		}
		else {
			if($this->input->getInt('ajax')) {
				$msg = JText::_( 'JERROR_ALERTNOAUTHOR' );
				$type = "error";
			}
			else return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
		}

		if($this->input->getInt('ajax')) {
			//we fill the notification to return
			$return = new stdClass();
			$return->notifications = array();
			$return->notifications[0] = new stdClass();
			$return->notifications[0]->message = $msg;
			$return->notifications[0]->type = $type;

			//we fill the content to return
			$return->content = "" ;

			//return json
			$this->sendJSONResponse($return);

			$mainframe->close();
		}
	}

	function cancel()
	{
		$msg = JText::_( 'OPERATION_CANCELLED' );
		$this->setRedirect( 'index.php?option=com_invoices', $msg );
	}

	function search_contact(){

		$keywords = $this->input->getVar("searchword");

		$db = JFactory::getDBO();

		$where_clause[] = ' ( co.name LIKE "%'.$keywords.'%" OR co.company LIKE "%'.$keywords.'%" OR co.email LIKE "%'.$keywords.'%" OR co.address LIKE "%'.$keywords.'%" ) ';

		// Build the where clause of the content record query
		$where_clause = (count($where_clause) ? ' WHERE '.implode(' AND ', $where_clause) : '');

		$query = ' SELECT co.*, u.username, co.name AS to_name, co.company AS to_company, co.email AS to_email, co.address AS to_address, co.id AS user_id, co.name AS contact_name, '
						.' co.city AS to_city, co.state AS to_state, co.country AS to_country, co.zipcode AS to_zipcode, co.vatid AS to_vatid, co.user_id AS joomla_user_id, co.phone AS to_phone '
						.' FROM #__invoices_contacts AS co LEFT JOIN #__users AS u ON u.id = co.user_id '
						. $where_clause
						.' ORDER BY co.id DESC ' ;
		$db->setQuery($query);
		$usuaris = $db->loadObjectList();

		$import = JPluginHelper::importPlugin('invoicessearch');
		$dispatcher = JDispatcher::getInstance();
		$more_items = $dispatcher->trigger( 'onSearchContacts', array( $keywords ) );

		foreach($more_items as $component_array){

			$usuaris = array_merge($usuaris, $component_array->items );
		}

		$return = $usuaris;

		//return json
		$this->sendJSONResponse($return);
	}

	function search_items(){

		$keywords = $this->input->getString("searchword");

		$db = JFactory::getDBO();

		$return = "";

		$where_clause[] = ' ( tei.name LIKE "%'.$keywords.'%" OR tei.desc LIKE "%'.$keywords.'%" OR tei.sku LIKE "%'.$keywords.'%" ) ';

		// Build the where clause of the content record query
		$where_clause = (count($where_clause) ? ' WHERE '.implode(' AND ', $where_clause) : '');

		$query = ' SELECT tei.*, tei.desc AS description, tei.id AS product_id, "" AS component, "" AS external_type FROM #__invoices_templateitems as tei ' . $where_clause ;
		$db->setQuery($query);
		$items = $db->loadObjectList();

		$import = JPluginHelper::importPlugin('invoicessearch');
		$dispatcher = JDispatcher::getInstance();
		$more_items = $dispatcher->trigger( 'onSearchItems', array( $keywords ) );

		foreach($more_items as $component_array){

			$items = array_merge($items, $component_array->items );
		}

		foreach($items as $item){
			$item->description = strip_tags($item->description) ;
		}

		$return = $items;

		//return json
		$this->sendJSONResponse($return);
	}

	function search_user(){

		$keywords = $this->input->getVar("searchword");

		$db = JFactory::getDBO();

		$return = "";

		$where_clause[] = ' ( u.name LIKE "%'.$keywords.'%" OR u.username LIKE "%'.$keywords.'%" OR u.email LIKE "%'.$keywords.'%" OR u.id LIKE "%'.$keywords.'%" ) ';

		// Build the where clause of the content record query
		$where_clause = (count($where_clause) ? ' WHERE '.implode(' AND ', $where_clause) : '');

		$query = ' SELECT u.id AS joomla_user_id, u.username, u.name, u.email FROM #__users as u ' . $where_clause . ' LIMIT 20 ';
		$db->setQuery($query);
		$usuaris = $db->loadObjectList();

		$return = $usuaris;

		//return json
		$this->sendJSONResponse($return);
	}

	function publish()
	{

		$type = $this->input->getInt('type', 1);

		if(InvoicesHelper::canEditState()){
			$model = $this->getModel('invoice');

			switch($type){
				case 1: //invoice

				if(!$model->publish()) {
					$msg = JText::_( 'ERROR_PUBLISHING_INVOICES' );
					$type = "error";
				} else {
					$msg = JText::_( 'INVOICES_PUBLISHED' );
					$type = "message";
				}

				break;
				case 2://quote

				if(!$model->publish()) {
					$msg = JText::_( 'ERROR_PUBLISHING_QUOTES' );
					$type = "error";
				} else {
					$msg = JText::_( 'QUOTES_PUBLISHED' );
					$type = "message";
				}

				break;
			}

			$this->setRedirect( 'index.php?option=com_invoices', $msg );
		}
		else {
			if($this->input->getInt('ajax')) {
				$msg = JText::_( 'JERROR_ALERTNOAUTHOR' );
				$type = "error";
			}
			else return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
		}

		if($this->input->getInt('ajax')) {
			//we fill the notification to return
			$return = new stdClass();
			$return->notifications = array();
			$return->notifications[0] = new stdClass();
			$return->notifications[0]->message = $msg;
			$return->notifications[0]->type = $type;

			//we fill the content to return
			$return->content = $model->getDataDisplay($cid) ;

			//return json
			$this->sendJSONResponse($return);
		}
	}

	function unpublish()
	{

		$type = $this->input->getInt('type', 1);

		if(InvoicesHelper::canEditState()){
			$model = $this->getModel('invoice');

			switch($type){
				case 1: //invoice

				if(!$model->unpublish()) {
					$msg = JText::_( 'ERROR_UNPUBLISHING_INVOICES' );
					$type = "error";
				} else {
					$msg = JText::_( 'INVOICES_UNPUBLISHED' );
					$type = "message";
				}

				break;
				case 2://quote

				if(!$model->unpublish()) {
					$msg = JText::_( 'ERROR_UNPUBLISHING_QUOTES' );
					$type = "error";
				} else {
					$msg = JText::_( 'QUOTES_UNPUBLISHED' );
					$type = "message";
				}

				break;
			}

			$this->setRedirect( 'index.php?option=com_invoices', $msg );
		}
		else {
			if($this->input->getInt('ajax')) {
				$msg = JText::_( 'JERROR_ALERTNOAUTHOR' );
				$type = "error";
			}
			else return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
		}

		if($this->input->getInt('ajax')) {
			//we fill the notification to return
			$return = new stdClass();
			$return->notifications = array();
			$return->notifications[0] = new stdClass();
			$return->notifications[0]->message = $msg;
			$return->notifications[0]->type = $type;

			//we fill the content to return
			$return->content = $model->getDataDisplay($cid) ;

			//return json
			$this->sendJSONResponse($return);
		}
	}

	function duplicate()
	{

		$type = $this->input->getInt('type', 1);

		$cids = $this->input->getVar( 'cid', array(0), 'default', 'array' );

		$model = $this->getModel('invoice');

		if (count( $cids )) {
			foreach($cids as $cid) {
				$model->duplicate($cid);
			}
		}

		switch($type){
			case 1: //invoice

			$msg = JText::_( 'INVOICES_DUPLICATED' );

			break;
			case 2://quote

			$msg = JText::_( 'QUOTES_DUPLICATED' );

			break;
		}

		$type = "message";

		if($this->input->getInt('ajax')) {
			//we fill the notification to return
			$return = new stdClass();
			$return->notifications = array();
			$return->notifications[0] = new stdClass();
			$return->notifications[0]->message = $msg;
			$return->notifications[0]->type = $type;

			//we fill the content to return
			$return->content = "" ;

			//return json
			$this->sendJSONResponse($return);
		}

		$this->setRedirect( 'index.php?option=com_invoices', $msg );
	}

	function send_email(){
		$mainframe = JFactory::getApplication();

		$type = $this->input->getInt('type', 1);

		$lang = JFactory::getLanguage();
		$lang->load('com_invoices', JPATH_SITE);

		$model = $this->getInvoiceModel();

		$cids = $this->input->getVar( 'cid', array(0), 'default', 'array' );

		if (count( $cids )) {
			foreach($cids as $cid) {
				$model->setId($cid) ;

				switch($type){
					case 1: //invoice

					if ($model->sendMail()) {
						$msg = JText::sprintf( 'INVOICE_SENT', $model->_data->invoice_num, $model->_data->to_email );
						$mainframe->enqueueMessage($msg);

					} else {
						$msg = JText::sprintf( 'ERROR_SENDING_INVOICE', $model->_data->invoice_num, $model->_data->to_email );
						$mainframe->enqueueMessage($msg, 'error');

					}

					break;
					case 2://quote

					if ($model->sendMail()) {
						$msg = JText::sprintf( 'QUOTE_SENT', $model->_data->invoice_num, $model->_data->to_email );
						$mainframe->enqueueMessage($msg);

					} else {
						$msg = JText::sprintf( 'ERROR_SENDING_QUOTE', $model->_data->invoice_num, $model->_data->to_email );
						$mainframe->enqueueMessage($msg, 'error');

					}

					break;
				}
			}
		}

		if($this->input->getInt('ajax')) {
			//we fill the notification to return
			$return = new stdClass();
			$return->notifications = array();
			$return->notifications = $mainframe->getMessageQueue();

			//we fill the content to return
			//this is the LAST invoice data. Only useful for one invoice at a time
			$return->content = $model->getDataDisplay($cid) ;

			//return json
			$this->sendJSONResponse($return);
		}

		$this->setRedirect( 'index.php?option=com_invoices' );
	}

    function change_status()
    {

    	$type = $this->input->getInt('type', 1);

        if(InvoicesHelper::canEditState()){
        $model = $this->getModel('invoice');

		      switch($type){
						case 1: //invoice

						if(!$model->change_status()) {
		            $msg = JText::_( 'ERROR_CHANGING_STATUS_INVOICES' );
		            $type = "error";
		        } else {
		            $msg = JText::_( 'INVOICES_CHANGED_STATUS' );
		            $type = "message";
		        }

						break;
						case 2://quote

						if(!$model->change_status()) {
		            $msg = JText::_( 'ERROR_CHANGING_STATUS_QUOTES' );
		            $type = "error";
		        } else {
		            $msg = JText::_( 'QUOTES_CHANGED_STATUS' );
		            $type = "message";
		        }

						break;
					}

            $this->setRedirect( 'index.php?option=com_invoices', $msg );
        }
        else{
        	$msg = JText::_( 'JERROR_ALERTNOAUTHOR' );
            $type = "error";
        }

        //we fill the notification to return
				$return = new stdClass();
				$return->notifications = array();
				$return->notifications[0] = new stdClass();
				$return->notifications[0]->message = $msg;
				$return->notifications[0]->type = $type;

				//we fill the content to return
				$return->content = $model->getDataDisplay() ;

				//return json
				$this->sendJSONResponse($return);
    }

    function convert_to_invoice()
	{

		$cids = $this->input->getVar( 'cid', array(0), 'default', 'array' );

		$model = $this->getModel('invoice');

		if (count( $cids )) {
			foreach($cids as $cid) {
				$model->duplicate($cid, 1);
			}
		}

		$msg = JText::_( 'QUOTES_CONVERTED_TO_INVOICE' );
		$type = "message";

		if($this->input->getInt('ajax')) {
			//we fill the notification to return
			$return = new stdClass();
			$return->notifications = array();
			$return->notifications[0] = new stdClass();
			$return->notifications[0]->message = $msg;
			$return->notifications[0]->type = $type;

			//we fill the content to return
			$return->content = "" ;

			//return json
			$this->sendJSONResponse($return);
		}

		$this->setRedirect( 'index.php?option=com_invoices&controller=invoices', $msg );
	}

	function getInvoiceModel()
	{
		return InvoicesHelper::getInvoiceAdminModel();
	}

	function get_invoice_data(){

		$params = JComponentHelper::getParams( 'com_invoices' );

		$model = $this->getModel('invoice');

		$invoice = $model->getData();

		return $invoice;
	}

	function get_invoice(){

		$invoice = $this->get_invoice_data();

		//return json
		$this->sendJSONResponse($return);
	}

	function get_history(){

		$id = $this->input->getInt('id');

		$statsitems = array();

		if(file_exists(JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_contentstats'.DS.'helpers'.DS.'helpers.php')){
			$statsparams = JComponentHelper::getParams( 'com_contentstats' );

			require_once( JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_contentstats'.DS.'helpers'.DS.'helpers.php' );
			require_once( JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_contentstats'.DS.'models'.DS.'items.php' );
			require_once( JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_contentstats'.DS.'views'.DS.'items'.DS.'view.html.php');

			$statsmodel = new StatsModelItems;
			$statsview = new StatsViewItems;

			$statsitems = ContentstatsHelper::getItems("com_invoices", $id);

			$statsview->types = $statsmodel->getTypes();
			$statsview->icons = $statsmodel->getIcons();
			$statsview->countrynames = $statsview->countries() ;

			$hours = $statsparams->get('hours', '+00:00');

			for ($i=0; $i < count($statsitems); $i++) {
				$row = &$statsitems[$i];
				$row->icon = $statsview->icons[$row->component][$row->type];
				$row->typename = $statsview->types[$row->component][$row->type] ? str_replace("invoice", strtolower('invoice'), $statsview->types[$row->component][$row->type]) : $row->type ;
				$row->itemname =	$statsview->item_name($row->component, $row->type, $row->reference_id, $row->id);
				$row->countryflagsrc = JHTML::image('/administrator/components/com_contentstats/assets/images/flags/'.strtolower($row->country).'.png', '', null, false, true);
				$row->state = ucwords(strtolower($row->state));
				$row->city = ucwords(strtolower($row->city));

				if(isset($statsview->countrynames[$row->country])) $row->countryname = $statsview->countrynames[$row->country] ;
	      else $row->countryname = "";

				$row->countryname = ucwords(strtolower($row->countryname));

				if($row->ip == "::1" || $row->ip == "127:0:0:1") $row->ip = JText::_('localhost');

				if(!$row->user_id) $row->username = JText::_('UNREGISTERED');

				$date = JFactory::getDate($row->date_event);
	      $date_format = $date->toISO8601();
	      $date_format = substr($date_format, 0, strpos($date_format, "+")) . $hours;

				$row->date_event = $date_format;

			}
		}

		$return = new stdClass();
		$return->notifications = array();

		//we fill the content to return
		$return->content = $statsitems ;

		//return json
		$this->sendJSONResponse($return);
	}

}
