var invoicepreview_component = Vue.extend({
  template: '#preview-vue-template',
  props: ["invoice"],
  computed: {

    username_id: function(){
      if(parseInt(this.invoice.joomla_user_id)) return this.invoice.username + " [" + this.invoice.joomla_user_id + "]";
      else return "";
    },
    status_name: function(){
      return translate(this.invoice.getStatus().toUpperCase());
    },

    status_class: function(){

      var status = "default";

      switch(this.invoice.getStatus()){
        case "paid": case "payed": case "accepted": case "accepted_client":
        status = "success" ;
        break;
        case "pending":case "partial_paid":
        status = "warning" ;
        break;
        case "pastdue": case "rejected": case "rejected_client":
        status = "danger" ;
        break;
        case "refunded": case "partial_refunded": case "cancelled": case "expired":
        status = "inverse" ;
        break;
        case "corrected":
        status = "info" ;
        break;
        default:
        status = "default" ;
        break;
      }

      return status;

    },

    paynow_button: function(){
      var payments = this.getUnpaidPayments();
      var amount = 0;

      if(typeof payments[0] !== 'undefined'){
        if(parseInt(payments[0].payment_amount) > 0){
          amount = payments[0].payment_amount;

          var paynow_button = "<a href='"+payments[0].payment_link+"' target='_blank' class='btn btn-large btn-lg btn-block btn-success '>" + translate('PAY_NOW_AMOUNT_BUTTON') + format_number(amount, this.invoice.currency_id) + "</a>";
          return paynow_button;
        }
      }

      return "";

    },

    accept_button: function(){

      var link = im_base+im_extrabase+'/index.php?option=com_invoices&task=accept_quote&id=' + this.invoice.id + '&auth_code=' + this.invoice.auth_code;

      return "<a href='"+link+"' target='_blank' class='btn btn-lg btn-large btn-success '>" + translate('ACCEPT_QUOTE') + "</a>";

    },

    reject_button: function(){

      var link = im_base+im_extrabase+'/index.php?option=com_invoices&task=reject_quote&id=' + this.invoice.id + '&auth_code=' + this.invoice.auth_code;

      return "<a href='"+link+"' target='_blank' class='btn btn-lg btn-large btn-danger '>" + translate('REJECT_QUOTE') + "</a>";

    },

  },
  methods: {

    numSelectedItems: function(){

      var num = this.invoice.items.filter(function(item, index){return item.selected}).length;
      this.invoice.numSelectedItems = num;
      return num;

    },
    numSelectedPayments: function(){

      return this.invoice.payments.filter(function(item, index){return item.selected}).length;

    },
    getPaidPayments: function(){
      var payments = [];
      for (var i = 0; i < this.invoice.payments.length; i++) {
        if(this.invoice.payments[i].payment_status == 1){
          payments.push(this.invoice.payments[i]);
        }
      }
      return payments;
    },
    getUnpaidPayments: function(){
      var payments = [];
      for (var i = 0; i < this.invoice.payments.length; i++) {
        if(this.invoice.payments[i].payment_status != 1){
          payments.push(this.invoice.payments[i]);
        }
      }
      return payments;
    },

    nl2br: function(str){
      var breakTag = '<br />';
      return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1' + breakTag + '$2');
    }


  },
  mounted: function(){
  }
});
