<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

defined('_JEXEC') or die('Restricted access');

$params = JComponentHelper::getParams( 'com_invoices' );

$modalname = "";
$task = "";
$modal = false;

if($this->input->getInt('modal')){
  $modal = true;
  $modalname = "_modal";
  $task = "save";
}

?>
<?php if($modal){ ?>
<script type="text/javascript">

jQuery(document).ready(function() {
  var options = {
          //target:        '#output1',   // target element(s) to be updated with server response
          beforeSubmit:  showRequest<?php echo $modalname; ?>,  // pre-submit callback
          success:       showResponse<?php echo $modalname; ?>  // post-submit callback

          // other available options:
          //url:       url         // override for form's 'action' attribute
          //type:      type        // 'get' or 'post', override for form's 'method' attribute
          //dataType:  null        // 'xml', 'script', or 'json' (expected server response type)
          //clearForm: true        // clear all form fields after successful submit
          //resetForm: true        // reset the form after successful submit

          // $.ajax options can be used here too, for example:
          //timeout:   3000
        };

      // bind form using 'ajaxForm'
      jQuery('#adminForm<?php echo $modalname; ?>').ajaxForm(options);
    });

</script>
<?php } ?>

<div class=" invoice-manager">
  <form action="index.php" method="post" name="adminForm<?php echo $modalname; ?>" id="adminForm<?php echo $modalname; ?>" enctype="multipart/form-data" class="form-horizontal">

    <div class="form-group">
      <label class="control-label col-md-3" for="payment_amount"> <?php echo JText::_( 'AMOUNT' ); ?> </label>
      <div class="controls col-md-9">

        <div class="input-group">
          <span class="input-group-addon currency_before"><?php echo $this->payment->currency_before;?></span>
          <input class="form-control " type="text" name="payment_amount" id="payment_amount" size="10" maxlength="250" value="<?php echo $this->payment->payment_amount;?>" />
          <span class="input-group-addon currency_after"><?php echo $this->payment->currency_after;?></span>
        </div>

      </div>
    </div>
    <div class="form-group">
      <label class="control-label col-md-3" for="created_datetime"> <?php echo JText::_( 'PAYMENT_CREATION' ); ?> </label>
      <div class="controls col-md-9">

        <div class="input-group" >
          <input  class="form-control "
          type="text"
          name="created_datetime"
          id="created_datetime"
          data-date-format="yyyy-mm-dd"
          value="<?php echo $this->payment->created_datetime;?>"
          placeholder="<?php echo JText::_( 'PAYMENT_CREATION' ); ?>"/>

          <span class="input-group-btn">
            <span class="btn btn-default" id="created_datetime_btn"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
          </span>
        </div>
      </div>
    </div>

    <script type="text/javascript">

    jQuery('#created_datetime').datepicker().on('changeDate', function(ev) {
      jQuery('#created_datetime').datepicker('hide');
    });

    jQuery("#created_datetime_btn").click(function() {
      jQuery('#created_datetime').datepicker('show');
    });

    </script>

    <div class="form-group">
      <label class="control-label col-md-3" for="payment_duedate"> <?php echo JText::_( 'DUE_DATE' ); ?> </label>
      <div class="controls col-md-9">

        <div class="input-group" >
          <input  class="form-control "
          type="text"
          name="payment_duedate"
          id="payment_duedate"
          data-date-format="yyyy-mm-dd"
          value="<?php echo $this->payment->payment_duedate;?>"
          placeholder="<?php echo JText::_( 'DUE_DATE' ); ?>"/>

          <span class="input-group-btn">
            <span class="btn btn-default" id="payment_duedate_btn"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
          </span>
        </div>
      </div>
    </div>

    <script type="text/javascript">

    jQuery('#payment_duedate').datepicker().on('changeDate', function(ev) {
      jQuery('#payment_duedate').datepicker('hide');
    });

    jQuery("#payment_duedate_btn").click(function() {
      jQuery('#payment_duedate').datepicker('show');
    });

    </script>

    <div class="form-group">
      <label class="control-label col-md-3" for="payment_datetime"> <?php echo JText::_( 'PAYMENT_DATETIME' ); ?> </label>
      <div class="controls col-md-9">

        <div class="input-group" >
          <input  class="form-control "
          type="text"
          name="payment_datetime"
          id="payment_datetime"
          data-date-format="yyyy-mm-dd"
          value="<?php echo $this->payment->payment_datetime;?>"
          placeholder="<?php echo JText::_( 'PAYMENT_DATETIME' ); ?>"/>

          <span class="input-group-btn">
            <span class="btn btn-default" id="payment_datetime_btn"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
          </span>
        </div>
      </div>
    </div>

    <script type="text/javascript">

    jQuery('#payment_datetime').datepicker().on('changeDate', function(ev) {
      jQuery('#payment_datetime').datepicker('hide');
    });

    jQuery("#payment_datetime_btn").click(function() {
      jQuery('#payment_datetime').datepicker('show');
    });

    </script>

    <div class="form-group">
      <label class="control-label col-md-3" > <?php echo JText::_( 'PAID' ); ?> </label>
      <div class="controls col-md-9">
        <div class=" btn-group" data-toggle="buttons">
          <label class="btn btn-default <?php if($this->payment->payment_status == 1) echo "active"; ?>" for="payment_status1"> <?php echo JText::_('JYES'); ?> <input class="radio_toggle" type="radio" <?php if($this->payment->payment_status == 1) echo "checked='checked'"; ?> value="1" name="payment_status" id="payment_status1" autocomplete="off" /></label>
          <label class="btn btn-default <?php if($this->payment->payment_status == 0) echo "active"; ?>" for="payment_status0"> <?php echo JText::_('JNO'); ?> <input class="radio_toggle" type="radio" <?php if($this->payment->payment_status == 0) echo "checked='checked'"; ?> value="0" name="payment_status" id="payment_status0" autocomplete="off" /></label>
          <label class="btn btn-default <?php if($this->payment->payment_status == 2) echo "active"; ?>" for="payment_status2"> <?php echo JText::_('PENDING'); ?> <input class="radio_toggle" type="radio" <?php if($this->payment->payment_status == 2) echo "checked='checked'"; ?> value="2" name="payment_status" id="payment_status2" autocomplete="off" /></label>
        </div>
      </div>
    </div>

    <div class="form-group">
      <label class="control-label col-md-3" for="payment_description"> <?php echo JText::_( 'PAYMENT_DESCRIPTION' ); ?></label>
      <div class="controls col-md-9">
        <textarea name="payment_description" id="payment_description" class="form-control" cols="40" rows="4"><?php echo $this->payment->payment_description; ?></textarea>
      </div>
    </div>
    <div class="form-group">
      <label class="control-label col-md-3" for="payment_type"> <?php echo JText::_( 'PAYMENT_METHOD' ); ?></label>
      <div class="controls col-md-9">
        <input class="form-control" type="text" name="payment_type" id="payment_type" size="40" maxlength="250" value="<?php echo $this->payment->payment_type;?>" />
      </div>
    </div>
    <div class="form-group">
      <label class="control-label col-md-3" for="payment_details"> <?php echo JText::_( 'PAYMENT_DETAILS' ); ?></label>
      <div class="controls col-md-9">
        <textarea name="payment_details" id="payment_details" class="form-control" cols="40" rows="10"><?php echo $this->payment->payment_details; ?></textarea>
      </div>
    </div>
    <div class="form-group">
      <label class="control-label col-md-3" for="vincular_cliente_checkbox"> <?php echo JText::_( 'INVOICE' ); ?></label>
      <div class="controls col-md-3">
        <input type="text" class=" form-control disabled" disabled="disabled" id="name_invoice" size="40" value="<?php if($this->payment->invoice_id) echo "[".$this->payment->invoice_num . "] ".$this->payment->name." (".$this->payment->username.")"; ?>" />

      </div>
      <div class="controls col-md-2">
        <input class="form-control" type="text" name="invoice_id" id="invoice_id" size="4" maxlength="11" value="<?php echo $this->payment->invoice_id;?>" />
      </div>

      <div class="controls col-md-4">

        <input class="form-control" type="text" name="search_invoice" id="search_invoice"  value="" placeholder="<?php echo JText::_('TYPE_TO_SEARCH'); ?>" />

      </div>

    </div>

    <input type="hidden" name="option" value="com_invoices" />
    <input type="hidden" name="id" value="<?php echo $this->payment->id; ?>" />
    <input type="hidden" name="task" value="save" />
    <input type="hidden" name="controller" value="payment" />
    <input type="hidden" name="from" value="<?php echo $this->input->get('from'); ?>" />
    <?php if($modal){ ?>
    <input type="hidden" name="ajax" id="ajaxfield" value="1" />
    <?php } ?>
  </form>
</div>

<script id="invoice-suggestion-template" type="text/x-handlebars-template"  >
<?php echo $this->loadTemplate('invoice_result_template'); ?>
</script>

<script type="text/javascript">

var invoicesBloodhound = new Bloodhound({
  datumTokenizer: Bloodhound.tokenizers.obj.whitespace('name'),
  queryTokenizer: Bloodhound.tokenizers.whitespace,
  limit: 10,

  remote: {
    url: 'index.php?option=com_invoices&controller=payment&task=search_invoice&searchword=%QUERY',
    wildcard: '%QUERY'
  }
});

/**
 * Initializes the typeahead
 */
 function initializeInvoiceSuggestionTypeahead() {
  invoicesBloodhound.initialize();

  jQuery('#search_invoice').typeahead(null, {
    name: 'invoices',
    displayKey: 'name',
    source: invoicesBloodhound.ttAdapter(),
    templates: {
      suggestion: Handlebars.compile(jQuery("#invoice-suggestion-template").html())
    }
  }).on('typeahead:select', function(ev, suggestion) {
    load_invoice(suggestion);
  });
}

initializeInvoiceSuggestionTypeahead();

</script>
