<?php
/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

jimport( 'joomla.application.component.view');

/**
 * HTML Article View class for the Content component
 *
 * @package		Joomla
 * @subpackage	Content
 * @since 1.5
 */
class InvoicesViewInvoice extends JViewLegacy
{
	function display($tpl = null)
	{
		$mainframe = JFactory::getApplication();
		
		$pathway	= $mainframe->getPathway();
		$document	= JFactory::getDocument();
		$uri	= JFactory::getURI();
		
		$this->invoice		= $this->get( 'Data');
		$this->template		= $this->get( 'Template');
		$this->items		= $this->get( 'Items');
		$this->taxes		= $this->get( 'Taxes');
		
		$params = JComponentHelper::getParams( 'com_invoices' );
		
		// set document information
		//$document->setTitle($article->title);
		//$document->setName($article->alias);
		//$document->setDescription($article->metadesc);
		//$document->setMetaData('keywords', $article->metakey);

		// prepare header lines
		//$document->setHeader($this->_getHeaderText($invoice, $params));
		require(JPATH_SITE . DS . 'components' . DS . 'com_invoices' . DS . 'views' . DS . 'invoice' . DS . 'tmpl' . DS . 'default.php' );
		//echo $invoice->to_name;
	}

	function _getHeaderText(& $article, & $params)
	{
		// Initialize some variables
		$text = '';

		// Display Author name
		if ($params->get('show_author')) {
			// Display Author name
			$text .= "\n";
			$text .= JText::sprintf( 'Written by', ($article->created_by_alias ? $article->created_by_alias : $article->author) );
		}

		if ($params->get('show_create_date') && $params->get('show_author')) {
			// Display Separator
			$text .= "\n";
		}

		if ($params->get('show_create_date')) {
			// Display Created Date
			if (intval($article->created)) {
				$create_date = JHTML::_('date', $article->created, JText::_('DATE_FORMAT_LC2'));
				$text .= $create_date;
			}
		}

		if ($params->get('show_modify_date') && ($params->get('show_author') || $params->get('show_create_date'))) {
			// Display Separator
			$text .= " - ";
		}

		if ($params->get('show_modify_date')) {
			// Display Modified Date
			if (intval($article->modified)) {
				$mod_date = JHTML::_('date', $article->modified, JText::_('DATE_FORMAT_LC2'));
				$text .= JText::_('Last Updated').' '.$mod_date;
			}
		}
		return $text;
	}
}
?>