<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

jimport( 'joomla.application.component.view');
jimport( 'joomla.html.html');

use Dompdf\Dompdf;
use Dompdf\Options;

class InvoicesViewInvoice extends JViewLegacy
{

	function display($tpl = null)
	{
		require_once(JPATH_SITE.DS.'components'.DS.'com_invoices'.DS.'helpers'.DS.'dompdf'.DS.'autoload.inc.php');

		if(file_exists(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'html'.DS.'html.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'html'.DS.'html.php');
		elseif(file_exists(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'html.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'html.php');

		if(file_exists(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'date'.DS.'date.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'date'.DS.'date.php');
		elseif(file_exists(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'date.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'date.php');

		$mainframe = JFactory::getApplication();

		$document	= JFactory::getDocument();
		$uri	= JFactory::getURI();

		$invoice		= $this->get( 'Data');
		$template		= $this->get( 'Template');
		$items		= $this->get( 'Items');
		$taxes		= $this->get( 'Taxes');
		$payments		= $this->get( 'Payments');
		$payments2		= $this->get( 'Payments2');

		$params = JComponentHelper::getParams( 'com_invoices' );

		if($template->content_pdf) $template->content = $template->content_pdf ;

		$this->assignRef('invoice',		$invoice);
		$this->assignRef('template',		$template);
		$this->assignRef('items',		$items);
		$this->assignRef('taxes',		$taxes);
		$this->assignRef('payments',		$payments);
		$this->assignRef('payments2',		$payments2);

		$this->assignRef('params',		$params);

		$plantilla = 'email' ;

		$html = $this->loadTemplate($plantilla);

		$search = array("€", "¢", "£", "¤", "¥");
		$replace = array("&euro;", "&cent;", "&pound;", "&curren;", "&yen;");

		$html = str_replace($search, $replace, $html);

		$html = mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8');

		$html = utf8_decode($html);

		$html = '<!DOCTYPE HTML>
				<html>
				<body>
				<style>
				'.$this->template->styles.'
				</style>'
				. $html .
				'</body></html>';

		$options = new Options();
		$options->set( 'isRemoteEnabled', TRUE );

		$dompdf = new Dompdf($options);
		$dompdf->set_paper('a4');
		$dompdf->load_html($html);
		$dompdf->render();
		$dompdf->stream($invoice->invoice_num . ".pdf");

		//trigger event
		$import = JPluginHelper::importPlugin( 'invoices' );
		$dispatcher = JDispatcher::getInstance();
		$dispatcher->trigger( 'onExportPDFInvoice', array( $invoice ) );

		exit();
	}

}
?>
