<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.joomlathat.com
# Technical Support:  Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.'); 

?>

<div class="form-group">
  <label class="control-label col-md-3" > <?php echo JText::_( 'IS_RECURRENT' ); ?> </label>
  <div class="controls col-md-9">
    <div class=" btn-group" data-toggle="buttons">
      <label class="btn btn-default <?php if($this->invoice->is_recurrent) echo "active"; ?>" for="recurrent1"> <?php echo JText::_('JYES'); ?> <input class="radio_toggle" type="radio" <?php if($this->invoice->is_recurrent) echo "checked='checked'"; ?> value="1" name="is_recurrent" id="recurrent1" autocomplete="off" /></label>
      <label class="btn btn-default <?php if(!$this->invoice->is_recurrent) echo "active"; ?>" for="recurrent0"> <?php echo JText::_('JNO'); ?> <input class="radio_toggle" type="radio" <?php if(!$this->invoice->is_recurrent) echo "checked='checked'"; ?> value="0" name="is_recurrent" id="recurrent0" autocomplete="off" /></label>
    </div>
  </div>
</div>

<div class="form-group">
  <label class="control-label col-md-3" for="rec_nextdate_<?php echo $this->invoice->id; ?>"> <?php echo JText::_( 'NEXT_RECURRENCY_DATE'); ?> </label>
  <div class="controls col-md-9">
   <div class="input-group" >
    <input  class="form-control " 
    type="text" 
    name="rec_nextdate" 
    id="rec_nextdate_<?php echo $this->invoice->id; ?>" 
    data-date-format="yyyy-mm-dd"
    value="<?php echo $this->invoice->rec_nextdate;?>" 
    placeholder="<?php echo JText::_( 'NEXT_RECURRENCY_DATE' ); ?>"/>

    <span class="input-group-btn">
      <span class="btn btn-default" id="rec_nextdate_btn_<?php echo $this->invoice->id; ?>"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
    </span>
    </div>
  </div>
  <span class="help-block col-md-offset-3 col-md-9"><?php echo JText::_('NEXT_RECURRENCY_DATE_EXPLANATION'); ?></span>
</div>

<script type="text/javascript">

jQuery('#rec_nextdate_<?php echo $this->invoice->id; ?>').datepicker().on('changeDate', function(ev) {
  jQuery('#rec_nextdate_<?php echo $this->invoice->id; ?>').datepicker('hide');
});

jQuery("#rec_nextdate_btn_<?php echo $this->invoice->id; ?>").click(function() {
  jQuery('#rec_nextdate_<?php echo $this->invoice->id; ?>').datepicker('show');
});

</script>

<div class="form-group">
  <label class="control-label col-md-3" > <?php echo JText::_( 'REPEAT_EVERY' ); ?> </label>
  <div class="controls col-md-6">
    <div class="row">
      <div class="col-xs-4">
        <select name="rec_day" id="rec_day" class="form-control">  
          <?php
          for ($i=0;$i < 31; $i++)  {

            $selected = ""; 
            if($i == $this->invoice->rec_day) $selected = "selected"; ?>
            <option <?php echo $selected;?> value="<?php echo $i; ?>"><?php echo $i ;?></option>
            <?php } ?>
          </select>
          <span class="help-block"><?php echo JText::_('REPEAT_EXPLANATION_DAYS'); ?></span>
        </div>
        <div class="col-xs-4">
          <select name="rec_month" id="rec_month" class="form-control">
           
            <?php
            for ($i=0;$i < 12; $i++)  {

              $selected = ""; 
              if($i == $this->invoice->rec_month) $selected = "selected"; ?>
              <option <?php echo $selected;?> value="<?php echo $i; ?>"><?php echo $i ;?></option>
              <?php } ?>
            </select> 
            <span class="help-block"><?php echo JText::_('REPEAT_EXPLANATION_MONTHS'); ?></span>
          </div>
          <div class="col-xs-4">
            <select name="rec_year" id="rec_year" class="form-control">
            <?php
            for ($i=0;$i < 11; $i++)  {

              $selected = ""; 
              if($i == $this->invoice->rec_year) $selected = "selected"; ?>
              <option <?php echo $selected;?> value="<?php echo $i; ?>"><?php echo $i ;?></option>
              <?php } ?>
            </select> 
            <span class="help-block"><?php echo JText::_('REPEAT_EXPLANATION_YEARS'); ?></span>
            </div>
          </div>
        </div>
        
      </div>

      <div class="form-group">
        <label class="control-label col-md-3" > <?php echo JText::_( 'SEND_EMAIL_RECURRING' ); ?> </label>
        <div class="controls col-md-9">
          <div class=" btn-group" data-toggle="buttons">
            <label class="btn btn-default <?php if($this->invoice->rec_email) echo "active"; ?>" for="rec_email1"> <?php echo JText::_('JYES'); ?> <input class="radio_toggle" type="radio" <?php if($this->invoice->rec_email) echo "checked='checked'"; ?> value="1" name="rec_email" id="rec_email1" /></label>
            <label class="btn btn-default <?php if(!$this->invoice->rec_email) echo "active"; ?>" for="rec_email0"> <?php echo JText::_('JNO'); ?> <input class="radio_toggle" type="radio" <?php if(!$this->invoice->rec_email) echo "checked='checked'"; ?> value="0" name="rec_email" id="rec_email0" /></label>
          </div>
        </div>
      </div>
      