<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.'); 
$document = JFactory::getDocument();
?>

<div class="inner-buttonbar" >
  <button class="btn btn-primary " type="button" onclick="new_item();return false;" ><span class="glyphicon glyphicon-plus"></span> <?php echo JText::_('ADD_NEW_ITEM'); ?></button>
  <button class="btn btn-danger pull-right " disabled="disabled" type="button" onclick="delete_selected_items();return false;" id="delete_items_button" ><i class="glyphicon glyphicon-trash"></i> <?php echo JText::_('DELETE_SELECTED_ITEMS'); ?></button>
</div>

<div id="showalerts">
<?php foreach($this->taxes as $tax){ ?>
  <div class="alert alert-warning" id="tax_alert_<?php echo $tax->id; ?>" style="display:none;"><strong><?php echo JText::_( 'WARNING' ); ?></strong> <?php echo JText::sprintf( 'WARNING_DUPLICITY', $tax->name ); ?></div>
<?php } ?>
</div>

<table class="table table-striped table-hover" id="items_table">
  <thead>
    <tr class="nodrag">
      <th width="20"></th>
      <th width="" > <span class="th_value"><?php echo JText::_( 'VALUE' ); ?></span> <span class="th_qty"><?php echo JText::_( 'QUANTITY' ); ?></span> <span class="th_discount"><?php echo JText::_( 'DISCOUNT' ); ?></span> <span class="th_tax"><?php echo JText::_( 'TAX' ); ?></span> </th>
      <th width="160"> <?php echo JText::_( 'TOTAL' ); ?> </th>
    </tr>
  </thead>

  <tfoot>

    <tr class="nodrag">
      <td></td>
      <td class="invoice_discount"><?php echo JText::_( $this->layout_type.'_DISCOUNT' ); ?></td>
      <td>
        <div class="input-group">
          <span class="input-group-addon currency_before"><?php echo $this->invoice->currency_before;?></span>
          <input class="form-control input-mini "  onchange="calculate_lines()"  onkeyup="calculate_lines()" placeholder="<?php echo JText::_( 'ZERO_AMOUNT' ); ?>" type="number" id="discount" name="discount" maxlength="10" value="<?php echo InvoicesHelper::format_editing($this->invoice->discount);?>" />
          <span class="input-group-addon currency_after"><?php echo $this->invoice->currency_after;?></span>
        </div>
      </td>
    </tr>

    <tr class="nodrag">
      <td></td>
      <td class="invoice_subtotal"><?php echo JText::_( $this->layout_type.'_SUBTOTAL' ); ?></td>
      <td>
        <div class="input-group">
          <span class="input-group-addon currency_before"><?php echo $this->invoice->currency_before;?></span>
          <input class="form-control input-mini " readonly type="text" id="invoice_subtotal" maxlength="10" value="" />
          <span class="input-group-addon currency_after"><?php echo $this->invoice->currency_after;?></span>
        </div>
      </td>
    </tr>

    <?php
    $js = "var taxes = new Array(); var taxestype = new Array(); var taxescalculateon = new Array();";

    for ($i=0, $n=count( $this->taxes );$i < $n; $i++)	{
      $row = &$this->taxes[$i];
      $selected = ""; 

      if($row->type == "percent") $percent = "%" ;
      else $percent = "";

      $js .= "taxes[".$row->id."] = '".$row->value.$percent."'; " ;
      $js .= "taxestype[".$row->id."] = '".$row->ordering."'; " ;
      $js .= "taxescalculateon[".$row->id."] = '".$row->calculate_on."'; " ;

      if($row->active) $selected = "checked='checked'";
      ?>
      <tr class="nodrag">
        <td></td>
        <td class="invoice_tax">

          <div class="row">
            <div class="col-xs-8">
              <label for="tax_<?php echo $row->id;?>" class="control-label"><?php echo $row->name;?></label>
            </div>
            <div class="col-xs-4">
              <div class="input-group">
                <span class="input-group-addon">
                  <input type="checkbox" <?php echo $selected;?> onchange="calculate_lines()" class="checkbox_tax" name="taxes[]" value="<?php echo $row->id;?>" id="tax_<?php echo $row->id;?>" data-type="<?php echo $row->type;?>" />
                </span>
                <input class="form-control input-mini" type="number" onchange="calculate_lines()" id="tax_value_<?php echo $row->id;?>" name="tax_value_<?php echo $row->id;?>" maxlength="10" value="<?php echo $row->tax_value;?>" placeholder="<?php echo JText::_( 'ZERO_AMOUNT' ); ?>" />
                <span class="input-group-addon"><?php echo $percent ? $percent : "&nbsp;" ?></span>
              </div>
            </div>
          </div>

        </td>
       <td>
        <div class="input-group">
          <span class="input-group-addon currency_before"><?php echo $this->invoice->currency_before;?></span>
          <input class="form-control input-mini " readonly type="text" id="tax_display_<?php echo $row->id;?>" maxlength="10" value="" />
          <span class="input-group-addon currency_after"><?php echo $this->invoice->currency_after;?></span>
        </div>
      </td>
  </tr>

  <?php } ?>

  <script type="text/javascript">
  <?php echo $js; ?>
  </script>

    <tr class="nodrag">
      <td></td>
      <td class="invoice_total"><?php echo JText::_( $this->layout_type.'_TOTAL' ); ?></td>
      <td>
        <div class="input-group">
          <span class="input-group-addon currency_before"><?php echo $this->invoice->currency_before;?></span>
          <input class="form-control input-mini " readonly  type="text" id="invoice_total" maxlength="10" value="" />
          <span class="input-group-addon currency_after"><?php echo $this->invoice->currency_after;?></span>
        </div>
      </td>
    </tr>
  </tfoot>

<tbody id="items-body">
  <?php
  $k = 0;
  for ($i=0, $n=count( $this->items ); $i < $n; $i++)	{
    $item = &$this->items[$i];
    $checked 	= JHTML::_('grid.id',   $i, $item->id );

    //taxes for v 2.1
    $taxrows = "";
    $selected_tax = JText::_('JNO');

    for ($j=0, $m=count( $this->taxes );$j < $m; $j++)  {
        $row = &$this->taxes[$j];
        
        if($row->id == $item->tax_id) $selected_tax = $row->name;
       
      $taxrows .= '<li><a class="noHrefLink" onclick="set_item_tax('.$item->id.','.$row->id.',jQuery(this))">'.$row->name.'</a></li>';
    }

    ?>
    <tr id="itemrow<?php echo $item->id;?>">

      <td><div class="checkbox"><input type="checkbox" id="icb<?php echo $item->id;?>" name="iid[]" value="<?php echo $item->id;?>" /></div>

        <input type="hidden" name="external_type_<?php echo $item->id;?>" id="external_type_<?php echo $item->id;?>" value="<?php echo $item->external_type;?>" />
        <input type="hidden" name="product_id_<?php echo $item->id;?>" id="product_id_<?php echo $item->id;?>" value="<?php echo $item->product_id;?>" />
        <input type="hidden" class="tax_id_input" name="tax_id_<?php echo $item->id;?>" id="tax_id_<?php echo $item->id;?>" value="<?php echo $item->tax_id;?>" />
      </td>

      <td class="form-horizontal">

        <div class="input-group">
         <input class="form-control input-mini items_value" onchange="calculate_lines()" type="number" placeholder="<?php echo JText::_('VALUE');?>" name="value_<?php echo $item->id;?>" id="value_<?php echo $item->id;?>" maxlength="10" value="<?php echo InvoicesHelper::format_editing($item->value);?>" />
         <span class="input-group-addon ">x</span>
         <input class="form-control input-mini items_amount" onchange="calculate_lines()" type="number" placeholder="<?php echo JText::_('QTY');?>" name="amount_<?php echo $item->id;?>" id="amount_<?php echo $item->id;?>"  maxlength="10" value="<?php echo $item->amount;?>" />
         <span class="input-group-addon ">-</span>
         <input class="form-control input-mini items_discount" onchange="calculate_lines()" type="number" placeholder="<?php echo JText::_('DISCOUNT');?>" name="discount_<?php echo $item->id;?>" id="discount_<?php echo $item->id;?>"  maxlength="10" value="<?php echo InvoicesHelper::format_editing($item->discount);?>" />
         <span class="input-group-addon ">+</span>

         <div class="input-group-btn tax-selector-dropdown">
            <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><span class="tax-selector-title"><?php echo $selected_tax;?></span> <span class="caret"></span></button>
            <ul class="dropdown-menu">
              <li><a class="noHrefLink" onclick="set_item_tax(<?php echo $item->id;?>,0,jQuery(this))"><?php echo JText::_('JNO');?></a></li>
              <?php echo $taxrows; ?>
            </ul>
          </div>

         <input class="form-control input-mini items_tax" onchange="calculate_lines()" type="number" placeholder="<?php echo JText::_('TAX');?>" name="tax_<?php echo $item->id;?>" id="tax_<?php echo $item->id;?>" maxlength="10" value="<?php echo InvoicesHelper::format_editing($item->tax);?>" />
         <span class="input-group-addon ">%</span>
       </div>

       <div class="row">
         <div class="form-group ">

          <div class="col-xs-9 name-container">
            <input class="form-control input-name" type="text" placeholder="<?php echo JText::_('NAME');?>" name="name_<?php echo $item->id;?>" id="name_<?php echo $item->id;?>" maxlength="255" value="<?php echo htmlentities($item->name); ?>" />
          </div>

          <div class="col-xs-3 sku-container">
            <input class="form-control input-mini input-sku " type="text" placeholder="<?php echo JText::_('SKU');?>" name="sku_<?php echo $item->id;?>" id="sku_<?php echo $item->id;?>" maxlength="255" value="<?php echo htmlentities($item->sku); ?>" />
          </div>

        </div>
      </div>

      <div class="form-group">
        <div class="col-xs-12 desc-container">
          <input class="form-control input-desc" type="text" placeholder="<?php echo JText::_('DESCRIPTION');?>" name="description_<?php echo $item->id;?>" id="description_<?php echo $item->id;?>" maxlength="255" value="<?php echo htmlentities($item->desc); ?>" />
        </div>

      </div>

    </td>

    <td>

      <div class="input-group"> 
        <span class="input-group-addon currency_before"><?php echo $this->invoice->currency_before;?></span>
        <input class="form-control input-mini items_total" readonly type="text" name="total_<?php echo $item->id;?>" id="total_<?php echo $item->id;?>" maxlength="10" value="" />
        <span class="input-group-addon currency_after"><?php echo $this->invoice->currency_after;?></span> 
      </div>

    </td>
  </tr>
  <?php
  $k = 1 - $k;
}
?>
</tbody>

</table>

<div class="bs-callout bs-callout-info"><span class="label label-info"><?php echo JText::_('TIP'); ?></span> <?php echo JText::_('DRAG_ROWS'); ?></div>

<script type="text/javascript">

var itemsBloodhound = new Bloodhound({
  datumTokenizer: Bloodhound.tokenizers.obj.whitespace('name'),
  queryTokenizer: Bloodhound.tokenizers.whitespace,
  limit: 10,

  remote: {
    url: 'index.php?option=com_invoices&controller=invoice&task=search_items&searchword=%QUERY',
    wildcard: '%QUERY'
  }
});

/**
 * Initializes the typeahead
 */
 function initializeItemTypeahead(input_id) {
  itemsBloodhound.initialize();

  jQuery('#' + input_id).typeahead(null, {
    name: 'items',
    displayKey: 'name',
    source: itemsBloodhound.ttAdapter(),
    templates: {
      suggestion: Handlebars.compile(jQuery("#item-suggestion-template").html())
    }
  }).on('typeahead:select', function(ev, suggestion) {
    load_item(suggestion);
  });
}

</script>

<script type="text/javascript">

calculate_lines();

jQuery("#items_table").tableDnD({dragHandle: ".dragHandle", onDragClass: "info"});

jQuery("#items_table input[name^=iid]").each( function() {

  jQuery(this).on('click', function() {

    if(check_checkboxes()) enable_delete_button();
    else disable_delete_button();

  });
});

</script>
