<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');  ?>

<?php include(JPATH_COMPONENT_ADMINISTRATOR.DS.'views'.DS.'invoices'.DS.'tmpl'.DS.'default_menu.php'); ?>

<div class="wrap push shrink invoice-manager">

<form action="index.php" method="post" name="adminForm" id="adminForm">

    <?php echo $this->loadTemplate('filter'); ?>

    <table class="table table-striped" id="im-app">
      <thead>
        <tr>
          <th width="5"> <?php echo JHTML::_( 'grid.sort', 'ID', 'tei.id', $this->lists['order_Dir'], $this->lists['order']); ?> </th>
          <th width="20"> <input type="checkbox" name="toggle" value="" onclick="Joomla.checkAll(this);" />
          </th>
          <th> <?php echo JHTML::_( 'grid.sort', 'NAME', 'currency_name', $this->lists['order_Dir'], $this->lists['order']); ?> </th>
       		<th> <?php echo JHTML::_( 'grid.sort', 'CURRENCY_SYMBOL', 'currency_symbol', $this->lists['order_Dir'], $this->lists['order']); ?> </th>
       		<th> <?php echo JHTML::_( 'grid.sort', 'CURRENCY_CODE', 'currency_code', $this->lists['order_Dir'], $this->lists['order']); ?> </th>
          <th><?php echo JText::_('FORMAT'); ?></th>
          <th width="5" class="hidden-phone"><?php echo JHTML::_( 'grid.sort', 'PUBLISHED', 'currency_published', $this->lists['order_Dir'], $this->lists['order']); ?></th>
        </tr>
      </thead>
      <?php
	$k = 0;
	for ($i=0, $n=count( $this->items ); $i < $n; $i++)	{
		$row = &$this->items[$i];
		$checked 	= JHTML::_('grid.id',   $i, $row->id );
		$link 		= JRoute::_( 'index.php?option=com_invoices&controller=currency&task=edit&cid[]='. $row->id );

    if($row->currency_published){
      $publicat = JHTML::image('administrator/components/com_invoices/assets/images/tick.png','Active');
      $link_publicat = JRoute::_('index.php?option=com_invoices&controller=currency&task=unpublish&cid[]='. $row->id);
    }
    else{
      $publicat = JHTML::image('administrator/components/com_invoices/assets/images/publish_x.png','Not Active');
      $link_publicat = JRoute::_('index.php?option=com_invoices&controller=currency&task=publish&cid[]='. $row->id);
    }

		?>
      <tr class="<?php echo "row$k"; ?>">
        <td><?php echo $row->id; ?></td>
        <td><?php echo $checked; ?></td>
        <td><a href="<?php echo $link; ?>"><?php echo $row->currency_name; ?></a></td>
        <td><?php echo $row->currency_symbol; ?></td>
        <td><?php echo $row->currency_code; ?></td>
        <td>{{ 1234567.89 | currency("<?php echo $row->symbol_before; ?>", "<?php echo $row->symbol_after; ?>", "<?php echo $row->decimals; ?>", "<?php echo $row->decpoint; ?>", "<?php echo $row->thousands; ?>", "<?php echo $row->negative_position; ?>") }}
          | {{ -1234567.89 | currency("<?php echo $row->symbol_before; ?>", "<?php echo $row->symbol_after; ?>", "<?php echo $row->decimals; ?>", "<?php echo $row->decpoint; ?>", "<?php echo $row->thousands; ?>", "<?php echo $row->negative_position; ?>") }}
        </td>
        <td align="center" class="hidden-phone"><a href="<?php echo $link_publicat; ?>"><?php echo $publicat; ?></a></td>
      </tr>
      <?php
		$k = 1 - $k;
	}
	?>
      <tfoot>
        <tr>
          <td colspan="7"><?php echo $this->pagination->getListFooter(); ?></td>
        </tr>
      </tfoot>
    </table>
  </div>
  <input type="hidden" name="option" value="com_invoices" />
  <input type="hidden" name="task" value="" />
  <input type="hidden" name="boxchecked" value="0" />
  <input type="hidden" name="controller" value="currency" />
  <input type="hidden" name="filter_order" value="<?php echo $this->lists['order']; ?>" />
  <input type="hidden" name="filter_order_Dir" value="<?php echo $this->lists['order_Dir']; ?>" />
</form>

<script>

  Vue.filter('currency', function (value, symbol_before, symbol_after, decimals, decpoint, thousands, negative_position) {
    return format_number_free(value, symbol_before, symbol_after, decimals, decpoint, thousands, negative_position);
  });

  new Vue({
    el: '#im-app',

  });

</script>
