<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

if(file_exists(JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_contentstats'.DS.'helpers'.DS.'helpers.php')){

?>
<table class="table table-striped">
  <thead>
    <tr>
      <th width="5" class="hidden-phone"> </th>
      <th > <?php echo JText::_('USER'); ?> | <?php echo JText::_('TYPE_OF_ACTION'); ?> | <?php echo JText::_('ITEM'); ?> </th>
      <th class=""> <?php echo JText::_('DATE'); ?> </th>
      <th class="hidden-phone"> <?php echo JText::_('IP'); ?> </th>
      <th class="hidden-phone"> <?php echo JText::_('COUNTRY'); ?> </th>
      <th class="hidden-phone"> <?php echo JText::_('STATE'); ?> </th>
      <th class="hidden-phone"> <?php echo JText::_('CITY'); ?> </th>
    </tr>
  </thead>
  <tbody>

    <tr v-for="(entry, index) in invoice.history">
      <td class="hidden-phone">

          <span :class="'glyphicon glyphicon-' + entry.icon"></span>

      </td>
      <td>
        <strong>{{ entry.username }}</strong>
        {{ entry.typename }}
        <strong>{{ entry.itemname }}</strong>

      </td>
      <td>
        <span ><time class="timeago" >{{ entry.date_event | relativedate }}</time></span>
      </td>

      <td class="hidden-phone muted">{{ entry.ip }}</td>
      <td class="hidden-phone"><img :src="entry.countryflagsrc" :alt="entry.country" v-show="entry.country != ''"> {{ entry.countryname }}</td>
      <td class="hidden-phone">{{ entry.state}}</td>
      <td class="hidden-phone">{{ entry.city}}</td>

  </tbody>
</table>

<p class="text-center text-muted" v-show="!invoice.history.length"><?php echo JText::_('NO_HISTORY_YET_'.$this->layout_type); ?></p>

<?php } else{
  //no CS installed ?>
<div class="alert alert-info"><?php echo JText::_('ONLY_WITH_CONTENT_STATISTICS'); ?></div>
<?php } ?>
