<?php
//no direct access
defined('_JEXEC') or die('Restricted access.'); ?>
<tr>
  <td class="edit-td edit-icon-no-padding hidden-xs" v-if="extended">

    <input  type="checkbox"
            :id="'cb' + invoice.id"
            name="cid[]"
            :value="invoice.id"
            onclick="Joomla.isChecked(this.checked);" />

  </td>

  <td class="button-column edit-column action-button text-muted " v-if="extended">
    <a  @click="invoice.edit()"
        href="#">
      <div class="name-div">
        <span class="glyphicon glyphicon-edit"></span>
      </div>
      <div class="date-div ">
        <span><?php echo JText::_('EDIT');?></span>
      </div>
    </a>
  </td>

  <td class="invoice-num " @click="invoice.preview()">
    <div class="name-div visible-xs">
      <span>{{ invoice.to_name }}</span>
    </div>

    <div class="name-div">
      <span>{{ invoice.invoice_num }}</span>
    </div>
    <div class="date-div text-muted">

      <span v-show="invoice.is_recurrent"
            class="glyphicon glyphicon-refresh"
            :title="'<?php echo JText::_('NEXT_RECURRENCY_TOOLTIP');?>' + rec_title "
            data-toggle="tooltip">
      </span>

      <span>{{ invoice.invoice_date | date }}</span>
    </div>
  </td>

  <td class="name-column contactname-column hidden-xs" @click="invoice.preview()">
    <div class="name-div">
      <span>{{ invoice.to_name }}</span>
      <span class="pull-right publish-icon"
            :class="{ 'icon-success' : invoice.publish, 'icon-danger' : !invoice.publish }"
            @click="invoice.publish ? invoice.unpublish_invoice() : invoice.publish_invoice() "
            data-toggle="tooltip"
            data-container="body"
            :title=" invoice.publish ? '<?php echo JText::_('CLICK_TO_UNPUBLISH');?>' : '<?php echo JText::_('CLICK_TO_PUBLISH');?>' ">
        <span class="glyphicon "
              :class="{ 'glyphicon-eye-open' : invoice.publish, 'glyphicon-eye-close' : !invoice.publish }"></span>
      </span>
    </div>
    <div class="date-div text-muted">
      <span>{{ invoice.username }}</span>
    </div>

  </td>

  <td class="button-column add-column action-button text-muted hidden-xs" v-if="extended">

    <a  v-show="invoice.user_id"
        @click="invoice.new()"
        data-toggle="tooltip"
        data-container="body"
        href="#"
        title="<?php echo JText::_('CREATE_INVOICE_FOR_CONTACT');?>">
      <div class="name-div">
        <span class="glyphicon glyphicon-plus"></span>
      </div>
      <div class="date-div text-muted">
        <span><?php echo JText::_('NEW');?></span>
      </div>
    </a>

  </td>

  <td width="21" class="name-column hidden-xs" >
    <div class="btn-group">
      <a class="btn btn-default btn-mini btn-xs dropdown-toggle" data-toggle="dropdown" href="#">
        <span class="caret"></span>
      </a>
      <ul class="dropdown-menu">
        <li v-for="status in $root.statuses">
          <a  class="noHrefLink"
              @click="invoice.change_status(status.id)">{{ status.name }}</a>
        </li>
      </ul>
    </div>
  </td>

  <td :class="'name-column hidden-xs status-column status-column-' + status_class"
      :id="'rendered-status_' + invoice.id">

    <div class="name-div">
      <span :class="'label label-' + status_class">{{ status_name }}</span>
    </div>
    <?php if($this->params->get('paymentscolumn')){ ?>

    <div class="date-div text-muted">

      <span v-show="!invoice.is_quote" class="num_payments label label-default " :class="{ 'label-success': invoice.paid_payments }">{{ invoice.paid_payments }}</span>
      <span v-show="!invoice.is_quote" class="num_payments label label-default " :class="{ 'label-warning': invoice.unpaid_payments_ontime }">{{ invoice.unpaid_payments_ontime }}</span>
      <span v-show="!invoice.is_quote" class="num_payments label label-default " :class="{ 'label-danger': invoice.unpaid_payments_notontime }">{{ invoice.unpaid_payments_notontime }}</span>

    </div>

    <?php } ?>

  </td>

  <?php if($this->params->get('sourcecolumn')){ ?>
  <td class="name-column hidden-xs"
      @click="invoice.preview()"
  >
    <div class="name-div">
      <span>{{ invoice.external_type }}</span>
    </div>
    <div class="date-div text-muted">
      <span>{{ invoice.external_ref }}</span>
    </div>
  </td>
  <?php } ?>

  <td class="amount-column hidden-xs"
      @click="invoice.preview()"
  >

    <div class="amount-div">
      <span>{{ invoice.subtotal_items() | currency(invoice.currency_id) }}</span>
    </div>
    <div class="date-div text-muted"></div>

  </td>

  <td v-for="thetax in invoice.taxes"
      v-show="display_tax(thetax.id)"
      class="amount-column hidden-xs" >

    <div class="amount-div"
          :class="{ 'text-muted': !invoice.tax(thetax.id) }">
      <span>{{ invoice.tax(thetax.id) | currency(invoice.currency_id) }}</span>
    </div>
    <div class="date-div text-muted">
      <span>{{ invoice.tax_percentage(thetax.id) | taxpercentage }}</span>
    </div>

  </td>

  <td class="amount-column"
      @click="invoice.preview()"
  >

    <div class="amount-div ">
      <span>{{ invoice.thetotal() | currency(invoice.currency_id) }}</span>
    </div>

    <div :class="'tax-div ' + invoice.payment_class">

      <span v-show="!invoice.is_quote">{{ invoice.totalPaid() | currency(invoice.currency_id) }}</span>

    </div>

  </td>

  <td class=" button-column action-button text-muted "
      :class="{ 'email-sent': invoice.sent }" >
    <a  @click="invoice.email()"
        data-toggle="tooltip"
        data-container="body"
        href="#"
        :title=" invoice.sent ? ('<?php echo JText::_('SENT_ON');?> ' + this.$options.filters.date(invoice.last_sent,'D MMM YYYY', '<?php echo JText::_('NOT_SENT') ?>') ) : '<?php echo JText::_('CLICK_TO_SEND');?>' ">
      <div class="name-div">
        <span class="glyphicon glyphicon-envelope"></span>
      </div>
      <div class="date-div ">
        <span>{{ invoice.last_sent | date('D MMM', "<?php echo JText::_('NOT_SENT') ?>") }}</span>
      </div>
    </a>
  </td>

  <?php if(InvoicesHelper::pdf_enabled()){ ?>
  <td class=" button-column action-button text-muted hidden-xs" >
    <a  :href="invoice.pdf_link"
        data-toggle="tooltip"
        data-container="body"
        title="<?php echo JText::_('DOWNLOAD_INVOICE_PDF');?>">
      <div class="name-div">
        <span class="glyphicon glyphicon-download-alt"></span>
      </div>
      <div class="date-div ">
        <span><?php echo JText::_('PDF');?></span>
      </div>
    </a>
  </td>
  <?php } ?>
</tr>
