<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

HTMLHelper::_('behavior.core');
HTMLHelper::_('behavior.keepalive');

if (!HelpdeskproHelper::isJoomla4())
{
	HTMLHelper::_('behavior.modal', 'a.hdp-modal');
}

$document = Factory::getDocument();
$rootUri  = Uri::root(true);

if (!$this->config->use_html_editor && $this->config->process_bb_code)
{
	$document->addScript($rootUri . '/media/com_helpdeskpro/assets/js/jquery.selection.js');
	$document->addScript($rootUri . '/media/com_helpdeskpro/assets/js/helpdeskpro.bbcode.js');
}

$document->addScript($rootUri . '/media/com_helpdeskpro/js/site-ticket-default.js');

Text::script('HDP_ENTER_COMMENT_FOR_TICKET', true);

$cbIntegration    = file_exists(JPATH_ROOT . '/components/com_comprofiler/comprofiler.php');
$editor           = Editor::getInstance(Factory::getConfig()->get('editor'));
$user             = Factory::getUser();
$maxNumberOfFiles = $this->config->max_number_attachments ? $this->config->max_number_attachments : 1;

if ($this->input->getMethod() == 'POST')
{
	$this->captchaInvalid = true;
}
else
{
	$this->captchaInvalid = false;
}

/* @var $bootstrapHelper HelpdeskProHelperBootstrap */
$bootstrapHelper     = $this->bootstrapHelper;
$formHorizontalClass = $bootstrapHelper->getClassMapping('form form-horizontal');
$rowFluidClass       = $bootstrapHelper->getClassMapping('row-fluid');
$controlGroupClass   = $bootstrapHelper->getClassMapping('control-group');
$controlLabelClass   = $bootstrapHelper->getClassMapping('control-label');
$controlsClass       = $bootstrapHelper->getClassMapping('controls');
$span3Class          = $bootstrapHelper->getClassMapping('span3');
$span9Class          = $bootstrapHelper->getClassMapping('span9');
$btnClass            = $bootstrapHelper->getClassMapping('btn');
$btnPrimaryClass     = $bootstrapHelper->getClassMapping('btn btn-primary');
?>
<h1 class="hdp_title"><?php echo Text::_('HDP_VIEW_TICKET'); ?></h1>
<div id="hdp_container" class="container-fluid">
<form action="<?php echo Route::_('index.php?option=com_helpdeskpro&view=ticket&Itemid='.$this->Itemid); ?>" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data">
<!--Toolbar buttons-->	
<div class="row-fluid admintable">
	<?php
		$layoutData = array(
			'categories'    => $this->categories,
			'rowStatuses'   => $this->rowStatuses,
			'rowPriorities' => $this->rowPriorities,
			'isCustomer'    => $this->isCustomer,
			'item'          => $this->item,
			'user'          => $user
		);
		echo HelpdeskproHelperHtml::loadCommonLayout('common/tmpl/toolbar.php', $layoutData);
	?>
</div>
<div class="row-fluid">
	<div id="hdp_left_panel" class="span9">					
		<table class="adminform">		
			<tr>
				<td>
					<strong>
						[#<?php echo $this->item->id ?>] - <?php echo $this->escape($this->item->subject); ?>
					</strong>
				</td>
			</tr>					
			<tr>
				<td>
					<?php
						$layoutData = array(
							'item'          => $this->item,
							'rootUri'       => $rootUri,
							'config'        => $this->config
						);

						echo HelpdeskproHelperHtml::loadCommonLayout('common/tmpl/ticket_detail.php', $layoutData);
					?>						
				</td>
			</tr>
			<tr>
				<th>					
					<h2 class="hdp_heading hdp_comments_heading"><?php echo Text::_('HDP_COMMENTS'); ?>
                        <?php
                            if ($this->canComment)
                            {
                            ?>
                                <a href="javascript:HDP.showMessageBox();">
                                    <span id="hdp_add_comment_link"><?php echo Text::_('HDP_ADD_COMMENT'); ?></span>
                                    <img width="32" height="32" src="<?php echo $rootUri.'/media/com_helpdeskpro/assets/images/icons/icon_add.jpg'?>">
                                </a>
                            <?php
                            }
                        ?>
					</h2>													
				</th>
			</tr>
			<?php
				$layoutData = array(
					'canComment' => $this->canComment,
					'captchaInvalid' => $this->captchaInvalid,
					'config'    => $this->config,
					'maxNumberOfFiles' => $maxNumberOfFiles,
					'rootUri' => $rootUri,
					'editor' => $editor,
					'message' => $this->message,
					'captcha' => isset($this->captcha) ? $this->captcha : ''
				);

				// Comment form
				echo HelpdeskproHelperHtml::loadCommonLayout('common/tmpl/ticket_add_comment.php', $layoutData);

				// List of comments
				$layoutData = array(
					'messages'      => $this->messages,
					'user'          => $user,
					'cbIntegration' => $cbIntegration,
					'rootUri'       => $rootUri,
					'config'        => $this->config
				);
				echo HelpdeskproHelperHtml::loadCommonLayout('common/tmpl/ticket_comments.php', $layoutData);
			?>
	</table>			
</div>		
<div id="hdp_right_panel" class="<?php echo $span9Class; ?>">
	<?php
		// Customer information
		$layoutData = array(
			'item'        => $this->item,
			'fields'      => $this->fields,
			'fieldValues' => $this->fieldValues,
			'rootUri'     => $rootUri,
			'config'      => $this->config,
			'results'     => $this->results
		);

		echo HelpdeskproHelperHtml::loadCommonLayout('common/tmpl/ticket_customer_info.php', $layoutData);
	?>
</div>
</div>
	<input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
	<input type="hidden" name="task" value="" />				
	<input type="hidden" name="new_value" value="0" />
	<input type="hidden" name="Itemid" value="<?php echo $this->Itemid; ?>" />
	
	<?php
		if ($this->item->is_ticket_code) {
		?>
			<input type="hidden" name="ticket_code" value="<?php echo $this->item->ticket_code ?>" />
		<?php	
		}
	?>		
	<?php echo HTMLHelper::_( 'form.token' ); ?>
</form>
</div>