<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined( '_JEXEC' ) or die ;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

$ordering = $this->state->filter_order == 'tbl.ordering';

HTMLHelper::_('bootstrap.tooltip', '.hasTooltip', array('placement' => 'top'));
?>
<div id="hdp_container" class="container-fluid">
	<h1 class="hdp_title"><?php echo Text::_('HDP_ARTICLES'); ?></h1>
	<form action="<?php echo htmlspecialchars(Uri::getInstance()->toString()); ?>" method="post" name="adminForm" id="adminForm" class="form-inline">
		<fieldset class="filters btn-toolbar <?php echo $this->bootstrapHelper->getClassMapping('clearfix'); ?>">
			<div class="btn-group">
				<input type="text" name="filter_search" id="filter_search" value="<?php echo $this->escape($this->state->filter_search); ?>" class="search-query input-xlarge" onchange="document.adminForm.submit();" placeholder="<?php echo Text::_('HDP_ARTICLES_SEARCH_PLACEHOLDER'); ?>" />
			</div>
			<div class="btn-group pull-right">
				<?php echo $this->lists['id']; ?>
			</div>
		</fieldset>
	</form>
	<table class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>
					<?php echo Text::_('HDP_TITLE'); ?>
				</th>
				<th>
					<?php echo Text::_('HDP_HITS'); ?>
				</th>
			</tr>
		</thead>
		<tbody>
		<?php
			foreach($this->items as $item)
			{
			?>
				<tr>
					<td>
						<a href="<?php echo Route::_('index.php?option=com_helpdeskpro&view=article&id='.$item->id.'&Itemid='.$this->Itemid); ?>"><?php echo $item->title;?></a>
					</td>
					<td>
						<spsn class="badge badge-info"><?php echo $item->hits; ?></spsn>
					</td>
				</tr>
			<?php
			}
		?>
		</tbody>
		<?php
		if ($this->pagination->total > $this->pagination->limit)
		{
		?>
			<tfoot>
				<tr>
					<td colspan="2"><?php echo $this->pagination->getPagesLinks();?></td>
				</tr>
			</tfoot>
		<?php
		}
		?>
	</table>
</div>