<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Site\View\Articles;

use HelpdeskProHelperBootstrap;
use OSL\Utils\Database as DatabaseUtils;
use OSL\View\ListView;
use OSSolution\HelpdeskPro\Site\Helper\Database as HelpdeskproHelperDatabase;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskproHelper;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskproHelperHtml;
use OSSolution\HelpdeskPro\Site\Helper\Route as RouteHelper;

defined('_JEXEC') or die;

class Html extends ListView
{
	protected function beforeRender()
	{
		parent::beforeRender();

		// Add articles to route
		RouteHelper::addArticles($this->items);

		$fieldSuffix = HelpdeskproHelper::getFieldSuffix();

		$rows = HelpdeskproHelperDatabase::getAllCategories('title', array(), $fieldSuffix, 2);

		$this->lists['id'] = HelpdeskproHelperHtml::buildCategoryDropdown($this->state->id, 'id', 'class="input-large form-select" onchange="submit();"', $rows);

		// Handle page title
		$active = $this->container->app->getMenu()->getActive();
		$params = HelpdeskproHelperHtml::getViewParams($active, array('categories', 'articles'));

		$category = null;

		if ($this->state->filter_category_id)
		{
			$db    = $this->model->getDbo();
			$query = $db->getQuery(true);
			$query->select('title')
				->from('#__helpdeskpro_categories')
				->where('id = ' . $this->state->filter_category_id);

			if ($fieldSuffix)
			{
				DatabaseUtils::getMultilingualFields($query, array('title'), $fieldSuffix);
			}

			$db->setQuery($query);
			$categoryTitle = $db->loadResult();

			if (!$params->get('page_title') && $categoryTitle)
			{
				$params->set('page_title', $categoryTitle);
			}

			// Pathway
			$pathway = $this->container->app->getPathway();
			$pathway->addItem($categoryTitle);
		}

		HelpdeskproHelperHtml::prepareDocument($params);

		$this->bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
	}
}