<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\Model;

use OSL\Model\AdminModel;

defined('_JEXEC') or die;

class Category extends AdminModel
{
	/**
	 * Prepare and sanitise the table data prior to saving.
	 *
	 * @param \OSSolution\HelpdeskPro\Admin\Table\Category $row A JTable object.
	 *
	 * @return void
	 */
	protected function prepareTable($row, $task)
	{
		$row->parent_id = (int) $row->parent_id;

		if ($row->parent_id > 0)
		{
			// Calculate level
			$db    = $this->getDbo();
			$query = $db->getQuery(true);
			$query->select('`level`')
				->from('#__helpdeskpro_categories')
				->where('id = ' . (int) $row->parent_id);
			$db->setQuery($query);
			$row->level = (int) $db->loadResult() + 1;
		}
		else
		{
			$row->level = 1;
		}

		if ($row->managers)
		{
			$managers      = explode(',', $row->managers);
			$managers      = array_map('trim', $managers);
			$row->managers = implode(',', $managers);
		}

		parent::prepareTable($row, $task);
	}

	/**
	 * A protected method to get a set of ordering conditions.
	 *
	 * @param \OSSolution\HelpdeskPro\Admin\Table\Category $row A JTable object.
	 *
	 * @return array An array of conditions to add to ordering queries.
	 */

	protected function getReorderConditions($row)
	{
		return ['`parent_id` = ' . (int) $row->parent_id];
	}
}