<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Site\Controller;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskproHelper;

defined('_JEXEC') or die;

class Controller extends \OSL\Controller\Controller
{
	/**
	 * Display information
	 *
	 */
	public function display($cachable = false, array $urlparams = [])
	{
		$document = $this->container->document;
		$config   = HelpdeskproHelper::getConfig();
		$rootUri  = Uri::root(true);

		// Load part of twitter bootstrap
		if ($config->load_twttier_bootstrap_framework_in_frontend)
		{
			$document->addStyleSheet($rootUri . '/media/com_helpdeskpro/assets/bootstrap/css/bootstrap.css');
		}

		$document->addStyleSheet($rootUri . '/media/com_helpdeskpro/assets/css/style.css');
		$document->addStyleSheet($rootUri . '/media/com_helpdeskpro/assets/css/common.css');
		$document->addStyleSheet($rootUri . '/media/com_helpdeskpro/assets/dropzone/basic.min.css');
		$document->addStyleSheet($rootUri . '/media/com_helpdeskpro/assets/dropzone/dropzone.min.css');

		$customCssFile = JPATH_ROOT . '/media/com_helpdeskpro/assets/css/custom.css';

		if (file_exists($customCssFile) && filesize($customCssFile))
		{
			$document->addStyleSheet($rootUri . '/media/com_helpdeskpro/assets/css/custom.css');
		}

		$viewName = $this->input->get('view', $this->container->defaultView);

		if (in_array(strtolower($viewName), ['ticket', 'tickets']))
		{
			// Load bootstrap-framework
			HTMLHelper::_('bootstrap.framework');

			// Helpdesk Pro javascript lib
			HTMLHelper::_('script', 'media/com_helpdeskpro/assets/js/helpdeskpro.min.js', false, false);

			// Dropzone JS
			HTMLHelper::_('script', 'media/com_helpdeskpro/assets/dropzone/dropzone.min.js', false, false);
		}


		parent::display($cachable, $urlparams);
	}

	/**
	 * @throws \Exception
	 */
	public function get_reply()
	{
		@header('Content-Type: text/html; charset=utf-8');

		$replyId = $this->input->getInt('reply_id', 0);
		$db      = $this->container->db;
		$query   = $db->getQuery(true);
		$query->select('message')
			->from('#__helpdeskpro_replies')
			->where('id = ' . $replyId);
		$db->setQuery($query);

		echo $db->loadResult();

		$this->container->app->close();
	}
}