<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */
namespace OSSolution\HelpdeskPro\Admin\View\Categories;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use OSL\View\ListView;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskproHelperHtml;

defined('_JEXEC') or die;

class Html extends ListView
{
	protected function beforeRender()
	{
		parent::beforeRender();

		$this->lists['filter_parent_id'] = HelpdeskproHelperHtml::buildCategoryDropdown($this->state->filter_parent_id, 'filter_parent_id', 'onchange="submit();" class="form-select"');

		$options   = array();
		$options[] = HTMLHelper::_('select.option', 0, Text::_('HDP_CATEGORY_TYPE'));
		$options[] = HTMLHelper::_('select.option', 1, Text::_('HDP_TICKETS'));
		$options[] = HTMLHelper::_('select.option', 2, Text::_('HDP_KNOWLEDGE_BASE'));

		$this->lists['filter_category_type'] = HTMLHelper::_('select.genericlist', $options, 'filter_category_type', 'onchange="submit();" class="form-select"', 'value', 'text', $this->state->filter_category_type);
	}
}