<?php
class send{

    public function __construct($bot_token)
    {
        $this->bot_token= $bot_token;
        $this->getupdates_url= "https://tapi.bale.ai/bot{$this->bot_token}/getupdates";
        $this->sendmessage_url= "https://tapi.bale.ai/bot{$this->bot_token}/sendMessage";
    }

    public function send_bale_message($data=[])
    {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $this->sendmessage_url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_POST, 1);
        foreach ($data as $item)
        {
            curl_setopt($curl, CURLOPT_POSTFIELDS, $item);
            $response = curl_exec($curl);
        }

        $response = json_decode($response);
//        $err = curl_error($curl);
        curl_close($curl);
        return $response;
    }

    public function send_sms($mobilenumber, $smsService_input_data, $smsService_pattern_code, $smsService_username, $smsService_password)
    {

        $SoapClient = new SoapClient("http://panel.smsema.com/class/sms/wsdlservice/server.php?wsdl");
        $smsService_from = "+983000505";
        
        for($i=0; $i< 3; $i++)
        {
            $result= $SoapClient->sendPatternSms($smsService_from, (array)$mobilenumber, $smsService_username, $smsService_password, $smsService_pattern_code, $smsService_input_data);
            if ($result)
                return $result;
        }

    }

    public function getMobile($mobile_number_source, $mobile_number_source_field, $user_id)
    {

        $db = JFactory::getDbo();
        $query = $db->getQuery(true);


        if ($mobile_number_source == 'additional') {
            $query->select('value');
            $query->from($db->quoteName('#__fields', 'f'));
            $query->join('inner', $db->quoteName('#__fields_values', 'fv') . 'on' . $db->quoteName('f.id') . '=' . $db->quoteName('fv.field_id'));
            $query->where($db->quoteName('context') . '=' . $db->quote('com_users.user'));
            $query->where($db->quoteName('item_id') . '=' . $user_id);
            $query->where($db->quoteName('f.name') . '=' . $db->quote($mobile_number_source_field));

            $db->setQuery($query);
            $result = $db->loadResult();


        } elseif ($mobile_number_source == 'community_builder') {
            $query->select($mobile_number_source_field);
            $query->from($db->quoteName('#__comprofiler', 'cp'));
            $query->where($db->quoteName('user_id') . '=' . $user_id);


            $db->setQuery($query);
            $result = $db->loadResult();

        }
        elseif ($mobile_number_source == 'username')
        {
            $query->select('username');
            $query->from($db->quoteName('#__users', 'u'));
            $query->where($db->quoteName('id') . '=' . $user_id);


            $db->setQuery($query);
            $result = $db->loadResult();

        }
        
        return $result;
    }


}