<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2022 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Conditional\Trigger;

use CB\Database\Table\FieldTable;
use CB\Database\Table\UserTable;
use CB\Database\Table\ListTable;
use CBLib\Application\Application;
use CB\Plugin\Conditional\CBConditional;

defined('CBLIB') or die();

class UserlistTrigger extends \cbPluginHandler
{

	/**
	 * @param ListTable    $row
	 * @param UserTable[]  $users
	 * @param array        $columns
	 * @param FieldTable[] $fields
	 * @param array        $input
	 * @param int          $listid
	 * @param string|null  $search
	 * @param int          $Itemid
	 * @param int          $ui
	 */
	public function listDisplay( &$row, &$users, &$columns, &$fields, &$input, $listid, &$search, &$Itemid, $ui )
	{
		if ( ( ! Application::Application()->isClient( 'administrator' ) ) && ( $search !== null ) && $users ) {
			foreach( $users as $k => $user ) {
				if ( ! isset( $users[$k] ) ) {
					continue;
				}

				foreach ( $fields as $field ) {
					// We're only removing users if the field being searched has been conditioned away for that user:
					if ( $field->getBool( '_noCondition', false ) || CBConditional::isFieldEmpty( $field, $this->getInput()->getRaw( $field->getString( 'name' ) ) ) ) {
						continue;
					}

					$conditioned		=	CBConditional::getTabConditional( $field->getInt( 'tabid', 0 ), 'list', $user->getInt( 'id', 0 ) );

					if ( ! $conditioned ) {
						$conditioned	=	CBConditional::getFieldConditional( $field, 'list', $user->getInt( 'id', 0 ) );
					}

					if ( $conditioned ) {
						unset( $users[$k] );
					}
				}
			}
		}
	}
}