<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Database\Table\TabTable;
use CB\Plugin\AntiSpam\Table\BlockTable;
use CBLib\Registry\GetterInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var cbantispamTab $this
 * @var BlockTable[]  $rows
 * @var cbPageNav     $pageNav
 * @var UserTable     $viewer
 * @var UserTable     $user
 * @var TabTable      $tab
 * @var string        $returnUrl
 */

$buttons			=	array();

if ( $tab->params->get( 'tab_block_account', true, GetterInterface::BOOLEAN ) ) {
	$buttons[]		=	'<button type="button" onclick="window.location.href=\'' . $_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'block', 'func' => 'account', 'user' => $user->get( 'id', 0, GetterInterface::INT ), 'return' => $returnUrl ) ) . '\';" class="btn btn-secondary btn-sm-block blocksButton blocksButtonBlockAccount"><span class="fa fa-user"></span> ' . CBTxt::T( 'Block Account' ) . '</button>';
}

if ( $tab->params->get( 'tab_block_user', true, GetterInterface::BOOLEAN ) ) {
	$buttons[]		=	'<button type="button" onclick="window.location.href=\'' . $_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'block', 'func' => 'user', 'user' => $user->get( 'id', 0, GetterInterface::INT ), 'return' => $returnUrl ) ) . '\';" class="btn btn-secondary btn-sm-block blocksButton blocksButtonBlockUser"><span class="fa fa-user"></span> ' . CBTxt::T( 'Block User' ) . '</button>';
}

if ( $tab->params->get( 'tab_block_ip', true, GetterInterface::BOOLEAN ) ) {
	$buttons[]		=	'<button type="button" onclick="window.location.href=\'' . $_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'block', 'func' => 'ip', 'user' => $user->get( 'id', 0, GetterInterface::INT ), 'return' => $returnUrl ) ) . '\';" class="btn btn-secondary btn-sm-block blocksButton blocksButtonBlockIP"><span class="fa fa-flag"></span> ' . CBTxt::T( 'Block IP Address' ) . '</button>';
}

if ( $tab->params->get( 'tab_block_email', false, GetterInterface::BOOLEAN ) ) {
	$buttons[]		=	'<button type="button" onclick="window.location.href=\'' . $_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'block', 'func' => 'email', 'user' => $user->get( 'id', 0, GetterInterface::INT ), 'return' => $returnUrl ) ) . '\';" class="btn btn-secondary btn-sm-block blocksButton blocksButtonBlockEmail"><span class="fa fa-at"></span> ' . CBTxt::T( 'Block Email Address' ) . '</button>';
}

if ( $tab->params->get( 'tab_block_domain', false, GetterInterface::BOOLEAN ) ) {
	$buttons[]		=	'<button type="button" onclick="window.location.href=\'' . $_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'block', 'func' => 'domain', 'user' => $user->get( 'id', 0, GetterInterface::INT ), 'return' => $returnUrl ) ) . '\';" class="btn btn-secondary btn-sm-block blocksButton blocksButtonBlockDomain"><span class="fa fa-globe"></span> ' . CBTxt::T( 'Block Email Domain' ) . '</button>';
}
?>
<div class="blocksTab">
	<form action="<?php echo $_CB_framework->userProfileUrl( $user->get( 'id', 0, GetterInterface::INT ), true, $tab->get( 'tabid', 0, GetterInterface::INT ) ); ?>" method="post" name="blocksForm" class="m-0 blocksForm">
		<?php if ( $buttons ) { ?>
		<div class="mb-2 blocksHeader">
			<?php echo implode( ' ', $buttons ); ?>
		</div>
		<?php } ?>
		<div class="table-responsive blocksItemsContainer">
			<table class="table table-hover mb-0">
				<thead>
					<tr class="blocksItemsHeader">
						<th><?php echo CBTxt::T( 'Value' ); ?></th>
						<th style="width: 20%;" class="text-center d-none d-sm-table-cell"><?php echo CBTxt::T( 'Type' ); ?></th>
						<th style="width: 25%;" class="d-none d-sm-table-cell"><?php echo CBTxt::T( 'Date' ); ?></th>
						<th style="width: 5%;" class="text-center"><?php echo CBTxt::T( 'Blocked' ); ?></th>
						<th style="width: 1%;">&nbsp;</th>
					</tr>
				</thead>
				<tbody>
				<?php if ( $rows ) foreach ( $rows as $row ) {
					$menuItems		=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 blocksMenuItems">'
									.		'<li class="blocksMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'block', 'func' => 'edit', 'id' => $row->get( 'id', 0, GetterInterface::INT ), 'return' => $returnUrl ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>'
									.		'<li class="blocksMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this block?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'block', 'func' => 'delete', 'id' => $row->get( 'id', 0, GetterInterface::INT ), 'return' => $returnUrl ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>'
									.	'</ul>';

					$menuAttr		=	cbTooltip( null, $menuItems, null, 'auto', null, null, null, 'class="btn btn-secondary btn-sm blocksMenu" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' );

					switch ( $row->get( 'type', null, GetterInterface::STRING ) ) {
						case 'user':
							$type	=	CBTxt::T( 'User' );
							break;
						case 'ip':
							$type	=	CBTxt::T( 'IP Address' );
							break;
						case 'email':
							$type	=	CBTxt::T( 'Email Address' );
							break;
						case 'domain':
							$type	=	CBTxt::T( 'Email Domain' );
							break;
						default:
							$type	=	CBTxt::T( 'Unknown' );
							break;
					}
				?>
				<tr class="blocksItemContainer">
					<td><?php echo $row->get( 'value', null, GetterInterface::STRING ); ?></td>
					<td style="width: 20%;" class="text-center d-none d-sm-table-cell"><?php echo $type; ?></td>
					<td style="width: 25%;" class="d-none d-sm-table-cell">
						<?php if ( $row->get( 'duration', null, GetterInterface::STRING ) ) { ?>
						<div class="text-info" title="<?php echo htmlspecialchars( CBTxt::T( 'Start' ) ); ?>"><?php echo cbFormatDate( $row->get( 'date', null, GetterInterface::STRING ), false ); ?></div>
						<div class="text-success" title="<?php echo htmlspecialchars( CBTxt::T( 'End' ) ); ?>"><?php echo cbFormatDate( $row->expiry(), false ); ?></div>
						<?php } else { ?>
							<?php echo CBTxt::T( 'Forever' ); ?>
						<?php } ?>
					</td>
					<td style="width: 5%;" class="text-center">
						<?php if ( $row->blocked() ) { ?>
						<span class="fa fa-check text-success" title="<?php echo htmlspecialchars( CBTxt::T( 'Blocked' ) ); ?>"></span>
						<?php } else { ?>
						<span class="fa fa-times text-danger" title="<?php echo htmlspecialchars( CBTxt::T( 'Not Blocked' ) ); ?>"></span>
						<?php } ?>
					</td>
					<td style="width: 1%;" class="text-right">
						<button type="button"<?php echo $menuAttr; ?>><span class="fa fa-cog"></span> <span class="fa fa-caret-down"></span></button>
					</td>
				</tr>
				<?php } else { ?>
				<tr class="blocksItemsEmpty">
					<td colspan="5">
						<?php if ( $viewer->get( 'id', 0, GetterInterface::INT ) == $user->get( 'id', 0, GetterInterface::INT ) ) { ?>
							<?php echo CBTxt::T( 'You have no blocks.' ); ?>
						<?php } else { ?>
							<?php echo CBTxt::T( 'This user has no blocks.' ); ?>
						<?php } ?>
						</td>
					</tr>
				<?php } ?>
				</tbody>
				<?php if ( $tab->params->get( 'tab_paging', true, GetterInterface::BOOLEAN ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
				<tfoot>
					<tr class="blocksItemsPaging">
						<td colspan="5" class="text-center">
							<?php echo $pageNav->getListLinks(); ?>
						</td>
					</tr>
				</tfoot>
				<?php } ?>
			</table>
		</div>
		<?php echo $pageNav->getLimitBox( false ); ?>
	</form>
</div>