<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\CategoryTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveCategories
{

	/**
	 * render frontend categories
	 *
	 * @param CategoryTable[]    $rows
	 * @param cbPageNav          $pageNav
	 * @param bool               $searching
	 * @param array              $input
	 * @param UserTable          $user
	 * @param CBplug_cbgroupjive $plugin
	 */
	public static function showCategories( $rows, $pageNav, $searching, $input, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		$_CB_framework->setPageTitle( CBTxt::T( 'Categories' ) );

		initToolTip();

		$canCreateGroup					=	CBGroupJive::canCreateGroup( $user );
		$canSearch						=	( $plugin->params->getInt( 'categories_search', 1 ) && ( $searching || $pageNav->total ) );
		$return							=	null;

		$_PLUGINS->trigger( 'gj_onBeforeDisplayCategories', array( &$return, &$rows, $user ) );

		$return							.=	'<div class="gjCategories">';

		if ( $canCreateGroup || $canSearch ) {
			$return						.=		'<div class="row no-gutters mb-3 gjHeader gjCategoriesHeader">';

			if ( $canCreateGroup ) {
				$return					.=			'<div class="col-12 ' . ( $canSearch ? 'col-sm-6 mb-2 mb-sm-0' : null ) . '">'
										.				'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'new', 'return' => CBGroupJive::getReturn() ) ) . '" class="btn btn-success btn-sm-block gjButton gjButtonNewGroup"><span class="fa fa-plus-circle"></span> ' . CBTxt::T( 'Create New Group' ) . '</a>'
										.			'</div>';
			}

			if ( $canSearch ) {
				$return					.=			'<div class="col-12 ' . ( ! $canCreateGroup ? 'offset-sm-6 ' : null ) . 'col-sm-6 text-sm-right">'
										.				'<form action="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'categories', 'func' => 'all', 'categories' => $plugin->getInput()->getString( 'categories' ) ) ) . '" method="post" name="gjCategoriesSearchForm" class="m-0 gjCategoriesSearchForm">'
										.					'<div class="input-group">'
										.						$input['search']
										.						'<div class="input-group-append">'
										.							'<button type="submit" class="btn btn-light border" aria-label="' . htmlspecialchars( CBTxt::T( 'Search' ) ) . '"><span class="fa fa-search"></span></button>'
										.						'</div>'
										.					'</div>'
										.				'</form>'
										.			'</div>';
			}

			$return						.=		'</div>';
		}

		if ( $rows ) {
			$return						.=		'<div class="ml-n2 mr-n2 mb-n3 row no-gutters gjCategoriesRows">';

			foreach ( $rows as $row ) {
				$cssClass				=	$row->getString( 'css' );
				$counters				=	array();
				$content				=	null;

				$_PLUGINS->trigger( 'gj_onDisplayCategory', array( &$row, &$counters, &$content, $user ) );

				$return					.=			'<div class="col-12 col-md-6 col-lg-4 pb-3 pl-2 pr-2 gjCategoriesCategory gjCategoriesCategory' . $row->getInt( 'id', 0 ) . ( $cssClass ? ' ' . htmlspecialchars( $cssClass ) : null ) . '">'
										.				'<div class="h-100 card no-overflow cbCanvasLayout cbCanvasLayoutMd">'
										.					'<div class="card-header p-0 position-relative cbCanvasLayoutTop">'
										.						'<div class="position-absolute cbCanvasLayoutBackground">'
										.							$row->canvas( true, true, true )
										.						'</div>'
										.					'</div>'
										.					'<div class="position-relative cbCanvasLayoutBottom">'
										.						'<div class="position-absolute cbCanvasLayoutPhoto">'
										.							$row->logo( true, true, true )
										.						'</div>'
										.					'</div>'
										.					'<div class="d-flex flex-column card-body p-0 position-relative cbCanvasLayoutBody">'
										.						'<div class="flex-grow-1 ml-2 mr-2 mt-2 text-truncate cbCanvasLayoutContent">'
										.							'<strong><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'categories', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="text-large">' . CBTxt::T( $row->getString( 'name' ) ) . '</a></strong>'
										.						'</div>'
										.						'<div class="border-top pl-2 pr-2 pt-2 mt-2 mb-2 text-small text-muted row no-gutters cbCanvasLayoutContent">'
										.							'<div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent gjCategoriesCategoryIconGroups"><span class="fa-before fa-globe"> ' . CBTxt::T( 'GROUPS_COUNT', '%%COUNT%% Group|%%COUNT%% Groups', array( '%%COUNT%%' => $row->getInt( '_groups', 0 ) ) ) . '</span></div>'
										.							( $counters ? '<div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent">' . implode( '</div><div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent">', $counters ) . '</div>' : null )
										.						'</div>'
										.						( $content ? '<div class="m-2 cbCanvasLayoutContent gjCategoriesCategoryIntegrations">' . $content . '</div>' : null );


				if ( $row->getString( 'description' ) ) {
					$return				.=						'<div class="gjCanvasDescription gjCategoriesCategoryDescription">'
										.							cbTooltip( null, $row->getString( 'description' ), null, null, null, '<span class="bg-white border rounded-circle p-1 pl-2 pr-2 text-small fa fa-info text-muted"></span>' )
										.						'</div>';
				}

				$return					.=					'</div>'
										.				'</div>'
										.			'</div>';
			}

			$return						.=		'</div>';

			if ( $plugin->params->getInt( 'categories_paging', 1 ) && ( $pageNav->total > $pageNav->limit ) ) {
				$return					.=		'<div class="mt-3 gjCategoriesPaging">'
										.			$pageNav->getListLinks()
										.		'</div>';
			}
		} else {
			$return						.=		'<div class="gjCategoriesEmpty">';

			if ( $searching ) {
				$return					.=			CBTxt::T( 'No category search results found.' );
			} else {
				$return					.=			CBTxt::T( 'There are no categories available.' );
			}

			$return						.=		'</div>';
		}

		$return							.=	'</div>';

		$_CB_framework->setMenuMeta();

		$_PLUGINS->trigger( 'gj_onAfterDisplayCategories', array( &$return, &$rows, $user ) );

		echo $return;
	}
}